/*
 * Decompiled with CFR 0.152.
 */
package com.xinpure.wechatwork;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.tencent.wework.api.IWWAPI;
import com.tencent.wework.api.IWWAPIEventHandler;
import com.tencent.wework.api.WWAPIFactory;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.WWAuthMessage;
import com.tencent.wework.api.model.WWMediaImage;
import com.tencent.wework.api.model.WWMediaLink;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;

public class RNWeChatWorkModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;
    private final String WeChatWorkEventName = "EventWeChatWork";
    private DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter;
    private IWWAPI iwwapi;
    private String APPID = "";
    private String AGENTID = "";
    private String SCHEMA = "";
    private static final String NOT_REGISTERED = "registerApp required.";
    private static final String INVOKE_FAILED = "WeChat API invoke returns false.";
    private static final String INVALID_ARGUMENT = "invalid argument.";
    private static final int THUMB_SIZE = 32;

    private static byte[] bitmapTopBytes(Bitmap bitmap) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        bitmap.recycle();
        return baos.toByteArray();
    }

    private static byte[] bitmapResizeGetBytes(Bitmap image, int size) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        image.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
        int options = 100;
        while (baos.toByteArray().length / 1024 > size) {
            baos.reset();
            if (options <= 10) {
                return RNWeChatWorkModule.bitmapResizeGetBytes(Bitmap.createScaledBitmap((Bitmap)image, (int)280, (int)(image.getHeight() / image.getWidth() * 280), (boolean)true), size);
            }
            image.compress(Bitmap.CompressFormat.JPEG, options -= 8, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    public RNWeChatWorkModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "WeChatWork";
    }

    @ReactMethod
    public void registerApp(String schema, String appId, String agentId, Callback callback) {
        this.SCHEMA = schema;
        this.APPID = appId;
        this.AGENTID = agentId;
        this.iwwapi = WWAPIFactory.createWWAPI((Context)this.reactContext);
        this.eventEmitter = (DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class);
        callback.invoke(new Object[]{null, this.iwwapi.registerApp(this.SCHEMA)});
    }

    @ReactMethod
    public void isAppInstalled(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.isWWAppInstalled()});
    }

    @ReactMethod
    public void isAppSupportApi(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.isWWAppSupportAPI()});
    }

    @ReactMethod
    public void getApiVersion(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.getWWAppSupportAPI()});
    }

    @ReactMethod
    public void getAppInstallUrl(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, ""});
    }

    @ReactMethod
    public void openApp(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.openWWApp()});
    }

    @ReactMethod
    public void SSOAuth(String state) {
        this.SSO(state);
    }

    @ReactMethod
    public void shareLinkAttachment(ReadableMap data) {
        if (this.iwwapi == null) {
            return;
        }
        WWMediaLink link = new WWMediaLink();
        link.description = data.getString("description");
        link.webpageUrl = data.getString("url");
        link.thumbUrl = data.getString("thumbImageUrl");
        link.title = data.getString("title");
        link.appId = this.APPID;
        link.agentId = this.AGENTID;
        this.iwwapi.sendMessage((BaseMessage)link);
    }

    @ReactMethod
    public void shareLocalImage(String url) {
        FileInputStream fs = null;
        try {
            if (this.iwwapi == null) {
                return;
            }
            if (url.indexOf("file://") > -1) {
                url = url.substring(7);
            }
            fs = new FileInputStream(url);
            Bitmap bmp = BitmapFactory.decodeStream((InputStream)fs);
            WWMediaImage img = new WWMediaImage();
            img.transaction = "img";
            img.thumbData = RNWeChatWorkModule.bitmapResizeGetBytes(bmp, 32);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            bmp.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)baos);
            img.fileData = baos.toByteArray();
            bmp.recycle();
            img.appId = this.APPID;
            img.agentId = this.AGENTID;
            this.iwwapi.sendMessage((BaseMessage)img);
        }
        catch (FileNotFoundException err) {
            err.printStackTrace();
        }
    }

    public void SSO(String state) {
        if (this.iwwapi == null) {
            return;
        }
        WWAuthMessage.Req req = new WWAuthMessage.Req();
        req.sch = this.SCHEMA;
        req.appId = this.APPID;
        req.agentId = this.AGENTID;
        req.state = state;
        this.iwwapi.sendMessage((BaseMessage)req, new IWWAPIEventHandler(){

            public void handleResp(BaseMessage resp) {
                WritableMap map = Arguments.createMap();
                if (resp instanceof WWAuthMessage.Resp) {
                    WWAuthMessage.Resp rsp = (WWAuthMessage.Resp)resp;
                    map.putInt("errCode", rsp.errCode);
                    map.putString("code", rsp.code);
                    map.putString("state", rsp.state);
                    map.putString("type", "SSOAuth.Resp");
                    if (rsp.errCode == -1) {
                        map.putString("errStr", "SSOAuth Cancel");
                    } else if (rsp.errCode == 1) {
                        map.putString("errStr", "SSOAuth Failed");
                    } else if (rsp.errCode == 0) {
                        map.putString("errStr", "SSOAuth OK");
                    }
                }
                RNWeChatWorkModule.this.eventEmitter.emit("EventWeChatWork", (Object)map);
            }
        });
    }
}

