/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.model;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;

public class WWAuthMessage {
    public static final int ERR_CANCEL = -1;
    public static final int ERR_OK = 0;
    public static final int ERR_FAIL = 1;

    public static class Resp
    extends WWBaseRespMessage {
        public String code;
        public String state;
        public int errCode = -1;
        public String schema;

        @Override
        public int getType() {
            return 2001;
        }

        @Override
        public void toBundle(Bundle var1) {
            var1.putString("_wwauthrsp_code", this.code);
            var1.putString("_wwauthrsp_state", this.state);
            var1.putInt("_wwauthrsp_err", this.errCode);
            super.toBundle(var1);
        }

        @Override
        public void fromBundle(Bundle var1) {
            this.code = var1.getString("_wwauthrsp_code");
            this.state = var1.getString("_wwauthrsp_state");
            this.errCode = var1.getInt("_wwauthrsp_err", -1);
            super.fromBundle(var1);
        }

        @Override
        public Intent toIntent() {
            Intent intent = new Intent(this.schema, Resp.packUri(this));
            intent.setPackage(this.descPkg);
            Bundle b = new Bundle();
            this.toBundle(b);
            intent.putExtras(b);
            return intent;
        }

        @Override
        public Uri toUri() {
            Uri uri = super.toUri();
            uri = uri.buildUpon().scheme(this.schema).authority("sso").appendQueryParameter("code", this.code == null ? "" : this.code).appendQueryParameter("state", this.state == null ? "" : this.state).appendQueryParameter("errcode", String.valueOf(this.errCode)).build();
            return uri;
        }

        @Override
        public void fromUri(Uri uri) {
            super.fromUri(uri);
            if (uri == null) {
                return;
            }
            this.errCode = -100;
            try {
                this.errCode = Integer.parseInt(uri.getQueryParameter("errcode"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.code = uri.getQueryParameter("code");
            this.state = uri.getQueryParameter("state");
            if (this.errCode == -1) {
                return;
            }
            this.errCode = TextUtils.isEmpty((CharSequence)this.code) ? 1 : 0;
        }
    }

    public static class Req
    extends WWBaseMessage {
        public String state;
        public String sch;

        public Req() {
        }

        public Req(String stat, String schema) {
            this.state = stat;
            this.sch = schema;
        }

        @Override
        public int getType() {
            return 1001;
        }

        @Override
        public boolean checkArgs() {
            return !TextUtils.isEmpty((CharSequence)this.appId) && !TextUtils.isEmpty((CharSequence)this.agentId) && !TextUtils.isEmpty((CharSequence)this.sch);
        }

        @Override
        public void toBundle(Bundle var1) {
            var1.putString("_wwauthmsg_state", this.state);
            var1.putString("_wwauthmsg_schema", this.sch);
            super.toBundle(var1);
        }

        @Override
        public void fromBundle(Bundle var1) {
            this.state = var1.getString("_wwauthmsg_state");
            this.sch = var1.getString("_wwauthmsg_schema");
            super.fromBundle(var1);
        }
    }
}

