/*
 * Decompiled with CFR 0.152.
 */
package com.xinpure.wechatwork;

import android.content.Context;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.tencent.wework.api.IWWAPI;
import com.tencent.wework.api.IWWAPIEventHandler;
import com.tencent.wework.api.WWAPIFactory;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.WWAuthMessage;

public class RNWeChatWorkModule
extends ReactContextBaseJavaModule {
    private final ReactApplicationContext reactContext;
    private final String WeChatWorkEventName = "EventWeChatWork";
    private DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter;
    private IWWAPI iwwapi;
    private String APPID = "";
    private String AGENTID = "";
    private String SCHEMA = "";
    private static final String NOT_REGISTERED = "registerApp required.";
    private static final String INVOKE_FAILED = "WeChat API invoke returns false.";
    private static final String INVALID_ARGUMENT = "invalid argument.";

    public RNWeChatWorkModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.reactContext = reactContext;
    }

    public String getName() {
        return "WeChatWork";
    }

    @ReactMethod
    public void registerApp(String schema, String appId, String agentId, Callback callback) {
        this.SCHEMA = schema;
        this.APPID = appId;
        this.AGENTID = agentId;
        this.iwwapi = WWAPIFactory.createWWAPI((Context)this.reactContext);
        this.eventEmitter = (DeviceEventManagerModule.RCTDeviceEventEmitter)this.reactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class);
        callback.invoke(new Object[]{null, this.iwwapi.registerApp(this.SCHEMA)});
    }

    @ReactMethod
    public void isAppInstalled(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.isWWAppInstalled()});
    }

    @ReactMethod
    public void isAppSupportApi(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.isWWAppSupportAPI()});
    }

    @ReactMethod
    public void getApiVersion(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.getWWAppSupportAPI()});
    }

    @ReactMethod
    public void getAppInstallUrl(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, ""});
    }

    @ReactMethod
    public void openApp(Callback callback) {
        if (this.iwwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.iwwapi.openWWApp()});
    }

    @ReactMethod
    public void SSOAuth(String state) {
        this.SSO(state);
    }

    public void SSO(String state) {
        if (this.iwwapi == null) {
            return;
        }
        WWAuthMessage.Req req = new WWAuthMessage.Req();
        req.sch = this.SCHEMA;
        req.appId = this.APPID;
        req.agentId = this.AGENTID;
        req.state = state;
        this.iwwapi.sendMessage((BaseMessage)req, new IWWAPIEventHandler(){

            public void handleResp(BaseMessage resp) {
                WritableMap map = Arguments.createMap();
                if (resp instanceof WWAuthMessage.Resp) {
                    WWAuthMessage.Resp rsp = (WWAuthMessage.Resp)resp;
                    map.putInt("errCode", rsp.errCode);
                    map.putString("code", rsp.code);
                    map.putString("state", rsp.state);
                    map.putString("type", "SSOAuth.Resp");
                    if (rsp.errCode == -1) {
                        map.putString("errStr", "SSOAuth Cancel");
                    } else if (rsp.errCode == 1) {
                        map.putString("errStr", "SSOAuth Failed");
                    } else if (rsp.errCode == 0) {
                        map.putString("errStr", "SSOAuth OK");
                    }
                }
                RNWeChatWorkModule.this.eventEmitter.emit("EventWeChatWork", (Object)map);
            }
        });
    }
}

