/*
 * Decompiled with CFR 0.152.
 */
package com.theweflex.react;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.facebook.common.executors.UiThreadImmediateExecutorService;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.datasource.BaseBitmapDataSubscriber;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.tencent.mm.sdk.modelbase.BaseReq;
import com.tencent.mm.sdk.modelmsg.SendAuth;
import com.tencent.mm.sdk.modelmsg.SendMessageToWX;
import com.tencent.mm.sdk.modelmsg.WXFileObject;
import com.tencent.mm.sdk.modelmsg.WXImageObject;
import com.tencent.mm.sdk.modelmsg.WXMediaMessage;
import com.tencent.mm.sdk.modelmsg.WXMusicObject;
import com.tencent.mm.sdk.modelmsg.WXTextObject;
import com.tencent.mm.sdk.modelmsg.WXVideoObject;
import com.tencent.mm.sdk.modelmsg.WXWebpageObject;
import com.tencent.mm.sdk.modelpay.PayReq;
import com.tencent.mm.sdk.openapi.IWXAPI;
import com.tencent.mm.sdk.openapi.WXAPIFactory;
import com.tencent.wework.api.IWWAPI;
import com.tencent.wework.api.IWWAPIEventHandler;
import com.tencent.wework.api.WWAPIFactory;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.WWAuthMessage;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.Executor;

public class WeChatModule
extends ReactContextBaseJavaModule
implements IWWAPIEventHandler {
    private String appId;
    private String schema;
    private IWXAPI wxapi = null;
    private IWWAPI wwapi = null;
    private static final String NOT_REGISTERED = "registerApp required.";
    private static final String INVOKE_FAILED = "WeChat API invoke returns false.";
    private static final String INVALID_ARGUMENT = "invalid argument.";
    private static ArrayList<WeChatModule> modules = new ArrayList();

    public WeChatModule(ReactApplicationContext context) {
        super(context);
    }

    public String getName() {
        return "RCTWeChat";
    }

    public boolean canOverrideExistingModule() {
        return true;
    }

    public void initialize() {
        super.initialize();
        modules.add(this);
    }

    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        if (this.wxapi != null) {
            this.wxapi = null;
        }
        modules.remove((Object)this);
    }

    public static void handleIntent(Intent intent) {
        for (WeChatModule mod : modules) {
            mod.wwapi.handleIntent(intent, (IWWAPIEventHandler)mod);
        }
    }

    @ReactMethod
    public void registerApp(String appid, Callback callback) {
        this.appId = appid;
        this.wxapi = WXAPIFactory.createWXAPI((Context)this.getReactApplicationContext().getBaseContext(), (String)appid, (boolean)true);
        callback.invoke(new Object[]{null, this.wxapi.registerApp(appid)});
    }

    @ReactMethod
    public void registerWWApp(String schema, Callback callback) {
        this.schema = schema;
        this.wwapi = WWAPIFactory.createWWAPI((Context)this.getReactApplicationContext().getBaseContext());
        callback.invoke(new Object[]{null, this.wwapi.registerApp(schema)});
    }

    @ReactMethod
    public void isWXAppInstalled(Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wxapi.isWXAppInstalled()});
    }

    @ReactMethod
    public void isWWAppInstalled(Callback callback) {
        if (this.wwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wwapi.isWWAppInstalled()});
    }

    @ReactMethod
    public void isWXAppSupportApi(Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wxapi.isWXAppSupportAPI()});
    }

    @ReactMethod
    public void isWWAppSupportApi(Callback callback) {
        if (this.wwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wwapi.isWWAppSupportAPI()});
    }

    @ReactMethod
    public void getApiVersion(Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wxapi.getWXAppSupportAPI()});
    }

    @ReactMethod
    public void getWWApiVersion(Callback callback) {
        if (this.wwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wwapi.getWWAppSupportAPI()});
    }

    @ReactMethod
    public void openWXApp(Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wxapi.openWXApp()});
    }

    @ReactMethod
    public void openWWApp(Callback callback) {
        if (this.wwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        callback.invoke(new Object[]{null, this.wwapi.openWWApp()});
    }

    @ReactMethod
    public void sendAuthRequest(String scope, String state, Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        SendAuth.Req req = new SendAuth.Req();
        req.scope = scope;
        req.state = state;
        callback.invoke(new Object[]{null, this.wxapi.sendReq((BaseReq)req)});
    }

    @ReactMethod
    public void sendWWAuthRequest(String schema, String appid, String agentid, Callback callback) {
        if (this.wwapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        WWAuthMessage.Req req = new WWAuthMessage.Req();
        req.sch = schema;
        req.appId = appid;
        req.agentId = agentid;
        req.state = "dd";
        callback.invoke(new Object[]{null, this.wwapi.sendMessage((BaseMessage)req, (IWWAPIEventHandler)this)});
    }

    @ReactMethod
    public void shareToTimeline(ReadableMap data, Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        this._share(1, data, callback);
    }

    @ReactMethod
    public void shareToSession(ReadableMap data, Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        this._share(0, data, callback);
    }

    @ReactMethod
    public void shareToFavorite(ReadableMap data, Callback callback) {
        if (this.wxapi == null) {
            callback.invoke(new Object[]{NOT_REGISTERED});
            return;
        }
        this._share(2, data, callback);
    }

    @ReactMethod
    public void pay(ReadableMap data, Callback callback) {
        PayReq payReq = new PayReq();
        if (data.hasKey("partnerId")) {
            payReq.partnerId = data.getString("partnerId");
        }
        if (data.hasKey("prepayId")) {
            payReq.prepayId = data.getString("prepayId");
        }
        if (data.hasKey("nonceStr")) {
            payReq.nonceStr = data.getString("nonceStr");
        }
        if (data.hasKey("timeStamp")) {
            payReq.timeStamp = data.getString("timeStamp");
        }
        if (data.hasKey("sign")) {
            payReq.sign = data.getString("sign");
        }
        if (data.hasKey("package")) {
            payReq.packageValue = data.getString("package");
        }
        if (data.hasKey("extData")) {
            payReq.extData = data.getString("extData");
        }
        payReq.appId = this.appId;
        callback.invoke(new Object[]{this.wxapi.sendReq((BaseReq)payReq) ? null : INVOKE_FAILED});
    }

    private void _share(final int scene, final ReadableMap data, final Callback callback) {
        Uri uri = null;
        if (data.hasKey("thumbImage")) {
            String imageUrl = data.getString("thumbImage");
            try {
                uri = Uri.parse((String)imageUrl);
                if (uri.getScheme() == null) {
                    uri = WeChatModule.getResourceDrawableUri((Context)this.getReactApplicationContext(), imageUrl);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (uri != null) {
            this._getImage(uri, new ResizeOptions(100, 100), new ImageCallback(){

                @Override
                public void invoke(@Nullable Bitmap bitmap) {
                    WeChatModule.this._share(scene, data, bitmap, callback);
                }
            });
        } else {
            this._share(scene, data, null, callback);
        }
    }

    private void _getImage(Uri uri, ResizeOptions resizeOptions, final ImageCallback imageCallback) {
        BaseBitmapDataSubscriber dataSubscriber = new BaseBitmapDataSubscriber(){

            protected void onNewResultImpl(Bitmap bitmap) {
                bitmap = bitmap.copy(bitmap.getConfig(), true);
                imageCallback.invoke(bitmap);
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                imageCallback.invoke(null);
            }
        };
        ImageRequestBuilder builder = ImageRequestBuilder.newBuilderWithSource((Uri)uri);
        if (resizeOptions != null) {
            builder = builder.setResizeOptions(resizeOptions);
        }
        ImageRequest imageRequest = builder.build();
        ImagePipeline imagePipeline = Fresco.getImagePipeline();
        DataSource dataSource = imagePipeline.fetchDecodedImage(imageRequest, null);
        dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)UiThreadImmediateExecutorService.getInstance());
    }

    private static Uri getResourceDrawableUri(Context context, String name) {
        if (name == null || name.isEmpty()) {
            return null;
        }
        name = name.toLowerCase().replace("-", "_");
        int resId = context.getResources().getIdentifier(name, "drawable", context.getPackageName());
        if (resId == 0) {
            return null;
        }
        return new Uri.Builder().scheme("res").path(String.valueOf(resId)).build();
    }

    private void _share(final int scene, final ReadableMap data, final Bitmap thumbImage, final Callback callback) {
        if (!data.hasKey("type")) {
            callback.invoke(new Object[]{INVALID_ARGUMENT});
            return;
        }
        String type = data.getString("type");
        WXWebpageObject mediaObject = null;
        if (type.equals("news")) {
            mediaObject = this._jsonToWebpageMedia(data);
        } else if (type.equals("text")) {
            mediaObject = this._jsonToTextMedia(data);
        } else {
            if (type.equals("imageUrl") || type.equals("imageResource")) {
                this.__jsonToImageUrlMedia(data, new MediaObjectCallback(){

                    @Override
                    public void invoke(@Nullable WXMediaMessage.IMediaObject mediaObject) {
                        if (mediaObject == null) {
                            callback.invoke(new Object[]{WeChatModule.INVALID_ARGUMENT});
                        } else {
                            WeChatModule.this._share(scene, data, thumbImage, mediaObject, callback);
                        }
                    }
                });
                return;
            }
            if (type.equals("imageFile")) {
                this.__jsonToImageFileMedia(data, new MediaObjectCallback(){

                    @Override
                    public void invoke(@Nullable WXMediaMessage.IMediaObject mediaObject) {
                        if (mediaObject == null) {
                            callback.invoke(new Object[]{WeChatModule.INVALID_ARGUMENT});
                        } else {
                            WeChatModule.this._share(scene, data, thumbImage, mediaObject, callback);
                        }
                    }
                });
                return;
            }
            if (type.equals("video")) {
                mediaObject = this.__jsonToVideoMedia(data);
            } else if (type.equals("audio")) {
                mediaObject = this.__jsonToMusicMedia(data);
            } else if (type.equals("file")) {
                mediaObject = this.__jsonToFileMedia(data);
            }
        }
        if (mediaObject == null) {
            callback.invoke(new Object[]{INVALID_ARGUMENT});
        } else {
            this._share(scene, data, thumbImage, (WXMediaMessage.IMediaObject)mediaObject, callback);
        }
    }

    private void _share(int scene, ReadableMap data, Bitmap thumbImage, WXMediaMessage.IMediaObject mediaObject, Callback callback) {
        WXMediaMessage message = new WXMediaMessage();
        message.mediaObject = mediaObject;
        if (thumbImage != null) {
            message.setThumbImage(thumbImage);
        }
        if (data.hasKey("title")) {
            message.title = data.getString("title");
        }
        if (data.hasKey("description")) {
            message.description = data.getString("description");
        }
        if (data.hasKey("mediaTagName")) {
            message.mediaTagName = data.getString("mediaTagName");
        }
        if (data.hasKey("messageAction")) {
            message.messageAction = data.getString("messageAction");
        }
        if (data.hasKey("messageExt")) {
            message.messageExt = data.getString("messageExt");
        }
        SendMessageToWX.Req req = new SendMessageToWX.Req();
        req.message = message;
        req.scene = scene;
        req.transaction = UUID.randomUUID().toString();
        callback.invoke(new Object[]{null, this.wxapi.sendReq((BaseReq)req)});
    }

    private WXTextObject _jsonToTextMedia(ReadableMap data) {
        if (!data.hasKey("description")) {
            return null;
        }
        WXTextObject ret = new WXTextObject();
        ret.text = data.getString("description");
        return ret;
    }

    private WXWebpageObject _jsonToWebpageMedia(ReadableMap data) {
        if (!data.hasKey("webpageUrl")) {
            return null;
        }
        WXWebpageObject ret = new WXWebpageObject();
        ret.webpageUrl = data.getString("webpageUrl");
        if (data.hasKey("extInfo")) {
            ret.extInfo = data.getString("extInfo");
        }
        return ret;
    }

    private void __jsonToImageMedia(String imageUrl, final MediaObjectCallback callback) {
        Uri imageUri;
        try {
            imageUri = Uri.parse((String)imageUrl);
            if (imageUri.getScheme() == null) {
                imageUri = WeChatModule.getResourceDrawableUri((Context)this.getReactApplicationContext(), imageUrl);
            }
        }
        catch (Exception e) {
            imageUri = null;
        }
        if (imageUri == null) {
            callback.invoke(null);
            return;
        }
        this._getImage(imageUri, null, new ImageCallback(){

            @Override
            public void invoke(@Nullable Bitmap bitmap) {
                callback.invoke((WXMediaMessage.IMediaObject)(bitmap == null ? null : new WXImageObject(bitmap)));
            }
        });
    }

    private void __jsonToImageUrlMedia(ReadableMap data, MediaObjectCallback callback) {
        if (!data.hasKey("imageUrl")) {
            callback.invoke(null);
            return;
        }
        String imageUrl = data.getString("imageUrl");
        this.__jsonToImageMedia(imageUrl, callback);
    }

    private void __jsonToImageFileMedia(ReadableMap data, MediaObjectCallback callback) {
        if (!data.hasKey("imageUrl")) {
            callback.invoke(null);
            return;
        }
        String imageUrl = data.getString("imageUrl");
        if (!imageUrl.toLowerCase().startsWith("file://")) {
            imageUrl = "file://" + imageUrl;
        }
        this.__jsonToImageMedia(imageUrl, callback);
    }

    private WXMusicObject __jsonToMusicMedia(ReadableMap data) {
        if (!data.hasKey("musicUrl")) {
            return null;
        }
        WXMusicObject ret = new WXMusicObject();
        ret.musicUrl = data.getString("musicUrl");
        return ret;
    }

    private WXVideoObject __jsonToVideoMedia(ReadableMap data) {
        if (!data.hasKey("videoUrl")) {
            return null;
        }
        WXVideoObject ret = new WXVideoObject();
        ret.videoUrl = data.getString("videoUrl");
        return ret;
    }

    private WXFileObject __jsonToFileMedia(ReadableMap data) {
        if (!data.hasKey("filePath")) {
            return null;
        }
        return new WXFileObject(data.getString("filePath"));
    }

    public void handleResp(BaseMessage baseMessage) {
        WritableMap map = Arguments.createMap();
        if (baseMessage instanceof WWAuthMessage.Resp) {
            WWAuthMessage.Resp resp = (WWAuthMessage.Resp)baseMessage;
            map.putString("type", "SendAuth.Resp");
            map.putInt("errCode", resp.errCode);
            map.putString("code", resp.code);
        }
        ((DeviceEventManagerModule.RCTDeviceEventEmitter)this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class)).emit("WeChat_Resp", (Object)map);
    }

    private static interface MediaObjectCallback {
        public void invoke(@Nullable WXMediaMessage.IMediaObject var1);
    }

    private static interface ImageCallback {
        public void invoke(@Nullable Bitmap var1);
    }
}

