/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api.model;

import android.os.Bundle;
import android.util.Log;
import com.tencent.wework.api.model.WWMediaMessage;

public class WWMediaFile
extends WWMediaMessage.WWMediaObject {
    private static final String TAG = "WWAPI.WWMediaFile";
    private int contentLengthLimit = 0xA00000;
    public byte[] fileData;
    public String filePath;
    public String fileName;

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean checkArgs() {
        if (!super.checkArgs()) {
            return false;
        }
        if (this.fileData != null && this.fileData.length != 0 || this.filePath != null && this.filePath.length() != 0) {
            if (this.fileData != null && this.fileData.length > this.contentLengthLimit) {
                Log.d((String)TAG, (String)"checkArgs fail, fileData is too large");
                return false;
            }
            if (this.filePath != null && this.getFileSize(this.filePath) > this.contentLengthLimit) {
                Log.d((String)TAG, (String)"checkArgs fail, fileSize is too large");
                return false;
            }
            return true;
        }
        Log.d((String)TAG, (String)"checkArgs fail, both arguments is null");
        return false;
    }

    @Override
    public void toBundle(Bundle var1) {
        var1.putByteArray("_wwfileobject_fileData", this.fileData);
        var1.putString("_wwfileobject_filePath", this.filePath);
        var1.putString("_wwfileobject_fileName", this.fileName);
        super.toBundle(var1);
    }

    @Override
    public void fromBundle(Bundle var1) {
        this.fileData = var1.getByteArray("_wwfileobject_fileData");
        this.filePath = var1.getString("_wwfileobject_filePath");
        this.fileName = var1.getString("_wwfileobject_fileName");
        super.fromBundle(var1);
    }

    public void setContentLengthLimit(int var1) {
        this.contentLengthLimit = var1;
    }
}

