/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.wework.api;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import com.tencent.wework.api.IWWAPI;
import com.tencent.wework.api.IWWAPIEventHandler;
import com.tencent.wework.api.model.BaseMessage;
import com.tencent.wework.api.model.WWBaseMessage;
import com.tencent.wework.api.model.WWBaseRespMessage;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public final class WWAPIImpl
implements IWWAPI {
    private Context context;
    private String schema;
    private Map<String, IWWAPIEventHandler> callbacks = new HashMap<String, IWWAPIEventHandler>();
    private BroadcastReceiver mReciver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            try {
                if (!WWAPIImpl.this.schema.equals(intent.getScheme())) {
                    return;
                }
                final BaseMessage msg = BaseMessage.parseUri(intent.getData());
                if (msg instanceof WWBaseRespMessage) {
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((IWWAPIEventHandler)WWAPIImpl.this.callbacks.get(((WWBaseRespMessage)msg).transaction)).handleResp(msg);
                                WWAPIImpl.this.callbacks.remove(((WWBaseRespMessage)msg).transaction);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    };

    public WWAPIImpl(Context var0) {
        this.context = var0;
    }

    @Override
    public boolean registerApp(String var1) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addDataScheme(var1);
        intentFilter.addAction(var1);
        this.context.registerReceiver(this.mReciver, intentFilter);
        this.schema = var1;
        return true;
    }

    @Override
    public void unregisterApp() {
    }

    @Override
    public boolean handleIntent(Intent intent, IWWAPIEventHandler handler) {
        return false;
    }

    @Override
    public boolean isWWAppInstalled() {
        return this.isWW("com.tencent.wework");
    }

    @Override
    public boolean isWWAppSupportAPI() {
        return this.getWWAppSupportAPI() >= 100;
    }

    @Override
    public int getWWAppSupportAPI() {
        try {
            PackageInfo var1 = this.context.getPackageManager().getPackageInfo("com.tencent.wework", 128);
            return var1 == null ? 0 : var1.versionCode;
        }
        catch (Throwable var2) {
            return 0;
        }
    }

    @Override
    public boolean openWWApp() {
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.wework"));
            return true;
        }
        catch (Throwable var2) {
            return false;
        }
    }

    @Override
    public boolean sendMessage(BaseMessage var1) {
        Intent i = new Intent("com.tencent.wework.apihost");
        i.setClassName("com.tencent.wework", "com.tencent.wework.apihost.WWAPIActivity");
        i.addFlags(0x18800000);
        try {
            var1.setContext(this.context);
            Bundle b = BaseMessage.pack(var1);
            i.putExtras(b);
            i.putExtra("PendingIntent", (Parcelable)PendingIntent.getBroadcast((Context)this.context, (int)0, (Intent)new Intent(this.context, this.mReciver.getClass()), (int)0x8000000));
            this.context.startActivity(i);
            return true;
        }
        catch (Throwable var2) {
            return false;
        }
    }

    @Override
    public boolean sendMessage(BaseMessage var1, IWWAPIEventHandler callback) {
        if (this.sendMessage(var1)) {
            if (var1 instanceof WWBaseMessage) {
                this.callbacks.put(((WWBaseMessage)var1).transaction, callback);
            }
            return true;
        }
        return false;
    }

    @Override
    public void detach() {
        this.context.unregisterReceiver(this.mReciver);
    }

    private String getSignature(String pkg) {
        try {
            PackageInfo var1 = this.context.getPackageManager().getPackageInfo(pkg, 64);
            return WWAPIImpl.MD5Encode(var1.signatures[0].toByteArray());
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private static String MD5Encode(byte[] toencode) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(toencode);
            return WWAPIImpl.HexEncode(md5.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String HexEncode(byte[] toencode) {
        StringBuilder sb = new StringBuilder(toencode.length * 2);
        for (byte b : toencode) {
            sb.append(Integer.toHexString((b & 0xF0) >>> 4));
            sb.append(Integer.toHexString(b & 0xF));
        }
        return sb.toString().toUpperCase();
    }

    private boolean isWW(String pkg) {
        try {
            return pkg.equals("com.tencent.wework") && this.getSignature(pkg).equals("011A40266C8C75D181DDD8E4DDC50075");
        }
        catch (Throwable var2) {
            return false;
        }
    }
}

