/*
 * Decompiled with CFR 0.152.
 */
package com.mybigday.rnxprinter;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.util.Log;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.util.Set;
import net.xprinter.utils.DataForSendToPrinterXp80;
import net.xprinter.utils.XPrinterDev;

public class RNXprinter
extends ReactContextBaseJavaModule {
    private String LOG_TAG = "RNXprinter";
    private ReactApplicationContext context;
    private byte[] mBuffer = new byte[0];
    private Set<BluetoothDevice> mPairedDevices;
    private XPrinterDev mBluetoothPrinter = null;

    public RNXprinter(ReactApplicationContext reactContext) {
        super(reactContext);
        this.context = reactContext;
        Log.v((String)this.LOG_TAG, (String)"RNXprinter alloc");
    }

    public String getName() {
        return "RNXprinter";
    }

    @ReactMethod
    public void getDeviceList(Promise promise) {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            promise.reject("-100", "Not bluetooth adapter");
        } else if (bluetoothAdapter.isEnabled()) {
            this.mPairedDevices = bluetoothAdapter.getBondedDevices();
            WritableArray pairedDeviceList = Arguments.createArray();
            for (BluetoothDevice device : this.mPairedDevices) {
                WritableMap deviceMap = Arguments.createMap();
                deviceMap.putString("name", device.getName());
                deviceMap.putString("address", device.getAddress());
                pairedDeviceList.pushMap(deviceMap);
            }
            promise.resolve((Object)pairedDeviceList);
        } else {
            promise.reject("-103", "BluetoothAdapter not open...");
        }
    }

    @ReactMethod
    public void selectDevice(String address, Promise promise) {
        for (BluetoothDevice device : this.mPairedDevices) {
            Log.d((String)this.LOG_TAG, (String)("Checking:" + device.getAddress() + " : " + address));
            if (!device.getAddress().equals(address)) continue;
            this.mBluetoothPrinter = new XPrinterDev(XPrinterDev.PortType.Bluetooth, address);
            promise.resolve((Object)true);
            return;
        }
        promise.reject("-105", "Device address not exist.");
    }

    @ReactMethod
    public void pushText(String text, Integer size) {
        if (size < 0 || size > 7) {
            size = 0;
        }
        Log.d((String)this.LOG_TAG, (String)("Set Font Size:" + size));
        this.pushByteToBuffer(DataForSendToPrinterXp80.selectCharacterSize((int)(size * 17)));
        Log.d((String)this.LOG_TAG, (String)("Print String:" + text));
        this.pushByteToBuffer(DataForSendToPrinterXp80.strTobytes((String)(text + "\n")));
    }

    @ReactMethod
    public void pushFlashImage(Integer index) {
        Log.d((String)this.LOG_TAG, (String)("Print FLASH Image:" + index));
        this.pushByteToBuffer(DataForSendToPrinterXp80.printBmpInFLASH((int)index, (int)0));
    }

    @ReactMethod
    public void pushCutPaper() {
        Log.d((String)this.LOG_TAG, (String)"Cut Paper");
        this.pushByteToBuffer(DataForSendToPrinterXp80.selectCutPagerModerAndCutPager((int)66, (int)0));
    }

    @ReactMethod
    public void print(Promise promise) {
        if (this.mBluetoothPrinter == null) {
            promise.reject("-107", "Must select printer first.");
            return;
        }
        if (this.mBuffer.length == 0) {
            promise.reject("-109", "Buffer is empty");
            return;
        }
        XPrinterDev.ReturnMessage returnMessage = this.mBluetoothPrinter.Open();
        Log.d((String)this.LOG_TAG, (String)("Open device:" + returnMessage.GetErrorStrings()));
        returnMessage = this.mBluetoothPrinter.Write(this.mBuffer);
        Log.d((String)this.LOG_TAG, (String)("Write data:" + returnMessage.GetErrorStrings()));
        this.clearBuffer();
        returnMessage = this.mBluetoothPrinter.Close();
        Log.d((String)this.LOG_TAG, (String)("Close device:" + returnMessage.GetErrorStrings()));
        promise.resolve((Object)true);
    }

    @ReactMethod
    public void clearPrintBuffer() {
        this.clearBuffer();
    }

    @ReactMethod
    public void printDemoPage(Promise promise) {
        this.clearBuffer();
        this.pushFlashImage(1);
        this.pushText("Xprinter TEST\n", 2);
        this.pushText("\u5982\u679c\u60a8\u770b\u5230\u9019\u500b\u5217\u5370\u7d50\u679c\uff0c\u8868\u793a\u60a8\u96e2\u6210\u529f\u975e\u5e38\u7684\u8fd1\u4e86\uff01\u52a0\u6cb9\uff01\uff01\uff01\n\n", 1);
        this.pushText("Powered by FuGood MyBigDay Team", 0);
        this.pushCutPaper();
        this.print(promise);
    }

    private void pushByteToBuffer(byte[] input) {
        byte[] newByte = new byte[this.mBuffer.length + input.length];
        System.arraycopy(this.mBuffer, 0, newByte, 0, this.mBuffer.length);
        System.arraycopy(input, 0, newByte, this.mBuffer.length, input.length);
        this.mBuffer = newByte;
        Log.d((String)this.LOG_TAG, (String)("Push buffer:" + this.mBuffer.length));
    }

    private void clearBuffer() {
        this.mBuffer = new byte[0];
        Log.d((String)this.LOG_TAG, (String)("Clear buffer:" + this.mBuffer.length));
    }
}

