/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.csslayout;

import com.facebook.csslayout.CSSAlign;
import com.facebook.csslayout.CSSCachedMeasurement;
import com.facebook.csslayout.CSSDirection;
import com.facebook.csslayout.CSSFlexDirection;
import com.facebook.csslayout.CSSJustify;
import com.facebook.csslayout.CSSLayout;
import com.facebook.csslayout.CSSLayoutContext;
import com.facebook.csslayout.CSSMeasureMode;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.CSSOverflow;
import com.facebook.csslayout.CSSPositionType;
import com.facebook.csslayout.CSSWrap;
import com.facebook.csslayout.FloatUtil;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.infer.annotation.Assertions;

public class LayoutEngine {
    private static final boolean POSITIVE_FLEX_IS_AUTO = false;
    private static final int CSS_FLEX_DIRECTION_COLUMN = CSSFlexDirection.COLUMN.ordinal();
    private static final int CSS_FLEX_DIRECTION_COLUMN_REVERSE = CSSFlexDirection.COLUMN_REVERSE.ordinal();
    private static final int CSS_FLEX_DIRECTION_ROW = CSSFlexDirection.ROW.ordinal();
    private static final int CSS_FLEX_DIRECTION_ROW_REVERSE = CSSFlexDirection.ROW_REVERSE.ordinal();
    private static final int CSS_POSITION_RELATIVE = CSSPositionType.RELATIVE.ordinal();
    private static final int CSS_POSITION_ABSOLUTE = CSSPositionType.ABSOLUTE.ordinal();
    private static final int[] leading = new int[]{1, 3, 0, 2};
    private static final int[] trailing = new int[]{3, 1, 2, 0};
    private static final int[] pos = new int[]{1, 3, 0, 2};
    private static final int[] dim = new int[]{1, 1, 0, 0};
    private static final int[] leadingSpacing = new int[]{1, 3, 6, 6};
    private static final int[] trailingSpacing = new int[]{3, 1, 7, 7};

    private static boolean isFlexBasisAuto(CSSNode node) {
        return node.style.flex <= 0.0f;
    }

    private static float getFlexGrowFactor(CSSNode node) {
        if (node.style.flex > 0.0f) {
            return node.style.flex;
        }
        return 0.0f;
    }

    private static float getFlexShrinkFactor(CSSNode node) {
        if (node.style.flex < 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }

    private static float boundAxisWithinMinAndMax(CSSNode node, int axis, float value) {
        float min = Float.NaN;
        float max = Float.NaN;
        if (axis == CSS_FLEX_DIRECTION_COLUMN || axis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
            min = node.style.minHeight;
            max = node.style.maxHeight;
        } else if (axis == CSS_FLEX_DIRECTION_ROW || axis == CSS_FLEX_DIRECTION_ROW_REVERSE) {
            min = node.style.minWidth;
            max = node.style.maxWidth;
        }
        float boundValue = value;
        if (!Float.isNaN(max) && (double)max >= 0.0 && boundValue > max) {
            boundValue = max;
        }
        if (!Float.isNaN(min) && (double)min >= 0.0 && boundValue < min) {
            boundValue = min;
        }
        return boundValue;
    }

    private static float boundAxis(CSSNode node, int axis, float value) {
        float paddingAndBorderAxis = node.style.padding.getWithFallback(leadingSpacing[axis], leading[axis]) + node.style.border.getWithFallback(leadingSpacing[axis], leading[axis]) + node.style.padding.getWithFallback(trailingSpacing[axis], trailing[axis]) + node.style.border.getWithFallback(trailingSpacing[axis], trailing[axis]);
        return Math.max(LayoutEngine.boundAxisWithinMinAndMax(node, axis, value), paddingAndBorderAxis);
    }

    private static float getRelativePosition(CSSNode node, int axis) {
        float lead = node.style.position[leading[axis]];
        if (!Float.isNaN(lead)) {
            return lead;
        }
        float trailingPos = node.style.position[trailing[axis]];
        return Float.isNaN(trailingPos) ? 0.0f : -trailingPos;
    }

    private static void setPosition(CSSNode node, CSSDirection direction) {
        int mainAxis = LayoutEngine.resolveAxis(LayoutEngine.getFlexDirection(node), direction);
        int crossAxis = LayoutEngine.getCrossFlexDirection(mainAxis, direction);
        node.layout.position[LayoutEngine.leading[mainAxis]] = node.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + LayoutEngine.getRelativePosition(node, mainAxis);
        node.layout.position[LayoutEngine.trailing[mainAxis]] = node.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + LayoutEngine.getRelativePosition(node, mainAxis);
        node.layout.position[LayoutEngine.leading[crossAxis]] = node.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + LayoutEngine.getRelativePosition(node, crossAxis);
        node.layout.position[LayoutEngine.trailing[crossAxis]] = node.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + LayoutEngine.getRelativePosition(node, crossAxis);
    }

    private static int resolveAxis(int axis, CSSDirection direction) {
        if (direction == CSSDirection.RTL) {
            if (axis == CSS_FLEX_DIRECTION_ROW) {
                return CSS_FLEX_DIRECTION_ROW_REVERSE;
            }
            if (axis == CSS_FLEX_DIRECTION_ROW_REVERSE) {
                return CSS_FLEX_DIRECTION_ROW;
            }
        }
        return axis;
    }

    private static CSSDirection resolveDirection(CSSNode node, CSSDirection parentDirection) {
        CSSDirection direction = node.style.direction;
        if (direction == CSSDirection.INHERIT) {
            direction = parentDirection == null ? CSSDirection.LTR : parentDirection;
        }
        return direction;
    }

    private static int getFlexDirection(CSSNode node) {
        return node.style.flexDirection.ordinal();
    }

    private static int getCrossFlexDirection(int axis, CSSDirection direction) {
        if (axis == CSS_FLEX_DIRECTION_COLUMN || axis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
            return LayoutEngine.resolveAxis(CSS_FLEX_DIRECTION_ROW, direction);
        }
        return CSS_FLEX_DIRECTION_COLUMN;
    }

    private static CSSAlign getAlignItem(CSSNode node, CSSNode child) {
        if (child.style.alignSelf != CSSAlign.AUTO) {
            return child.style.alignSelf;
        }
        return node.style.alignItems;
    }

    private static boolean isMeasureDefined(CSSNode node) {
        return node.isMeasureDefined();
    }

    static void layoutNode(CSSLayoutContext layoutContext, CSSNode node, float availableWidth, float availableHeight, CSSDirection parentDirection) {
        ++layoutContext.currentGenerationCount;
        CSSMeasureMode widthMeasureMode = CSSMeasureMode.UNDEFINED;
        CSSMeasureMode heightMeasureMode = CSSMeasureMode.UNDEFINED;
        if (!Float.isNaN(availableWidth)) {
            widthMeasureMode = CSSMeasureMode.EXACTLY;
        } else if ((double)node.style.dimensions[0] >= 0.0) {
            float marginAxisRow = node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]);
            availableWidth = node.style.dimensions[0] + marginAxisRow;
            widthMeasureMode = CSSMeasureMode.EXACTLY;
        } else if ((double)node.style.maxWidth >= 0.0) {
            availableWidth = node.style.maxWidth;
            widthMeasureMode = CSSMeasureMode.AT_MOST;
        }
        if (!Float.isNaN(availableHeight)) {
            heightMeasureMode = CSSMeasureMode.EXACTLY;
        } else if ((double)node.style.dimensions[1] >= 0.0) {
            float marginAxisColumn = node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]);
            availableHeight = node.style.dimensions[1] + marginAxisColumn;
            heightMeasureMode = CSSMeasureMode.EXACTLY;
        } else if ((double)node.style.maxHeight >= 0.0) {
            availableHeight = node.style.maxHeight;
            heightMeasureMode = CSSMeasureMode.AT_MOST;
        }
        if (LayoutEngine.layoutNodeInternal(layoutContext, node, availableWidth, availableHeight, parentDirection, widthMeasureMode, heightMeasureMode, true, "initial")) {
            LayoutEngine.setPosition(node, node.layout.direction);
        }
    }

    static boolean canUseCachedMeasurement(boolean isTextNode, float availableWidth, float availableHeight, float marginRow, float marginColumn, CSSMeasureMode widthMeasureMode, CSSMeasureMode heightMeasureMode, CSSCachedMeasurement cachedLayout) {
        boolean isWidthValid;
        boolean isHeightValid;
        boolean isWidthSame;
        boolean isHeightSame = cachedLayout.heightMeasureMode == CSSMeasureMode.UNDEFINED && heightMeasureMode == CSSMeasureMode.UNDEFINED || cachedLayout.heightMeasureMode == heightMeasureMode && FloatUtil.floatsEqual(cachedLayout.availableHeight, availableHeight);
        boolean bl = isWidthSame = cachedLayout.widthMeasureMode == CSSMeasureMode.UNDEFINED && widthMeasureMode == CSSMeasureMode.UNDEFINED || cachedLayout.widthMeasureMode == widthMeasureMode && FloatUtil.floatsEqual(cachedLayout.availableWidth, availableWidth);
        if (isHeightSame && isWidthSame) {
            return true;
        }
        boolean bl2 = isHeightValid = cachedLayout.heightMeasureMode == CSSMeasureMode.UNDEFINED && heightMeasureMode == CSSMeasureMode.AT_MOST && cachedLayout.computedHeight <= availableHeight - marginColumn || heightMeasureMode == CSSMeasureMode.EXACTLY && FloatUtil.floatsEqual(cachedLayout.computedHeight, availableHeight - marginColumn);
        if (isWidthSame && isHeightValid) {
            return true;
        }
        boolean bl3 = isWidthValid = cachedLayout.widthMeasureMode == CSSMeasureMode.UNDEFINED && widthMeasureMode == CSSMeasureMode.AT_MOST && cachedLayout.computedWidth <= availableWidth - marginRow || widthMeasureMode == CSSMeasureMode.EXACTLY && FloatUtil.floatsEqual(cachedLayout.computedWidth, availableWidth - marginRow);
        if (isHeightSame && isWidthValid) {
            return true;
        }
        if (isHeightValid && isWidthValid) {
            return true;
        }
        if (isTextNode) {
            if (isWidthSame) {
                if (heightMeasureMode == CSSMeasureMode.UNDEFINED) {
                    return true;
                }
                if (heightMeasureMode == CSSMeasureMode.AT_MOST && cachedLayout.computedHeight < availableHeight - marginColumn) {
                    return true;
                }
                cachedLayout.computedHeight = availableHeight - marginColumn;
                return true;
            }
            if (cachedLayout.widthMeasureMode == CSSMeasureMode.UNDEFINED && (widthMeasureMode == CSSMeasureMode.UNDEFINED || widthMeasureMode == CSSMeasureMode.AT_MOST && cachedLayout.computedWidth <= availableWidth - marginRow)) {
                return true;
            }
        }
        return false;
    }

    private static boolean layoutNodeInternal(CSSLayoutContext layoutContext, CSSNode node, float availableWidth, float availableHeight, CSSDirection parentDirection, CSSMeasureMode widthMeasureMode, CSSMeasureMode heightMeasureMode, boolean performLayout, String reason) {
        boolean needToVisitNode;
        CSSLayout layout = node.layout;
        boolean bl = needToVisitNode = node.isDirty() && layout.generationCount != layoutContext.currentGenerationCount || layout.lastParentDirection != parentDirection;
        if (needToVisitNode) {
            layout.nextCachedMeasurementsIndex = 0;
            layout.cachedLayout.widthMeasureMode = null;
            layout.cachedLayout.heightMeasureMode = null;
        }
        CSSCachedMeasurement cachedResults = null;
        if (LayoutEngine.isMeasureDefined(node)) {
            float marginAxisRow = node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]);
            float marginAxisColumn = node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]);
            if (LayoutEngine.canUseCachedMeasurement(node.isTextNode(), availableWidth, availableHeight, marginAxisRow, marginAxisColumn, widthMeasureMode, heightMeasureMode, layout.cachedLayout)) {
                cachedResults = layout.cachedLayout;
            } else {
                for (int i = 0; i < layout.nextCachedMeasurementsIndex; ++i) {
                    if (!LayoutEngine.canUseCachedMeasurement(node.isTextNode(), availableWidth, availableHeight, marginAxisRow, marginAxisColumn, widthMeasureMode, heightMeasureMode, layout.cachedMeasurements[i])) continue;
                    cachedResults = layout.cachedMeasurements[i];
                    break;
                }
            }
        } else if (performLayout) {
            if (FloatUtil.floatsEqual(layout.cachedLayout.availableWidth, availableWidth) && FloatUtil.floatsEqual(layout.cachedLayout.availableHeight, availableHeight) && layout.cachedLayout.widthMeasureMode == widthMeasureMode && layout.cachedLayout.heightMeasureMode == heightMeasureMode) {
                cachedResults = layout.cachedLayout;
            }
        } else {
            for (int i = 0; i < layout.nextCachedMeasurementsIndex; ++i) {
                if (!FloatUtil.floatsEqual(layout.cachedMeasurements[i].availableWidth, availableWidth) || !FloatUtil.floatsEqual(layout.cachedMeasurements[i].availableHeight, availableHeight) || layout.cachedMeasurements[i].widthMeasureMode != widthMeasureMode || layout.cachedMeasurements[i].heightMeasureMode != heightMeasureMode) continue;
                cachedResults = layout.cachedMeasurements[i];
                break;
            }
        }
        if (!needToVisitNode && cachedResults != null) {
            layout.measuredDimensions[0] = cachedResults.computedWidth;
            layout.measuredDimensions[1] = cachedResults.computedHeight;
        } else {
            LayoutEngine.layoutNodeImpl(layoutContext, node, availableWidth, availableHeight, parentDirection, widthMeasureMode, heightMeasureMode, performLayout);
            layout.lastParentDirection = parentDirection;
            if (cachedResults == null) {
                if (layout.nextCachedMeasurementsIndex == 16) {
                    layout.nextCachedMeasurementsIndex = 0;
                }
                CSSCachedMeasurement newCacheEntry = null;
                if (performLayout) {
                    newCacheEntry = layout.cachedLayout;
                } else {
                    newCacheEntry = layout.cachedMeasurements[layout.nextCachedMeasurementsIndex];
                    if (newCacheEntry == null) {
                        layout.cachedMeasurements[layout.nextCachedMeasurementsIndex] = newCacheEntry = new CSSCachedMeasurement();
                    }
                    ++layout.nextCachedMeasurementsIndex;
                }
                newCacheEntry.availableWidth = availableWidth;
                newCacheEntry.availableHeight = availableHeight;
                newCacheEntry.widthMeasureMode = widthMeasureMode;
                newCacheEntry.heightMeasureMode = heightMeasureMode;
                newCacheEntry.computedWidth = layout.measuredDimensions[0];
                newCacheEntry.computedHeight = layout.measuredDimensions[1];
            }
        }
        if (performLayout) {
            node.layout.dimensions[0] = node.layout.measuredDimensions[0];
            node.layout.dimensions[1] = node.layout.measuredDimensions[1];
            node.markHasNewLayout();
        }
        layout.generationCount = layoutContext.currentGenerationCount;
        return needToVisitNode || cachedResults == null;
    }

    private static void layoutNodeImpl(CSSLayoutContext layoutContext, CSSNode node, float availableWidth, float availableHeight, CSSDirection parentDirection, CSSMeasureMode widthMeasureMode, CSSMeasureMode heightMeasureMode, boolean performLayout) {
        CSSMeasureMode childHeightMeasureMode;
        CSSMeasureMode childWidthMeasureMode;
        float childHeight;
        float childWidth;
        CSSNode child;
        int i;
        CSSDirection direction;
        Assertions.assertCondition((boolean)(Float.isNaN(availableWidth) ? widthMeasureMode == CSSMeasureMode.UNDEFINED : true), (String)"availableWidth is indefinite so widthMeasureMode must be CSSMeasureMode.UNDEFINED");
        Assertions.assertCondition((boolean)(Float.isNaN(availableHeight) ? heightMeasureMode == CSSMeasureMode.UNDEFINED : true), (String)"availableHeight is indefinite so heightMeasureMode must be CSSMeasureMode.UNDEFINED");
        float paddingAndBorderAxisRow = node.style.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + node.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + (node.style.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]) + node.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
        float paddingAndBorderAxisColumn = node.style.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + (node.style.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
        float marginAxisRow = node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]);
        float marginAxisColumn = node.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]);
        node.layout.direction = direction = LayoutEngine.resolveDirection(node, parentDirection);
        if (LayoutEngine.isMeasureDefined(node)) {
            float innerWidth = availableWidth - marginAxisRow - paddingAndBorderAxisRow;
            float innerHeight = availableHeight - marginAxisColumn - paddingAndBorderAxisColumn;
            if (widthMeasureMode == CSSMeasureMode.EXACTLY && heightMeasureMode == CSSMeasureMode.EXACTLY) {
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, availableWidth - marginAxisRow);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, availableHeight - marginAxisColumn);
            } else if (innerWidth <= 0.0f || innerHeight <= 0.0f) {
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, 0.0f);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, 0.0f);
            } else {
                MeasureOutput measureDim = node.measure(layoutContext.measureOutput, innerWidth, widthMeasureMode, innerHeight, heightMeasureMode);
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, widthMeasureMode == CSSMeasureMode.UNDEFINED || widthMeasureMode == CSSMeasureMode.AT_MOST ? measureDim.width + paddingAndBorderAxisRow : availableWidth - marginAxisRow);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, heightMeasureMode == CSSMeasureMode.UNDEFINED || heightMeasureMode == CSSMeasureMode.AT_MOST ? measureDim.height + paddingAndBorderAxisColumn : availableHeight - marginAxisColumn);
            }
            return;
        }
        int childCount = node.getChildCount();
        if (childCount == 0) {
            node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, widthMeasureMode == CSSMeasureMode.UNDEFINED || widthMeasureMode == CSSMeasureMode.AT_MOST ? paddingAndBorderAxisRow : availableWidth - marginAxisRow);
            node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, heightMeasureMode == CSSMeasureMode.UNDEFINED || heightMeasureMode == CSSMeasureMode.AT_MOST ? paddingAndBorderAxisColumn : availableHeight - marginAxisColumn);
            return;
        }
        if (!performLayout) {
            if (widthMeasureMode == CSSMeasureMode.AT_MOST && availableWidth <= 0.0f && heightMeasureMode == CSSMeasureMode.AT_MOST && availableHeight <= 0.0f) {
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, 0.0f);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, 0.0f);
                return;
            }
            if (widthMeasureMode == CSSMeasureMode.AT_MOST && availableWidth <= 0.0f) {
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, 0.0f);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, Float.isNaN(availableHeight) ? 0.0f : availableHeight - marginAxisColumn);
                return;
            }
            if (heightMeasureMode == CSSMeasureMode.AT_MOST && availableHeight <= 0.0f) {
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, Float.isNaN(availableWidth) ? 0.0f : availableWidth - marginAxisRow);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, 0.0f);
                return;
            }
            if (widthMeasureMode == CSSMeasureMode.EXACTLY && heightMeasureMode == CSSMeasureMode.EXACTLY) {
                node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, availableWidth - marginAxisRow);
                node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, availableHeight - marginAxisColumn);
                return;
            }
        }
        int mainAxis = LayoutEngine.resolveAxis(LayoutEngine.getFlexDirection(node), direction);
        int crossAxis = LayoutEngine.getCrossFlexDirection(mainAxis, direction);
        boolean isMainAxisRow = mainAxis == CSS_FLEX_DIRECTION_ROW || mainAxis == CSS_FLEX_DIRECTION_ROW_REVERSE;
        CSSJustify justifyContent = node.style.justifyContent;
        boolean isNodeFlexWrap = node.style.flexWrap == CSSWrap.WRAP;
        CSSNode firstAbsoluteChild = null;
        CSSNode currentAbsoluteChild = null;
        float leadingPaddingAndBorderMain = node.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + node.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]);
        float trailingPaddingAndBorderMain = node.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + node.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]);
        float leadingPaddingAndBorderCross = node.style.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + node.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
        float paddingAndBorderAxisMain = node.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + node.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (node.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + node.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
        float paddingAndBorderAxisCross = node.style.padding.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + node.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + (node.style.padding.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) + node.style.border.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
        CSSMeasureMode measureModeMainDim = isMainAxisRow ? widthMeasureMode : heightMeasureMode;
        CSSMeasureMode measureModeCrossDim = isMainAxisRow ? heightMeasureMode : widthMeasureMode;
        float availableInnerWidth = availableWidth - marginAxisRow - paddingAndBorderAxisRow;
        float availableInnerHeight = availableHeight - marginAxisColumn - paddingAndBorderAxisColumn;
        float availableInnerMainDim = isMainAxisRow ? availableInnerWidth : availableInnerHeight;
        float availableInnerCrossDim = isMainAxisRow ? availableInnerHeight : availableInnerWidth;
        for (i = 0; i < childCount; ++i) {
            child = node.getChildAt(i);
            if (performLayout) {
                CSSDirection childDirection = LayoutEngine.resolveDirection(child, direction);
                LayoutEngine.setPosition(child, childDirection);
            }
            if (child.style.positionType == CSSPositionType.ABSOLUTE) {
                if (firstAbsoluteChild == null) {
                    firstAbsoluteChild = child;
                }
                if (currentAbsoluteChild != null) {
                    currentAbsoluteChild.nextChild = child;
                }
                currentAbsoluteChild = child;
                child.nextChild = null;
                continue;
            }
            if (isMainAxisRow && (double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0) {
                child.layout.flexBasis = Math.max(child.style.dimensions[0], child.style.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + child.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + (child.style.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]) + child.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW])));
                continue;
            }
            if (!isMainAxisRow && (double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) {
                child.layout.flexBasis = Math.max(child.style.dimensions[1], child.style.padding.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + child.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + (child.style.padding.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]) + child.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN])));
                continue;
            }
            if (!LayoutEngine.isFlexBasisAuto(child) && !Float.isNaN(availableInnerMainDim)) {
                child.layout.flexBasis = Math.max(0.0f, child.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (child.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + child.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])));
                continue;
            }
            childWidth = Float.NaN;
            childHeight = Float.NaN;
            childWidthMeasureMode = CSSMeasureMode.UNDEFINED;
            childHeightMeasureMode = CSSMeasureMode.UNDEFINED;
            if ((double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0) {
                childWidth = child.style.dimensions[0] + (child.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + child.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
                childWidthMeasureMode = CSSMeasureMode.EXACTLY;
            }
            if ((double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) {
                childHeight = child.style.dimensions[1] + (child.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + child.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
                childHeightMeasureMode = CSSMeasureMode.EXACTLY;
            }
            if (!isMainAxisRow && Float.isNaN(childWidth) && !Float.isNaN(availableInnerWidth)) {
                childWidth = availableInnerWidth;
                childWidthMeasureMode = CSSMeasureMode.AT_MOST;
            }
            if (node.style.overflow == CSSOverflow.HIDDEN && isMainAxisRow && Float.isNaN(childHeight) && !Float.isNaN(availableInnerHeight)) {
                childHeight = availableInnerHeight;
                childHeightMeasureMode = CSSMeasureMode.AT_MOST;
            }
            if (!(isMainAxisRow || Float.isNaN(availableInnerWidth) || (double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0 || widthMeasureMode != CSSMeasureMode.EXACTLY || LayoutEngine.getAlignItem(node, child) != CSSAlign.STRETCH)) {
                childWidth = availableInnerWidth;
                childWidthMeasureMode = CSSMeasureMode.EXACTLY;
            }
            if (isMainAxisRow && !Float.isNaN(availableInnerHeight) && !((double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) && heightMeasureMode == CSSMeasureMode.EXACTLY && LayoutEngine.getAlignItem(node, child) == CSSAlign.STRETCH) {
                childHeight = availableInnerHeight;
                childHeightMeasureMode = CSSMeasureMode.EXACTLY;
            }
            LayoutEngine.layoutNodeInternal(layoutContext, child, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, false, "measure");
            child.layout.flexBasis = Math.max(isMainAxisRow ? child.layout.measuredDimensions[0] : child.layout.measuredDimensions[1], child.style.padding.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + (child.style.padding.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]) + child.style.border.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])));
        }
        int startOfLineIndex = 0;
        int endOfLineIndex = 0;
        int lineCount = 0;
        float totalLineCrossDim = 0.0f;
        float maxLineMainDim = 0.0f;
        while (endOfLineIndex < childCount) {
            int itemsOnLine = 0;
            float sizeConsumedOnCurrentLine = 0.0f;
            float totalFlexGrowFactors = 0.0f;
            float totalFlexShrinkScaledFactors = 0.0f;
            i = startOfLineIndex;
            CSSNode firstRelativeChild = null;
            CSSNode currentRelativeChild = null;
            while (i < childCount) {
                child = node.getChildAt(i);
                child.lineIndex = lineCount;
                if (child.style.positionType != CSSPositionType.ABSOLUTE) {
                    float outerFlexBasis = child.layout.flexBasis + (child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
                    if (sizeConsumedOnCurrentLine + outerFlexBasis > availableInnerMainDim && isNodeFlexWrap && itemsOnLine > 0) break;
                    sizeConsumedOnCurrentLine += outerFlexBasis;
                    ++itemsOnLine;
                    if (child.style.positionType == CSSPositionType.RELATIVE && child.style.flex != 0.0f) {
                        totalFlexGrowFactors += LayoutEngine.getFlexGrowFactor(child);
                        totalFlexShrinkScaledFactors += LayoutEngine.getFlexShrinkFactor(child) * child.layout.flexBasis;
                    }
                    if (firstRelativeChild == null) {
                        firstRelativeChild = child;
                    }
                    if (currentRelativeChild != null) {
                        currentRelativeChild.nextChild = child;
                    }
                    currentRelativeChild = child;
                    child.nextChild = null;
                }
                ++i;
                ++endOfLineIndex;
            }
            boolean canSkipFlex = !performLayout && measureModeCrossDim == CSSMeasureMode.EXACTLY;
            float leadingMainDim = 0.0f;
            float betweenMainDim = 0.0f;
            float remainingFreeSpace = 0.0f;
            if (!Float.isNaN(availableInnerMainDim)) {
                remainingFreeSpace = availableInnerMainDim - sizeConsumedOnCurrentLine;
            } else if (sizeConsumedOnCurrentLine < 0.0f) {
                remainingFreeSpace = -sizeConsumedOnCurrentLine;
            }
            float originalRemainingFreeSpace = remainingFreeSpace;
            float deltaFreeSpace = 0.0f;
            if (!canSkipFlex) {
                float flexGrowFactor;
                float flexShrinkScaledFactor;
                float childFlexBasis;
                float deltaFlexShrinkScaledFactors = 0.0f;
                float deltaFlexGrowFactors = 0.0f;
                currentRelativeChild = firstRelativeChild;
                while (currentRelativeChild != null) {
                    float boundMainSize;
                    float baseMainSize;
                    childFlexBasis = currentRelativeChild.layout.flexBasis;
                    if (remainingFreeSpace < 0.0f) {
                        flexShrinkScaledFactor = LayoutEngine.getFlexShrinkFactor(currentRelativeChild) * childFlexBasis;
                        if (flexShrinkScaledFactor != 0.0f && (baseMainSize = childFlexBasis + remainingFreeSpace / totalFlexShrinkScaledFactors * flexShrinkScaledFactor) != (boundMainSize = LayoutEngine.boundAxis(currentRelativeChild, mainAxis, baseMainSize))) {
                            deltaFreeSpace -= boundMainSize - childFlexBasis;
                            deltaFlexShrinkScaledFactors -= flexShrinkScaledFactor;
                        }
                    } else if (remainingFreeSpace > 0.0f && (flexGrowFactor = LayoutEngine.getFlexGrowFactor(currentRelativeChild)) != 0.0f && (baseMainSize = childFlexBasis + remainingFreeSpace / totalFlexGrowFactors * flexGrowFactor) != (boundMainSize = LayoutEngine.boundAxis(currentRelativeChild, mainAxis, baseMainSize))) {
                        deltaFreeSpace -= boundMainSize - childFlexBasis;
                        deltaFlexGrowFactors -= flexGrowFactor;
                    }
                    currentRelativeChild = currentRelativeChild.nextChild;
                }
                totalFlexShrinkScaledFactors += deltaFlexShrinkScaledFactors;
                totalFlexGrowFactors += deltaFlexGrowFactors;
                remainingFreeSpace += deltaFreeSpace;
                deltaFreeSpace = 0.0f;
                currentRelativeChild = firstRelativeChild;
                while (currentRelativeChild != null) {
                    float updatedMainSize = childFlexBasis = currentRelativeChild.layout.flexBasis;
                    if (remainingFreeSpace < 0.0f) {
                        flexShrinkScaledFactor = LayoutEngine.getFlexShrinkFactor(currentRelativeChild) * childFlexBasis;
                        if (flexShrinkScaledFactor != 0.0f) {
                            updatedMainSize = LayoutEngine.boundAxis(currentRelativeChild, mainAxis, childFlexBasis + remainingFreeSpace / totalFlexShrinkScaledFactors * flexShrinkScaledFactor);
                        }
                    } else if (remainingFreeSpace > 0.0f && (flexGrowFactor = LayoutEngine.getFlexGrowFactor(currentRelativeChild)) != 0.0f) {
                        updatedMainSize = LayoutEngine.boundAxis(currentRelativeChild, mainAxis, childFlexBasis + remainingFreeSpace / totalFlexGrowFactors * flexGrowFactor);
                    }
                    deltaFreeSpace -= updatedMainSize - childFlexBasis;
                    if (isMainAxisRow) {
                        childWidth = updatedMainSize + (currentRelativeChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + currentRelativeChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
                        childWidthMeasureMode = CSSMeasureMode.EXACTLY;
                        if (!Float.isNaN(availableInnerCrossDim) && !((double)currentRelativeChild.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) && heightMeasureMode == CSSMeasureMode.EXACTLY && LayoutEngine.getAlignItem(node, currentRelativeChild) == CSSAlign.STRETCH) {
                            childHeight = availableInnerCrossDim;
                            childHeightMeasureMode = CSSMeasureMode.EXACTLY;
                        } else if (!((double)currentRelativeChild.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0)) {
                            childHeight = availableInnerCrossDim;
                            childHeightMeasureMode = Float.isNaN(childHeight) ? CSSMeasureMode.UNDEFINED : CSSMeasureMode.AT_MOST;
                        } else {
                            childHeight = currentRelativeChild.style.dimensions[1] + (currentRelativeChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + currentRelativeChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
                            childHeightMeasureMode = CSSMeasureMode.EXACTLY;
                        }
                    } else {
                        childHeight = updatedMainSize + (currentRelativeChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + currentRelativeChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
                        childHeightMeasureMode = CSSMeasureMode.EXACTLY;
                        if (!Float.isNaN(availableInnerCrossDim) && !((double)currentRelativeChild.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0) && widthMeasureMode == CSSMeasureMode.EXACTLY && LayoutEngine.getAlignItem(node, currentRelativeChild) == CSSAlign.STRETCH) {
                            childWidth = availableInnerCrossDim;
                            childWidthMeasureMode = CSSMeasureMode.EXACTLY;
                        } else if (!((double)currentRelativeChild.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0)) {
                            childWidth = availableInnerCrossDim;
                            childWidthMeasureMode = Float.isNaN(childWidth) ? CSSMeasureMode.UNDEFINED : CSSMeasureMode.AT_MOST;
                        } else {
                            childWidth = currentRelativeChild.style.dimensions[0] + (currentRelativeChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + currentRelativeChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
                            childWidthMeasureMode = CSSMeasureMode.EXACTLY;
                        }
                    }
                    boolean requiresStretchLayout = !((double)currentRelativeChild.style.dimensions[dim[crossAxis]] >= 0.0) && LayoutEngine.getAlignItem(node, currentRelativeChild) == CSSAlign.STRETCH;
                    LayoutEngine.layoutNodeInternal(layoutContext, currentRelativeChild, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, performLayout && !requiresStretchLayout, "flex");
                    currentRelativeChild = currentRelativeChild.nextChild;
                }
            }
            remainingFreeSpace = originalRemainingFreeSpace + deltaFreeSpace;
            if (measureModeMainDim == CSSMeasureMode.AT_MOST) {
                remainingFreeSpace = 0.0f;
            }
            if (justifyContent != CSSJustify.FLEX_START) {
                if (justifyContent == CSSJustify.CENTER) {
                    leadingMainDim = remainingFreeSpace / 2.0f;
                } else if (justifyContent == CSSJustify.FLEX_END) {
                    leadingMainDim = remainingFreeSpace;
                } else if (justifyContent == CSSJustify.SPACE_BETWEEN) {
                    remainingFreeSpace = Math.max(remainingFreeSpace, 0.0f);
                    betweenMainDim = itemsOnLine > 1 ? remainingFreeSpace / (float)(itemsOnLine - 1) : 0.0f;
                } else if (justifyContent == CSSJustify.SPACE_AROUND) {
                    betweenMainDim = remainingFreeSpace / (float)itemsOnLine;
                    leadingMainDim = betweenMainDim / 2.0f;
                }
            }
            float mainDim = leadingPaddingAndBorderMain + leadingMainDim;
            float crossDim = 0.0f;
            for (i = startOfLineIndex; i < endOfLineIndex; ++i) {
                child = node.getChildAt(i);
                if (child.style.positionType == CSSPositionType.ABSOLUTE && !Float.isNaN(child.style.position[leading[mainAxis]])) {
                    if (!performLayout) continue;
                    child.layout.position[LayoutEngine.pos[mainAxis]] = (Float.isNaN(child.style.position[leading[mainAxis]]) ? 0.0f : child.style.position[leading[mainAxis]]) + node.style.border.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]);
                    continue;
                }
                if (performLayout) {
                    int n = pos[mainAxis];
                    child.layout.position[n] = child.layout.position[n] + mainDim;
                }
                if (child.style.positionType != CSSPositionType.RELATIVE) continue;
                if (canSkipFlex) {
                    mainDim += betweenMainDim + (child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis])) + child.layout.flexBasis;
                    crossDim = availableInnerCrossDim;
                    continue;
                }
                mainDim += betweenMainDim + (child.layout.measuredDimensions[dim[mainAxis]] + child.style.margin.getWithFallback(leadingSpacing[mainAxis], leading[mainAxis]) + child.style.margin.getWithFallback(trailingSpacing[mainAxis], trailing[mainAxis]));
                crossDim = Math.max(crossDim, child.layout.measuredDimensions[dim[crossAxis]] + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
            }
            mainDim += trailingPaddingAndBorderMain;
            float containerCrossAxis = availableInnerCrossDim;
            if (measureModeCrossDim == CSSMeasureMode.UNDEFINED || measureModeCrossDim == CSSMeasureMode.AT_MOST) {
                containerCrossAxis = LayoutEngine.boundAxis(node, crossAxis, crossDim + paddingAndBorderAxisCross) - paddingAndBorderAxisCross;
                if (measureModeCrossDim == CSSMeasureMode.AT_MOST) {
                    containerCrossAxis = Math.min(containerCrossAxis, availableInnerCrossDim);
                }
            }
            if (!isNodeFlexWrap && measureModeCrossDim == CSSMeasureMode.EXACTLY) {
                crossDim = availableInnerCrossDim;
            }
            crossDim = LayoutEngine.boundAxis(node, crossAxis, crossDim + paddingAndBorderAxisCross) - paddingAndBorderAxisCross;
            if (performLayout) {
                for (i = startOfLineIndex; i < endOfLineIndex; ++i) {
                    child = node.getChildAt(i);
                    if (child.style.positionType == CSSPositionType.ABSOLUTE) {
                        if (!Float.isNaN(child.style.position[leading[crossAxis]])) {
                            child.layout.position[LayoutEngine.pos[crossAxis]] = (Float.isNaN(child.style.position[leading[crossAxis]]) ? 0.0f : child.style.position[leading[crossAxis]]) + node.style.border.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                            continue;
                        }
                        child.layout.position[LayoutEngine.pos[crossAxis]] = leadingPaddingAndBorderCross + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                        continue;
                    }
                    float leadingCrossDim = leadingPaddingAndBorderCross;
                    CSSAlign alignItem = LayoutEngine.getAlignItem(node, child);
                    if (alignItem == CSSAlign.STRETCH) {
                        childWidth = child.layout.measuredDimensions[0] + (child.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + child.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
                        childHeight = child.layout.measuredDimensions[1] + (child.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + child.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
                        boolean isCrossSizeDefinite = false;
                        if (isMainAxisRow) {
                            isCrossSizeDefinite = (double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0;
                            childHeight = crossDim;
                        } else {
                            isCrossSizeDefinite = (double)child.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0;
                            childWidth = crossDim;
                        }
                        if (!isCrossSizeDefinite) {
                            childWidthMeasureMode = Float.isNaN(childWidth) ? CSSMeasureMode.UNDEFINED : CSSMeasureMode.EXACTLY;
                            childHeightMeasureMode = Float.isNaN(childHeight) ? CSSMeasureMode.UNDEFINED : CSSMeasureMode.EXACTLY;
                            LayoutEngine.layoutNodeInternal(layoutContext, child, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, true, "stretch");
                        }
                    } else if (alignItem != CSSAlign.FLEX_START) {
                        float remainingCrossDim = containerCrossAxis - (child.layout.measuredDimensions[dim[crossAxis]] + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]));
                        leadingCrossDim = alignItem == CSSAlign.CENTER ? (leadingCrossDim += remainingCrossDim / 2.0f) : (leadingCrossDim += remainingCrossDim);
                    }
                    int n = pos[crossAxis];
                    child.layout.position[n] = child.layout.position[n] + (totalLineCrossDim + leadingCrossDim);
                }
            }
            totalLineCrossDim += crossDim;
            maxLineMainDim = Math.max(maxLineMainDim, mainDim);
            ++lineCount;
            endOfLineIndex = startOfLineIndex = endOfLineIndex;
        }
        if (lineCount > 1 && performLayout && !Float.isNaN(availableInnerCrossDim)) {
            float remainingAlignContentDim = availableInnerCrossDim - totalLineCrossDim;
            float crossDimLead = 0.0f;
            float currentLead = leadingPaddingAndBorderCross;
            CSSAlign alignContent = node.style.alignContent;
            if (alignContent == CSSAlign.FLEX_END) {
                currentLead += remainingAlignContentDim;
            } else if (alignContent == CSSAlign.CENTER) {
                currentLead += remainingAlignContentDim / 2.0f;
            } else if (alignContent == CSSAlign.STRETCH && availableInnerCrossDim > totalLineCrossDim) {
                crossDimLead = remainingAlignContentDim / (float)lineCount;
            }
            int endIndex = 0;
            for (i = 0; i < lineCount; ++i) {
                int j;
                int startIndex = endIndex;
                float lineHeight = 0.0f;
                for (j = startIndex; j < childCount; ++j) {
                    child = node.getChildAt(j);
                    if (child.style.positionType != CSSPositionType.RELATIVE) continue;
                    if (child.lineIndex != i) break;
                    if (!((double)child.layout.measuredDimensions[dim[crossAxis]] >= 0.0)) continue;
                    lineHeight = Math.max(lineHeight, child.layout.measuredDimensions[dim[crossAxis]] + (child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]) + child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis])));
                }
                endIndex = j;
                lineHeight += crossDimLead;
                if (performLayout) {
                    for (j = startIndex; j < endIndex; ++j) {
                        child = node.getChildAt(j);
                        if (child.style.positionType != CSSPositionType.RELATIVE) continue;
                        CSSAlign alignContentAlignItem = LayoutEngine.getAlignItem(node, child);
                        if (alignContentAlignItem == CSSAlign.FLEX_START) {
                            child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                            continue;
                        }
                        if (alignContentAlignItem == CSSAlign.FLEX_END) {
                            child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + lineHeight - child.style.margin.getWithFallback(trailingSpacing[crossAxis], trailing[crossAxis]) - child.layout.measuredDimensions[dim[crossAxis]];
                            continue;
                        }
                        if (alignContentAlignItem == CSSAlign.CENTER) {
                            childHeight = child.layout.measuredDimensions[dim[crossAxis]];
                            child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + (lineHeight - childHeight) / 2.0f;
                            continue;
                        }
                        if (alignContentAlignItem != CSSAlign.STRETCH) continue;
                        child.layout.position[LayoutEngine.pos[crossAxis]] = currentLead + child.style.margin.getWithFallback(leadingSpacing[crossAxis], leading[crossAxis]);
                    }
                }
                currentLead += lineHeight;
            }
        }
        node.layout.measuredDimensions[0] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_ROW, availableWidth - marginAxisRow);
        node.layout.measuredDimensions[1] = LayoutEngine.boundAxis(node, CSS_FLEX_DIRECTION_COLUMN, availableHeight - marginAxisColumn);
        if (measureModeMainDim == CSSMeasureMode.UNDEFINED) {
            node.layout.measuredDimensions[LayoutEngine.dim[mainAxis]] = LayoutEngine.boundAxis(node, mainAxis, maxLineMainDim);
        } else if (measureModeMainDim == CSSMeasureMode.AT_MOST) {
            node.layout.measuredDimensions[LayoutEngine.dim[mainAxis]] = Math.max(Math.min(availableInnerMainDim + paddingAndBorderAxisMain, LayoutEngine.boundAxisWithinMinAndMax(node, mainAxis, maxLineMainDim)), paddingAndBorderAxisMain);
        }
        if (measureModeCrossDim == CSSMeasureMode.UNDEFINED) {
            node.layout.measuredDimensions[LayoutEngine.dim[crossAxis]] = LayoutEngine.boundAxis(node, crossAxis, totalLineCrossDim + paddingAndBorderAxisCross);
        } else if (measureModeCrossDim == CSSMeasureMode.AT_MOST) {
            node.layout.measuredDimensions[LayoutEngine.dim[crossAxis]] = Math.max(Math.min(availableInnerCrossDim + paddingAndBorderAxisCross, LayoutEngine.boundAxisWithinMinAndMax(node, crossAxis, totalLineCrossDim + paddingAndBorderAxisCross)), paddingAndBorderAxisCross);
        }
        if (performLayout) {
            boolean needsMainTrailingPos = false;
            boolean needsCrossTrailingPos = false;
            if (mainAxis == CSS_FLEX_DIRECTION_ROW_REVERSE || mainAxis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
                needsMainTrailingPos = true;
            }
            if (crossAxis == CSS_FLEX_DIRECTION_ROW_REVERSE || crossAxis == CSS_FLEX_DIRECTION_COLUMN_REVERSE) {
                needsCrossTrailingPos = true;
            }
            if (needsMainTrailingPos || needsCrossTrailingPos) {
                for (i = 0; i < childCount; ++i) {
                    child = node.getChildAt(i);
                    if (needsMainTrailingPos) {
                        child.layout.position[LayoutEngine.trailing[mainAxis]] = node.layout.measuredDimensions[dim[mainAxis]] - (child.style.positionType == CSSPositionType.ABSOLUTE ? 0.0f : child.layout.measuredDimensions[dim[mainAxis]]) - child.layout.position[pos[mainAxis]];
                    }
                    if (!needsCrossTrailingPos) continue;
                    child.layout.position[LayoutEngine.trailing[crossAxis]] = node.layout.measuredDimensions[dim[crossAxis]] - (child.style.positionType == CSSPositionType.ABSOLUTE ? 0.0f : child.layout.measuredDimensions[dim[crossAxis]]) - child.layout.position[pos[crossAxis]];
                }
            }
        }
        currentAbsoluteChild = firstAbsoluteChild;
        while (currentAbsoluteChild != null) {
            if (performLayout) {
                childWidth = Float.NaN;
                childHeight = Float.NaN;
                if ((double)currentAbsoluteChild.style.dimensions[dim[CSS_FLEX_DIRECTION_ROW]] >= 0.0) {
                    childWidth = currentAbsoluteChild.style.dimensions[0] + (currentAbsoluteChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + currentAbsoluteChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
                } else if (!Float.isNaN(currentAbsoluteChild.style.position[0]) && !Float.isNaN(currentAbsoluteChild.style.position[2])) {
                    childWidth = node.layout.measuredDimensions[0] - (node.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + node.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW])) - (currentAbsoluteChild.style.position[0] + currentAbsoluteChild.style.position[2]);
                    childWidth = LayoutEngine.boundAxis(currentAbsoluteChild, CSS_FLEX_DIRECTION_ROW, childWidth);
                }
                if ((double)currentAbsoluteChild.style.dimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] >= 0.0) {
                    childHeight = currentAbsoluteChild.style.dimensions[1] + (currentAbsoluteChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + currentAbsoluteChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
                } else if (!Float.isNaN(currentAbsoluteChild.style.position[1]) && !Float.isNaN(currentAbsoluteChild.style.position[3])) {
                    childHeight = node.layout.measuredDimensions[1] - (node.style.border.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + node.style.border.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN])) - (currentAbsoluteChild.style.position[1] + currentAbsoluteChild.style.position[3]);
                    childHeight = LayoutEngine.boundAxis(currentAbsoluteChild, CSS_FLEX_DIRECTION_COLUMN, childHeight);
                }
                if (Float.isNaN(childWidth) || Float.isNaN(childHeight)) {
                    childWidthMeasureMode = Float.isNaN(childWidth) ? CSSMeasureMode.UNDEFINED : CSSMeasureMode.EXACTLY;
                    CSSMeasureMode cSSMeasureMode = childHeightMeasureMode = Float.isNaN(childHeight) ? CSSMeasureMode.UNDEFINED : CSSMeasureMode.EXACTLY;
                    if (!isMainAxisRow && Float.isNaN(childWidth) && !Float.isNaN(availableInnerWidth)) {
                        childWidth = availableInnerWidth;
                        childWidthMeasureMode = CSSMeasureMode.AT_MOST;
                    }
                    if (node.style.overflow == CSSOverflow.HIDDEN && isMainAxisRow && Float.isNaN(childHeight) && !Float.isNaN(availableInnerHeight)) {
                        childHeight = availableInnerHeight;
                        childHeightMeasureMode = CSSMeasureMode.AT_MOST;
                    }
                    LayoutEngine.layoutNodeInternal(layoutContext, currentAbsoluteChild, childWidth, childHeight, direction, childWidthMeasureMode, childHeightMeasureMode, false, "abs-measure");
                    childWidth = currentAbsoluteChild.layout.measuredDimensions[0] + (currentAbsoluteChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_ROW], leading[CSS_FLEX_DIRECTION_ROW]) + currentAbsoluteChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_ROW], trailing[CSS_FLEX_DIRECTION_ROW]));
                    childHeight = currentAbsoluteChild.layout.measuredDimensions[1] + (currentAbsoluteChild.style.margin.getWithFallback(leadingSpacing[CSS_FLEX_DIRECTION_COLUMN], leading[CSS_FLEX_DIRECTION_COLUMN]) + currentAbsoluteChild.style.margin.getWithFallback(trailingSpacing[CSS_FLEX_DIRECTION_COLUMN], trailing[CSS_FLEX_DIRECTION_COLUMN]));
                }
                LayoutEngine.layoutNodeInternal(layoutContext, currentAbsoluteChild, childWidth, childHeight, direction, CSSMeasureMode.EXACTLY, CSSMeasureMode.EXACTLY, true, "abs-layout");
                if (!Float.isNaN(currentAbsoluteChild.style.position[trailing[CSS_FLEX_DIRECTION_ROW]]) && Float.isNaN(currentAbsoluteChild.style.position[leading[CSS_FLEX_DIRECTION_ROW]])) {
                    currentAbsoluteChild.layout.position[LayoutEngine.leading[LayoutEngine.CSS_FLEX_DIRECTION_ROW]] = node.layout.measuredDimensions[dim[CSS_FLEX_DIRECTION_ROW]] - currentAbsoluteChild.layout.measuredDimensions[dim[CSS_FLEX_DIRECTION_ROW]] - (Float.isNaN(currentAbsoluteChild.style.position[trailing[CSS_FLEX_DIRECTION_ROW]]) ? 0.0f : currentAbsoluteChild.style.position[trailing[CSS_FLEX_DIRECTION_ROW]]);
                }
                if (!Float.isNaN(currentAbsoluteChild.style.position[trailing[CSS_FLEX_DIRECTION_COLUMN]]) && Float.isNaN(currentAbsoluteChild.style.position[leading[CSS_FLEX_DIRECTION_COLUMN]])) {
                    currentAbsoluteChild.layout.position[LayoutEngine.leading[LayoutEngine.CSS_FLEX_DIRECTION_COLUMN]] = node.layout.measuredDimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] - currentAbsoluteChild.layout.measuredDimensions[dim[CSS_FLEX_DIRECTION_COLUMN]] - (Float.isNaN(currentAbsoluteChild.style.position[trailing[CSS_FLEX_DIRECTION_COLUMN]]) ? 0.0f : currentAbsoluteChild.style.position[trailing[CSS_FLEX_DIRECTION_COLUMN]]);
                }
            }
            currentAbsoluteChild = currentAbsoluteChild.nextChild;
        }
    }
}

