/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;

class FrameBasedAnimationDriver
extends AnimationDriver {
    private long mStartFrameTimeNanos = -1L;
    private final double[] mFrames;
    private final double mToValue;
    private double mFromValue;

    FrameBasedAnimationDriver(ReadableMap config) {
        ReadableArray frames = config.getArray("frames");
        int numberOfFrames = frames.size();
        this.mFrames = new double[numberOfFrames];
        for (int i = 0; i < numberOfFrames; ++i) {
            this.mFrames[i] = frames.getDouble(i);
        }
        this.mToValue = config.getDouble("toValue");
    }

    @Override
    public void runAnimationStep(long frameTimeNanos) {
        double nextValue;
        long timeFromStartNanos;
        int frameIndex;
        if (this.mStartFrameTimeNanos < 0L) {
            this.mStartFrameTimeNanos = frameTimeNanos;
            this.mFromValue = this.mAnimatedValue.mValue;
        }
        if ((frameIndex = (int)((timeFromStartNanos = frameTimeNanos - this.mStartFrameTimeNanos) / 1000000L * 60L / 1000L)) < 0) {
            throw new IllegalStateException("Calculated frame index should never be lower than 0");
        }
        if (this.mHasFinished) {
            return;
        }
        if (frameIndex >= this.mFrames.length - 1) {
            this.mHasFinished = true;
            nextValue = this.mToValue;
        } else {
            nextValue = this.mFromValue + this.mFrames[frameIndex] * (this.mToValue - this.mFromValue);
        }
        this.mAnimatedValue.mValue = nextValue;
    }
}

