/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.GuardedChoreographerFrameCallback;
import com.facebook.react.uimanager.ReactChoreographer;
import com.facebook.react.uimanager.UIImplementation;
import com.facebook.react.uimanager.UIManagerModule;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class NativeAnimatedModule
extends ReactContextBaseJavaModule
implements OnBatchCompleteListener,
LifecycleEventListener {
    private final Object mOperationsCopyLock = new Object();
    @Nullable
    private GuardedChoreographerFrameCallback mAnimatedFrameCallback;
    @Nullable
    private ReactChoreographer mReactChoreographer;
    private ArrayList<UIThreadOperation> mOperations = new ArrayList();
    @Nullable
    private volatile ArrayList<UIThreadOperation> mReadyOperations = null;

    public NativeAnimatedModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public void initialize() {
        this.mReactChoreographer = ReactChoreographer.getInstance();
        ReactApplicationContext reactCtx = this.getReactApplicationContext();
        UIImplementation uiImplementation = reactCtx.getNativeModule(UIManagerModule.class).getUIImplementation();
        final NativeAnimatedNodesManager nodesManager = new NativeAnimatedNodesManager(uiImplementation);
        this.mAnimatedFrameCallback = new GuardedChoreographerFrameCallback(reactCtx){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doFrameGuarded(long frameTimeNanos) {
                ArrayList operations;
                Object object = NativeAnimatedModule.this.mOperationsCopyLock;
                synchronized (object) {
                    operations = NativeAnimatedModule.this.mReadyOperations;
                    NativeAnimatedModule.this.mReadyOperations = null;
                }
                if (operations != null) {
                    int size = operations.size();
                    for (int i = 0; i < size; ++i) {
                        ((UIThreadOperation)operations.get(i)).execute(nodesManager);
                    }
                }
                if (nodesManager.hasActiveAnimations()) {
                    nodesManager.runUpdates(frameTimeNanos);
                }
                ((ReactChoreographer)Assertions.assertNotNull((Object)NativeAnimatedModule.this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, NativeAnimatedModule.this.mAnimatedFrameCallback);
            }
        };
        reactCtx.addLifecycleEventListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBatchComplete() {
        ArrayList<UIThreadOperation> operations;
        ArrayList<UIThreadOperation> arrayList = operations = this.mOperations.isEmpty() ? null : this.mOperations;
        if (operations != null) {
            this.mOperations = new ArrayList();
            Object object = this.mOperationsCopyLock;
            synchronized (object) {
                if (this.mReadyOperations == null) {
                    this.mReadyOperations = operations;
                } else {
                    this.mReadyOperations.addAll(operations);
                }
            }
        }
    }

    @Override
    public void onHostResume() {
        this.enqueueFrameCallback();
    }

    @Override
    public void onHostPause() {
        this.clearFrameCallback();
    }

    @Override
    public void onHostDestroy() {
    }

    @Override
    public String getName() {
        return "NativeAnimatedModule";
    }

    private void clearFrameCallback() {
        ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).removeFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mAnimatedFrameCallback);
    }

    private void enqueueFrameCallback() {
        ((ReactChoreographer)Assertions.assertNotNull((Object)this.mReactChoreographer)).postFrameCallback(ReactChoreographer.CallbackType.NATIVE_ANIMATED_MODULE, this.mAnimatedFrameCallback);
    }

    @ReactMethod
    public void createAnimatedNode(final int tag, final ReadableMap config) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.createAnimatedNode(tag, config);
            }
        });
    }

    @ReactMethod
    public void dropAnimatedNode(final int tag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.dropAnimatedNode(tag);
            }
        });
    }

    @ReactMethod
    public void setAnimatedNodeValue(final int tag, final double value) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.setAnimatedNodeValue(tag, value);
            }
        });
    }

    @ReactMethod
    public void startAnimatingNode(final int animationId, final int animatedNodeTag, final ReadableMap animationConfig, final Callback endCallback) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.startAnimatingNode(animationId, animatedNodeTag, animationConfig, endCallback);
            }
        });
    }

    @ReactMethod
    public void stopAnimation(final int animationId) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.stopAnimation(animationId);
            }
        });
    }

    @ReactMethod
    public void connectAnimatedNodes(final int parentNodeTag, final int childNodeTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.connectAnimatedNodes(parentNodeTag, childNodeTag);
            }
        });
    }

    @ReactMethod
    public void disconnectAnimatedNodes(final int parentNodeTag, final int childNodeTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.disconnectAnimatedNodes(parentNodeTag, childNodeTag);
            }
        });
    }

    @ReactMethod
    public void connectAnimatedNodeToView(final int animatedNodeTag, final int viewTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.connectAnimatedNodeToView(animatedNodeTag, viewTag);
            }
        });
    }

    @ReactMethod
    public void disconnectAnimatedNodeFromView(final int animatedNodeTag, final int viewTag) {
        this.mOperations.add(new UIThreadOperation(){

            @Override
            public void execute(NativeAnimatedNodesManager animatedNodesManager) {
                animatedNodesManager.disconnectAnimatedNodeFromView(animatedNodeTag, viewTag);
            }
        });
    }

    private static interface UIThreadOperation {
        public void execute(NativeAnimatedNodesManager var1);
    }
}

