/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.util.SparseArray;
import com.facebook.react.animated.AdditionAnimatedNode;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.AnimationDriver;
import com.facebook.react.animated.FrameBasedAnimationDriver;
import com.facebook.react.animated.InterpolationAnimatedNode;
import com.facebook.react.animated.MultiplicationAnimatedNode;
import com.facebook.react.animated.PropsAnimatedNode;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.UIImplementation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import javax.annotation.Nullable;

class NativeAnimatedNodesManager {
    private final SparseArray<AnimatedNode> mAnimatedNodes = new SparseArray();
    private final ArrayList<AnimationDriver> mActiveAnimations = new ArrayList();
    private final ArrayList<AnimatedNode> mUpdatedNodes = new ArrayList();
    private final UIImplementation mUIImplementation;
    private int mAnimatedGraphBFSColor = 0;

    public NativeAnimatedNodesManager(UIImplementation uiImplementation) {
        this.mUIImplementation = uiImplementation;
    }

    @Nullable
    AnimatedNode getNodeById(int id2) {
        return (AnimatedNode)this.mAnimatedNodes.get(id2);
    }

    public boolean hasActiveAnimations() {
        return !this.mActiveAnimations.isEmpty() || !this.mUpdatedNodes.isEmpty();
    }

    public void createAnimatedNode(int tag, ReadableMap config) {
        AnimatedNode node;
        if (this.mAnimatedNodes.get(tag) != null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " already exists");
        }
        String type = config.getString("type");
        if ("style".equals(type)) {
            node = new StyleAnimatedNode(config, this);
        } else if ("value".equals(type)) {
            node = new ValueAnimatedNode(config);
            this.mUpdatedNodes.add(node);
        } else if ("props".equals(type)) {
            node = new PropsAnimatedNode(config, this);
        } else if ("interpolation".equals(type)) {
            node = new InterpolationAnimatedNode(config);
        } else if ("addition".equals(type)) {
            node = new AdditionAnimatedNode(config, this);
        } else if ("multiplication".equals(type)) {
            node = new MultiplicationAnimatedNode(config, this);
        } else {
            throw new JSApplicationIllegalArgumentException("Unsupported node type: " + type);
        }
        node.mTag = tag;
        this.mAnimatedNodes.put(tag, (Object)node);
    }

    public void dropAnimatedNode(int tag) {
        this.mAnimatedNodes.remove(tag);
    }

    public void setAnimatedNodeValue(int tag, double value) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(tag);
        if (node == null || !(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + tag + " does not exists or is not a 'value' node");
        }
        ((ValueAnimatedNode)node).mValue = value;
        this.mUpdatedNodes.add(node);
    }

    public void startAnimatingNode(int animationId, int animatedNodeTag, ReadableMap animationConfig, Callback endCallback) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + animatedNodeTag + " does not exists");
        }
        if (!(node instanceof ValueAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node should be of type " + ValueAnimatedNode.class.getName());
        }
        String type = animationConfig.getString("type");
        if (!"frames".equals(type)) {
            throw new JSApplicationIllegalArgumentException("Unsupported animation type: " + type);
        }
        FrameBasedAnimationDriver animation = new FrameBasedAnimationDriver(animationConfig);
        animation.mId = animationId;
        animation.mEndCallback = endCallback;
        animation.mAnimatedValue = (ValueAnimatedNode)node;
        this.mActiveAnimations.add(animation);
    }

    public void stopAnimation(int animationId) {
        for (int i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = this.mActiveAnimations.get(i);
            if (animation.mId != animationId) continue;
            WritableMap endCallbackResponse = Arguments.createMap();
            endCallbackResponse.putBoolean("finished", false);
            animation.mEndCallback.invoke(endCallbackResponse);
            this.mActiveAnimations.remove(i);
            return;
        }
    }

    public void connectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode parentNode = (AnimatedNode)this.mAnimatedNodes.get(parentNodeTag);
        if (parentNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + parentNodeTag + " does not exists");
        }
        AnimatedNode childNode = (AnimatedNode)this.mAnimatedNodes.get(childNodeTag);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + childNodeTag + " does not exists");
        }
        parentNode.addChild(childNode);
    }

    public void disconnectAnimatedNodes(int parentNodeTag, int childNodeTag) {
        AnimatedNode parentNode = (AnimatedNode)this.mAnimatedNodes.get(parentNodeTag);
        if (parentNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + parentNodeTag + " does not exists");
        }
        AnimatedNode childNode = (AnimatedNode)this.mAnimatedNodes.get(childNodeTag);
        if (childNode == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + childNodeTag + " does not exists");
        }
        parentNode.removeChild(childNode);
    }

    public void connectAnimatedNodeToView(int animatedNodeTag, int viewTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + animatedNodeTag + " does not exists");
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view should beof type " + PropsAnimatedNode.class.getName());
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        if (propsAnimatedNode.mConnectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Animated node " + animatedNodeTag + " is " + "already attached to a view");
        }
        propsAnimatedNode.mConnectedViewTag = viewTag;
    }

    public void disconnectAnimatedNodeFromView(int animatedNodeTag, int viewTag) {
        AnimatedNode node = (AnimatedNode)this.mAnimatedNodes.get(animatedNodeTag);
        if (node == null) {
            throw new JSApplicationIllegalArgumentException("Animated node with tag " + animatedNodeTag + " does not exists");
        }
        if (!(node instanceof PropsAnimatedNode)) {
            throw new JSApplicationIllegalArgumentException("Animated node connected to view should beof type " + PropsAnimatedNode.class.getName());
        }
        PropsAnimatedNode propsAnimatedNode = (PropsAnimatedNode)node;
        if (propsAnimatedNode.mConnectedViewTag != viewTag) {
            throw new JSApplicationIllegalArgumentException("Attempting to disconnect view that has not been connected with the given animated node");
        }
        propsAnimatedNode.mConnectedViewTag = -1;
    }

    public void runUpdates(long frameTimeNanos) {
        AnimatedNode child;
        ValueAnimatedNode valueNode;
        int i;
        UiThreadUtil.assertOnUiThread();
        int activeNodesCount = 0;
        int updatedNodesCount = 0;
        boolean hasFinishedAnimations = false;
        ++this.mAnimatedGraphBFSColor;
        if (this.mAnimatedGraphBFSColor == 0) {
            ++this.mAnimatedGraphBFSColor;
        }
        ArrayDeque<AnimatedNode> nodesQueue = new ArrayDeque<AnimatedNode>();
        for (i = 0; i < this.mUpdatedNodes.size(); ++i) {
            AnimatedNode node = this.mUpdatedNodes.get(i);
            if (node.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            node.mBFSColor = this.mAnimatedGraphBFSColor;
            ++activeNodesCount;
            nodesQueue.add(node);
        }
        for (i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = this.mActiveAnimations.get(i);
            animation.runAnimationStep(frameTimeNanos);
            valueNode = animation.mAnimatedValue;
            if (valueNode.mBFSColor != this.mAnimatedGraphBFSColor) {
                valueNode.mBFSColor = this.mAnimatedGraphBFSColor;
                ++activeNodesCount;
                nodesQueue.add(valueNode);
            }
            if (!animation.mHasFinished) continue;
            hasFinishedAnimations = true;
        }
        while (!nodesQueue.isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            if (nextNode.mChildren == null) continue;
            for (int i2 = 0; i2 < nextNode.mChildren.size(); ++i2) {
                child = nextNode.mChildren.get(i2);
                ++child.mActiveIncomingNodes;
                if (child.mBFSColor == this.mAnimatedGraphBFSColor) continue;
                child.mBFSColor = this.mAnimatedGraphBFSColor;
                ++activeNodesCount;
                nodesQueue.add(child);
            }
        }
        ++this.mAnimatedGraphBFSColor;
        if (this.mAnimatedGraphBFSColor == 0) {
            ++this.mAnimatedGraphBFSColor;
        }
        for (i = 0; i < this.mUpdatedNodes.size(); ++i) {
            AnimatedNode node = this.mUpdatedNodes.get(i);
            if (node.mActiveIncomingNodes != 0 || node.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            node.mBFSColor = this.mAnimatedGraphBFSColor;
            ++updatedNodesCount;
            nodesQueue.add(node);
        }
        for (i = 0; i < this.mActiveAnimations.size(); ++i) {
            AnimationDriver animation = this.mActiveAnimations.get(i);
            valueNode = animation.mAnimatedValue;
            if (valueNode.mActiveIncomingNodes != 0 || valueNode.mBFSColor == this.mAnimatedGraphBFSColor) continue;
            valueNode.mBFSColor = this.mAnimatedGraphBFSColor;
            ++updatedNodesCount;
            nodesQueue.add(valueNode);
        }
        while (!nodesQueue.isEmpty()) {
            AnimatedNode nextNode = (AnimatedNode)nodesQueue.poll();
            nextNode.update();
            if (nextNode instanceof PropsAnimatedNode) {
                ((PropsAnimatedNode)nextNode).updateView(this.mUIImplementation);
            }
            if (nextNode.mChildren == null) continue;
            for (int i3 = 0; i3 < nextNode.mChildren.size(); ++i3) {
                child = nextNode.mChildren.get(i3);
                --child.mActiveIncomingNodes;
                if (child.mBFSColor == this.mAnimatedGraphBFSColor || child.mActiveIncomingNodes != 0) continue;
                child.mBFSColor = this.mAnimatedGraphBFSColor;
                ++updatedNodesCount;
                nodesQueue.add(child);
            }
        }
        if (activeNodesCount != updatedNodesCount) {
            throw new IllegalStateException("Looks like animated nodes graph has cycles, there are " + activeNodesCount + " but toposort visited only " + updatedNodesCount);
        }
        this.mUpdatedNodes.clear();
        if (hasFinishedAnimations) {
            int i4;
            int dest = 0;
            for (i4 = 0; i4 < this.mActiveAnimations.size(); ++i4) {
                AnimationDriver animation = this.mActiveAnimations.get(i4);
                if (!animation.mHasFinished) {
                    this.mActiveAnimations.set(dest++, animation);
                    continue;
                }
                WritableMap endCallbackResponse = Arguments.createMap();
                endCallbackResponse.putBoolean("finished", true);
                animation.mEndCallback.invoke(endCallbackResponse);
            }
            for (i4 = this.mActiveAnimations.size() - 1; i4 >= dest; --i4) {
                this.mActiveAnimations.remove(i4);
            }
        }
    }
}

