/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.UIImplementation;
import java.util.HashMap;
import java.util.Map;

class PropsAnimatedNode
extends AnimatedNode {
    int mConnectedViewTag = -1;
    private final NativeAnimatedNodesManager mNativeAnimatedNodesManager;
    private final Map<String, Integer> mPropMapping;

    PropsAnimatedNode(ReadableMap config, NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        ReadableMap props = config.getMap("props");
        ReadableMapKeySetIterator iter = props.keySetIterator();
        this.mPropMapping = new HashMap<String, Integer>();
        while (iter.hasNextKey()) {
            String propKey = iter.nextKey();
            int nodeIndex = props.getInt(propKey);
            this.mPropMapping.put(propKey, nodeIndex);
        }
        this.mNativeAnimatedNodesManager = nativeAnimatedNodesManager;
    }

    public final void updateView(UIImplementation uiImplementation) {
        if (this.mConnectedViewTag == -1) {
            throw new IllegalStateException("Node has not been attached to a view");
        }
        JavaOnlyMap propsMap = new JavaOnlyMap();
        for (Map.Entry<String, Integer> entry : this.mPropMapping.entrySet()) {
            AnimatedNode node = this.mNativeAnimatedNodesManager.getNodeById(entry.getValue());
            if (node == null) {
                throw new IllegalArgumentException("Mapped property node does not exists");
            }
            if (node instanceof StyleAnimatedNode) {
                ((StyleAnimatedNode)node).collectViewUpdates(propsMap);
                continue;
            }
            if (node instanceof ValueAnimatedNode) {
                propsMap.putDouble(entry.getKey(), ((ValueAnimatedNode)node).mValue);
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of node used in property node " + node.getClass());
        }
        uiImplementation.synchronouslyUpdateViewOnUIThread(this.mConnectedViewTag, new ReactStylesDiffMap(propsMap));
    }
}

