/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import android.os.Bundle;
import com.facebook.react.bridge.WritableNativeArray;
import com.facebook.react.bridge.WritableNativeMap;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import java.util.Map;

public class Arguments {
    private static Object makeNativeObject(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Float || object instanceof Long || object instanceof Byte || object instanceof Short) {
            return new Double(((Number)object).doubleValue());
        }
        if (object.getClass().isArray()) {
            return Arguments.makeNativeArray(object);
        }
        if (object instanceof List) {
            return Arguments.makeNativeArray((List)object);
        }
        if (object instanceof Map) {
            return Arguments.makeNativeMap((Map)object);
        }
        if (object instanceof Bundle) {
            return Arguments.makeNativeMap((Bundle)object);
        }
        return object;
    }

    public static WritableNativeArray makeNativeArray(List objects) {
        WritableNativeArray nativeArray = new WritableNativeArray();
        if (objects == null) {
            return nativeArray;
        }
        for (Object elem : objects) {
            if ((elem = Arguments.makeNativeObject(elem)) == null) {
                nativeArray.pushNull();
                continue;
            }
            if (elem instanceof Boolean) {
                nativeArray.pushBoolean((Boolean)elem);
                continue;
            }
            if (elem instanceof Integer) {
                nativeArray.pushInt((Integer)elem);
                continue;
            }
            if (elem instanceof Double) {
                nativeArray.pushDouble((Double)elem);
                continue;
            }
            if (elem instanceof String) {
                nativeArray.pushString((String)elem);
                continue;
            }
            if (elem instanceof WritableNativeArray) {
                nativeArray.pushArray((WritableNativeArray)elem);
                continue;
            }
            if (elem instanceof WritableNativeMap) {
                nativeArray.pushMap((WritableNativeMap)elem);
                continue;
            }
            throw new IllegalArgumentException("Could not convert " + elem.getClass());
        }
        return nativeArray;
    }

    public static <T> WritableNativeArray makeNativeArray(final Object objects) {
        if (objects == null) {
            return new WritableNativeArray();
        }
        return Arguments.makeNativeArray(new AbstractList(){

            @Override
            public int size() {
                return Array.getLength(objects);
            }

            @Override
            public Object get(int index) {
                return Array.get(objects, index);
            }
        });
    }

    private static void addEntry(WritableNativeMap nativeMap, String key, Object value) {
        if ((value = Arguments.makeNativeObject(value)) == null) {
            nativeMap.putNull(key);
        } else if (value instanceof Boolean) {
            nativeMap.putBoolean(key, (Boolean)value);
        } else if (value instanceof Integer) {
            nativeMap.putInt(key, (Integer)value);
        } else if (value instanceof Number) {
            nativeMap.putDouble(key, ((Number)value).doubleValue());
        } else if (value instanceof String) {
            nativeMap.putString(key, (String)value);
        } else if (value instanceof WritableNativeArray) {
            nativeMap.putArray(key, (WritableNativeArray)value);
        } else if (value instanceof WritableNativeMap) {
            nativeMap.putMap(key, (WritableNativeMap)value);
        } else {
            throw new IllegalArgumentException("Could not convert " + value.getClass());
        }
    }

    public static WritableNativeMap makeNativeMap(Map<String, Object> objects) {
        WritableNativeMap nativeMap = new WritableNativeMap();
        if (objects == null) {
            return nativeMap;
        }
        for (Map.Entry<String, Object> entry : objects.entrySet()) {
            Arguments.addEntry(nativeMap, entry.getKey(), entry.getValue());
        }
        return nativeMap;
    }

    public static WritableNativeMap makeNativeMap(Bundle bundle) {
        WritableNativeMap nativeMap = new WritableNativeMap();
        if (bundle == null) {
            return nativeMap;
        }
        for (String key : bundle.keySet()) {
            Arguments.addEntry(nativeMap, key, bundle.get(key));
        }
        return nativeMap;
    }
}

