/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import android.content.res.AssetManager;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.jni.HybridData;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.JavaScriptModuleRegistry;
import com.facebook.react.bridge.MemoryPressure;
import com.facebook.react.bridge.NativeArray;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.Systrace;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationImpl;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.cxxbridge.JSBundleLoader;
import com.facebook.react.cxxbridge.JavaScriptExecutor;
import com.facebook.react.cxxbridge.ModuleRegistryHolder;
import com.facebook.react.cxxbridge.NativeModuleRegistry;
import com.facebook.react.cxxbridge.ReactCallback;
import com.facebook.react.cxxbridge.UiThreadUtil;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.TraceListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

@DoNotStrip
public class CatalystInstanceImpl
implements CatalystInstance {
    static final String REACT_NATIVE_LIB = "reactnativejnifb";
    private static final int BRIDGE_SETUP_TIMEOUT_MS = 30000;
    private static final int LOAD_JS_BUNDLE_TIMEOUT_MS = 30000;
    private static final AtomicInteger sNextInstanceIdForTrace;
    private final ReactQueueConfigurationImpl mReactQueueConfiguration;
    private final CopyOnWriteArrayList<NotThreadSafeBridgeIdleDebugListener> mBridgeIdleListeners;
    private final AtomicInteger mPendingJSCalls = new AtomicInteger(0);
    private final String mJsPendingCallsTitleForTrace = "pending_js_calls_instance" + sNextInstanceIdForTrace.getAndIncrement();
    private volatile boolean mDestroyed = false;
    private final TraceListener mTraceListener;
    private final JavaScriptModuleRegistry mJSModuleRegistry;
    private final JSBundleLoader mJSBundleLoader;
    private ExecutorToken mMainExecutorToken;
    private final NativeModuleRegistry mJavaRegistry;
    private final NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;
    private boolean mInitialized = false;
    private volatile boolean mAcceptCalls = false;
    private boolean mJSBundleHasLoaded;
    private final HybridData mHybridData;

    private static native HybridData initHybrid();

    private CatalystInstanceImpl(ReactQueueConfigurationSpec ReactQueueConfigurationSpec2, JavaScriptExecutor jsExecutor, NativeModuleRegistry registry, JavaScriptModuleRegistry jsModuleRegistry, JSBundleLoader jsBundleLoader, NativeModuleCallExceptionHandler nativeModuleCallExceptionHandler) {
        FLog.d((String)"React", (String)"Initializing React Xplat Bridge.");
        this.mHybridData = CatalystInstanceImpl.initHybrid();
        this.mReactQueueConfiguration = ReactQueueConfigurationImpl.create(ReactQueueConfigurationSpec2, new NativeExceptionHandler());
        this.mBridgeIdleListeners = new CopyOnWriteArrayList();
        this.mJavaRegistry = registry;
        this.mJSModuleRegistry = jsModuleRegistry;
        this.mJSBundleLoader = jsBundleLoader;
        this.mNativeModuleCallExceptionHandler = nativeModuleCallExceptionHandler;
        this.mTraceListener = new JSProfilerTraceListener(this);
        this.initializeBridge(new BridgeCallback(this), jsExecutor, this.mReactQueueConfiguration.getJSQueueThread(), this.mReactQueueConfiguration.getNativeModulesQueueThread(), this.mJavaRegistry.getModuleRegistryHolder(this));
        this.mMainExecutorToken = this.getMainExecutorToken();
    }

    private native void initializeBridge(ReactCallback var1, JavaScriptExecutor var2, MessageQueueThread var3, MessageQueueThread var4, ModuleRegistryHolder var5);

    native void loadScriptFromAssets(AssetManager var1, String var2);

    native void loadScriptFromFile(String var1, String var2);

    native void loadScriptFromOptimizedBundle(String var1, String var2, int var3);

    @Override
    public void runJSBundle() {
        this.mAcceptCalls = true;
        Assertions.assertCondition((!this.mJSBundleHasLoaded ? 1 : 0) != 0, (String)"JS bundle was already loaded!");
        this.mJSBundleHasLoaded = true;
        this.mJSBundleLoader.loadScript(this);
        com.facebook.systrace.Systrace.registerListener(this.mTraceListener);
    }

    private native void callJSFunction(ExecutorToken var1, String var2, String var3, NativeArray var4);

    @Override
    public void callFunction(ExecutorToken executorToken, String module, String method, NativeArray arguments) {
        if (this.mDestroyed) {
            FLog.w((String)"React", (String)"Calling JS function after bridge has been destroyed.");
            return;
        }
        if (!this.mAcceptCalls) {
            throw new RuntimeException("Attempt to call JS function before JS bundle is loaded.");
        }
        this.callJSFunction(executorToken, module, method, arguments);
    }

    private native void callJSCallback(ExecutorToken var1, int var2, NativeArray var3);

    @Override
    public void invokeCallback(ExecutorToken executorToken, int callbackID, NativeArray arguments) {
        if (this.mDestroyed) {
            FLog.w((String)"React", (String)"Invoking JS callback after bridge has been destroyed.");
            return;
        }
        this.callJSCallback(executorToken, callbackID, arguments);
    }

    @Override
    public void destroy() {
        boolean wasIdle;
        UiThreadUtil.assertOnUiThread();
        if (this.mDestroyed) {
            return;
        }
        this.mDestroyed = true;
        this.mHybridData.resetNative();
        this.mJavaRegistry.notifyCatalystInstanceDestroy();
        boolean bl = wasIdle = this.mPendingJSCalls.getAndSet(0) == 0;
        if (!wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeIdle();
            }
        }
        com.facebook.systrace.Systrace.unregisterListener(this.mTraceListener);
    }

    @Override
    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @Override
    @VisibleForTesting
    public void initialize() {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((!this.mInitialized ? 1 : 0) != 0, (String)"This catalyst instance has already been initialized");
        Assertions.assertCondition((boolean)this.mAcceptCalls, (String)"RunJSBundle hasn't completed.");
        this.mInitialized = true;
        this.mJavaRegistry.notifyCatalystInstanceInitialized();
    }

    @Override
    public ReactQueueConfiguration getReactQueueConfiguration() {
        return this.mReactQueueConfiguration;
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(Class<T> jsInterface) {
        return this.getJSModule(this.mMainExecutorToken, jsInterface);
    }

    @Override
    public <T extends JavaScriptModule> T getJSModule(ExecutorToken executorToken, Class<T> jsInterface) {
        return ((JavaScriptModuleRegistry)Assertions.assertNotNull((Object)this.mJSModuleRegistry)).getJavaScriptModule(this, executorToken, jsInterface);
    }

    private native ExecutorToken getMainExecutorToken();

    @Override
    public <T extends NativeModule> boolean hasNativeModule(Class<T> nativeModuleInterface) {
        return this.mJavaRegistry.hasModule(nativeModuleInterface);
    }

    @Override
    public <T extends NativeModule> T getNativeModule(Class<T> nativeModuleInterface) {
        return this.mJavaRegistry.getModule(nativeModuleInterface);
    }

    @Override
    public Collection<NativeModule> getNativeModules() {
        return this.mJavaRegistry.getAllModules();
    }

    private native void handleMemoryPressureUiHidden();

    private native void handleMemoryPressureModerate();

    private native void handleMemoryPressureCritical();

    @Override
    public void handleMemoryPressure(MemoryPressure level) {
        if (this.mDestroyed) {
            return;
        }
        switch (level) {
            case UI_HIDDEN: {
                this.handleMemoryPressureUiHidden();
                break;
            }
            case MODERATE: {
                this.handleMemoryPressureModerate();
                break;
            }
            case CRITICAL: {
                this.handleMemoryPressureCritical();
            }
        }
    }

    @Override
    public void addBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.add(listener);
    }

    @Override
    public void removeBridgeIdleDebugListener(NotThreadSafeBridgeIdleDebugListener listener) {
        this.mBridgeIdleListeners.remove(listener);
    }

    @Override
    public native void setGlobalVariable(String var1, String var2);

    @Override
    public native boolean supportsProfiling();

    @Override
    public native void startProfiler(String var1);

    @Override
    public native void stopProfiler(String var1, String var2);

    private void incrementPendingJSCalls() {
        int oldPendingCalls = this.mPendingJSCalls.getAndIncrement();
        boolean wasIdle = oldPendingCalls == 0;
        com.facebook.systrace.Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, oldPendingCalls + 1);
        if (wasIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeBusy();
            }
        }
    }

    private void decrementPendingJSCalls() {
        int newPendingCalls = this.mPendingJSCalls.decrementAndGet();
        boolean isNowIdle = newPendingCalls == 0;
        com.facebook.systrace.Systrace.traceCounter(0L, this.mJsPendingCallsTitleForTrace, newPendingCalls);
        if (isNowIdle && !this.mBridgeIdleListeners.isEmpty()) {
            for (NotThreadSafeBridgeIdleDebugListener listener : this.mBridgeIdleListeners) {
                listener.onTransitionToBridgeIdle();
            }
        }
    }

    private void onNativeException(Exception e) {
        this.mNativeModuleCallExceptionHandler.handleException(e);
        this.mReactQueueConfiguration.getUIQueueThread().runOnQueue(new Runnable(){

            @Override
            public void run() {
                CatalystInstanceImpl.this.destroy();
            }
        });
    }

    static {
        SoLoader.loadLibrary((String)REACT_NATIVE_LIB);
        sNextInstanceIdForTrace = new AtomicInteger(1);
    }

    public static class Builder {
        @Nullable
        private ReactQueueConfigurationSpec mReactQueueConfigurationSpec;
        @Nullable
        private JSBundleLoader mJSBundleLoader;
        @Nullable
        private NativeModuleRegistry mRegistry;
        @Nullable
        private JavaScriptModuleRegistry mJSModuleRegistry;
        @Nullable
        private JavaScriptExecutor mJSExecutor;
        @Nullable
        private NativeModuleCallExceptionHandler mNativeModuleCallExceptionHandler;

        public Builder setReactQueueConfigurationSpec(ReactQueueConfigurationSpec ReactQueueConfigurationSpec2) {
            this.mReactQueueConfigurationSpec = ReactQueueConfigurationSpec2;
            return this;
        }

        public Builder setRegistry(NativeModuleRegistry registry) {
            this.mRegistry = registry;
            return this;
        }

        public Builder setJSModuleRegistry(JavaScriptModuleRegistry jsModuleRegistry) {
            this.mJSModuleRegistry = jsModuleRegistry;
            return this;
        }

        public Builder setJSBundleLoader(JSBundleLoader jsBundleLoader) {
            this.mJSBundleLoader = jsBundleLoader;
            return this;
        }

        public Builder setJSExecutor(JavaScriptExecutor jsExecutor) {
            this.mJSExecutor = jsExecutor;
            return this;
        }

        public Builder setNativeModuleCallExceptionHandler(NativeModuleCallExceptionHandler handler) {
            this.mNativeModuleCallExceptionHandler = handler;
            return this;
        }

        public CatalystInstanceImpl build() {
            return new CatalystInstanceImpl((ReactQueueConfigurationSpec)Assertions.assertNotNull((Object)this.mReactQueueConfigurationSpec), (JavaScriptExecutor)Assertions.assertNotNull((Object)this.mJSExecutor), (NativeModuleRegistry)Assertions.assertNotNull((Object)this.mRegistry), (JavaScriptModuleRegistry)Assertions.assertNotNull((Object)this.mJSModuleRegistry), (JSBundleLoader)Assertions.assertNotNull((Object)this.mJSBundleLoader), (NativeModuleCallExceptionHandler)Assertions.assertNotNull((Object)this.mNativeModuleCallExceptionHandler));
        }
    }

    private static class JSProfilerTraceListener
    implements TraceListener {
        private final WeakReference<CatalystInstanceImpl> mOuter;

        public JSProfilerTraceListener(CatalystInstanceImpl outer) {
            this.mOuter = new WeakReference<CatalystInstanceImpl>(outer);
        }

        @Override
        public void onTraceStarted() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.getJSModule(Systrace.class).setEnabled(true);
            }
        }

        @Override
        public void onTraceStopped() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.getJSModule(Systrace.class).setEnabled(false);
            }
        }
    }

    private class NativeExceptionHandler
    implements QueueThreadExceptionHandler {
        private NativeExceptionHandler() {
        }

        @Override
        public void handleException(Exception e) {
            CatalystInstanceImpl.this.onNativeException(e);
        }
    }

    private static class BridgeCallback
    implements ReactCallback {
        private final WeakReference<CatalystInstanceImpl> mOuter;

        public BridgeCallback(CatalystInstanceImpl outer) {
            this.mOuter = new WeakReference<CatalystInstanceImpl>(outer);
        }

        @Override
        public void onBatchComplete() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.mJavaRegistry.onBatchComplete();
            }
        }

        @Override
        public void incrementPendingJSCalls() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.incrementPendingJSCalls();
            }
        }

        @Override
        public void decrementPendingJSCalls() {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.decrementPendingJSCalls();
            }
        }

        @Override
        public void onNativeException(Exception e) {
            CatalystInstanceImpl impl = (CatalystInstanceImpl)this.mOuter.get();
            if (impl != null) {
                impl.onNativeException(e);
            }
        }
    }
}

