/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import android.content.Context;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;
import com.facebook.react.cxxbridge.UnpackingJSBundleLoader;
import com.facebook.react.devsupport.DebugServerException;
import java.io.File;

public abstract class JSBundleLoader {
    public static JSBundleLoader createFileLoader(final Context context, final String fileName) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(CatalystInstanceImpl instance) {
                if (fileName.startsWith("assets://")) {
                    instance.loadScriptFromAssets(context.getAssets(), fileName);
                } else {
                    instance.loadScriptFromFile(fileName, fileName);
                }
            }

            @Override
            public String getSourceUrl() {
                return fileName;
            }
        };
    }

    public static JSBundleLoader createCachedBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(CatalystInstanceImpl instance) {
                try {
                    instance.loadScriptFromFile(cachedFileLocation, sourceURL);
                }
                catch (Exception e) {
                    throw DebugServerException.makeGeneric(e.getMessage(), e);
                }
            }

            @Override
            public String getSourceUrl() {
                return sourceURL;
            }
        };
    }

    public static JSBundleLoader createRemoteDebuggerBundleLoader(final String proxySourceURL, final String realSourceURL) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(CatalystInstanceImpl instance) {
                instance.loadScriptFromFile(null, proxySourceURL);
            }

            @Override
            public String getSourceUrl() {
                return realSourceURL;
            }
        };
    }

    public static JSBundleLoader createUnpackingBundleLoader(Context context, String sourceURL, String bundleName) {
        return UnpackingJSBundleLoader.newBuilder().setContext(context).setSourceURL(sourceURL).setDestinationPath(new File(context.getFilesDir(), "optimized-bundle")).checkAndUnpackFile(bundleName + ".meta", "bundle.meta").unpackFile(bundleName, "bundle.js").build();
    }

    public abstract void loadScript(CatalystInstanceImpl var1);

    public abstract String getSourceUrl();
}

