/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.BaseJavaModule;
import com.facebook.react.bridge.NativeModule;
import com.facebook.react.bridge.OnBatchCompleteListener;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;
import com.facebook.react.cxxbridge.CxxModuleWrapper;
import com.facebook.react.cxxbridge.JavaModuleWrapper;
import com.facebook.react.cxxbridge.ModuleRegistryHolder;
import com.facebook.react.cxxbridge.ReactMarker;
import com.facebook.react.cxxbridge.UiThreadUtil;
import com.facebook.systrace.Systrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class NativeModuleRegistry {
    private final Map<Class<NativeModule>, NativeModule> mModuleInstances;
    private final ArrayList<OnBatchCompleteListener> mBatchCompleteListenerModules;

    private NativeModuleRegistry(Map<Class<NativeModule>, NativeModule> moduleInstances) {
        this.mModuleInstances = moduleInstances;
        this.mBatchCompleteListenerModules = new ArrayList(this.mModuleInstances.size());
        for (NativeModule module : this.mModuleInstances.values()) {
            if (!(module instanceof OnBatchCompleteListener)) continue;
            this.mBatchCompleteListenerModules.add((OnBatchCompleteListener)((Object)module));
        }
    }

    ModuleRegistryHolder getModuleRegistryHolder(CatalystInstanceImpl catalystInstanceImpl) {
        ArrayList<JavaModuleWrapper> javaModules = new ArrayList<JavaModuleWrapper>();
        ArrayList<CxxModuleWrapper> cxxModules = new ArrayList<CxxModuleWrapper>();
        for (NativeModule module : this.mModuleInstances.values()) {
            if (module instanceof BaseJavaModule) {
                javaModules.add(new JavaModuleWrapper(catalystInstanceImpl, (BaseJavaModule)module));
                continue;
            }
            if (module instanceof CxxModuleWrapper) {
                cxxModules.add((CxxModuleWrapper)module);
                continue;
            }
            throw new IllegalArgumentException("Unknown module type " + module.getClass());
        }
        return new ModuleRegistryHolder(catalystInstanceImpl, javaModules, cxxModules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCatalystInstanceDestroy() {
        UiThreadUtil.assertOnUiThread();
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceDestroy");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.onCatalystInstanceDestroy();
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyCatalystInstanceInitialized() {
        UiThreadUtil.assertOnUiThread();
        ReactMarker.logMarker("NativeModule_start");
        Systrace.beginSection(0L, "NativeModuleRegistry_notifyCatalystInstanceInitialized");
        try {
            for (NativeModule nativeModule : this.mModuleInstances.values()) {
                nativeModule.initialize();
            }
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker("NativeModule_end");
        }
    }

    public void onBatchComplete() {
        for (int i = 0; i < this.mBatchCompleteListenerModules.size(); ++i) {
            this.mBatchCompleteListenerModules.get(i).onBatchComplete();
        }
    }

    public <T extends NativeModule> boolean hasModule(Class<T> moduleInterface) {
        return this.mModuleInstances.containsKey(moduleInterface);
    }

    public <T extends NativeModule> T getModule(Class<T> moduleInterface) {
        return (T)((NativeModule)Assertions.assertNotNull((Object)this.mModuleInstances.get(moduleInterface)));
    }

    public Collection<NativeModule> getAllModules() {
        return this.mModuleInstances.values();
    }

    public static class Builder {
        private final HashMap<String, NativeModule> mModules = MapBuilder.newHashMap();

        public Builder add(NativeModule module) {
            NativeModule existing = this.mModules.get(module.getName());
            if (existing != null && !module.canOverrideExistingModule()) {
                throw new IllegalStateException("Native module " + module.getClass().getSimpleName() + " tried to override " + existing.getClass().getSimpleName() + " for module name " + module.getName() + ". If this was your intention, return true from " + module.getClass().getSimpleName() + "#canOverrideExistingModule()");
            }
            this.mModules.put(module.getName(), module);
            return this;
        }

        public NativeModuleRegistry build() {
            HashMap moduleInstances = new HashMap();
            for (NativeModule module : this.mModules.values()) {
                moduleInstances.put(module.getClass(), module);
            }
            return new NativeModuleRegistry(moduleInstances);
        }
    }
}

