/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import android.content.Context;
import android.content.res.AssetManager;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;
import com.facebook.react.cxxbridge.JSBundleLoader;
import com.facebook.soloader.FileLocker;
import com.facebook.soloader.SysUtil;
import com.facebook.systrace.Systrace;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;

public class UnpackingJSBundleLoader
extends JSBundleLoader {
    static final int UNPACKED_JS_SOURCE = 1;
    static final String LOCK_FILE = "unpacking-bundle-loader.lock";
    static final String DOT_UNPACKED_FILE = ".unpacked";
    private static final int IO_BUFFER_SIZE = 16384;
    private final File mDirectoryPath;
    private final String mSourceURL;
    private final Context mContext;
    private final Unpacker[] mUnpackers;

    UnpackingJSBundleLoader(Builder builder) {
        this.mContext = (Context)Assertions.assertNotNull((Object)builder.context);
        this.mDirectoryPath = (File)Assertions.assertNotNull((Object)builder.destinationPath);
        this.mSourceURL = (String)Assertions.assertNotNull((Object)builder.sourceURL);
        this.mUnpackers = builder.unpackers.toArray(new Unpacker[builder.unpackers.size()]);
    }

    void prepare() {
        File lockFilePath = new File(this.mContext.getFilesDir(), LOCK_FILE);
        Systrace.beginSection(0L, "UnpackingJSBundleLoader.prepare");
        try (FileLocker lock = FileLocker.lock((File)lockFilePath);){
            this.prepareLocked();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareLocked() throws IOException {
        File dotFinishedFilePath = new File(this.mDirectoryPath, DOT_UNPACKED_FILE);
        boolean shouldReconstruct = !this.mDirectoryPath.exists() || !dotFinishedFilePath.exists();
        byte[] buffer = new byte[16384];
        for (int i = 0; i < this.mUnpackers.length && !shouldReconstruct; ++i) {
            shouldReconstruct = this.mUnpackers[i].shouldReconstructDir(this.mContext, buffer);
        }
        if (!shouldReconstruct) {
            return;
        }
        boolean succeeded = false;
        try {
            SysUtil.dumbDeleteRecursive((File)this.mDirectoryPath);
            if (!this.mDirectoryPath.mkdirs()) {
                throw new IOException("Coult not create the destination directory");
            }
            for (Unpacker unpacker : this.mUnpackers) {
                unpacker.unpack(this.mContext, buffer);
            }
            if (!dotFinishedFilePath.createNewFile()) {
                throw new IOException("Could not create .unpacked file");
            }
            succeeded = true;
        }
        finally {
            if (!succeeded) {
                SysUtil.dumbDeleteRecursive((File)this.mDirectoryPath);
            }
        }
    }

    @Override
    public void loadScript(CatalystInstanceImpl instance) {
        this.prepare();
        instance.loadScriptFromOptimizedBundle(this.mDirectoryPath.getPath(), this.mSourceURL, 1);
    }

    @Override
    public String getSourceUrl() {
        return this.mSourceURL;
    }

    static void fsync(File path) throws IOException {
        try (RandomAccessFile file = new RandomAccessFile(path, "r");){
            file.getFD().sync();
        }
    }

    static byte[] readBytes(InputStream is, byte[] ioBuffer, int maxSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        UnpackingJSBundleLoader.copyBytes(baos, is, ioBuffer, maxSize);
        return baos.toByteArray();
    }

    static int copyBytes(OutputStream os, InputStream is, byte[] ioBuffer, int maxSize) throws IOException {
        int totalSize;
        int rc;
        for (totalSize = 0; totalSize < maxSize && (rc = is.read(ioBuffer, 0, Math.min(maxSize - totalSize, ioBuffer.length))) != -1; totalSize += rc) {
            os.write(ioBuffer, 0, rc);
        }
        return totalSize;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static class ContentCheckingUnpacker
    extends Unpacker {
        public ContentCheckingUnpacker(String nameInApk, String fileName) {
            super(nameInApk, fileName);
        }

        @Override
        public boolean shouldReconstructDir(Context context, byte[] ioBuffer) throws IOException {
            byte[] fileContent;
            byte[] assetContent;
            if (!((File)Assertions.assertNotNull((Object)this.mDestinationFilePath)).exists()) {
                return true;
            }
            AssetManager am = context.getAssets();
            try (InputStream assetStream = am.open(this.mNameInApk, 2);){
                assetContent = UnpackingJSBundleLoader.readBytes(assetStream, ioBuffer, Integer.MAX_VALUE);
            }
            try (FileInputStream fileStream = new FileInputStream((File)Assertions.assertNotNull((Object)this.mDestinationFilePath));){
                fileContent = UnpackingJSBundleLoader.readBytes(fileStream, ioBuffer, assetContent.length + 1);
            }
            return !Arrays.equals(assetContent, fileContent);
        }
    }

    static class ExistenceCheckingUnpacker
    extends Unpacker {
        public ExistenceCheckingUnpacker(String nameInApk, String fileName) {
            super(nameInApk, fileName);
        }

        @Override
        public boolean shouldReconstructDir(Context context, byte[] ioBuffer) {
            return !((File)Assertions.assertNotNull((Object)this.mDestinationFilePath)).exists();
        }

        @Override
        public void unpack(Context context, byte[] ioBuffer) throws IOException {
            super.unpack(context, ioBuffer);
            UnpackingJSBundleLoader.fsync((File)Assertions.assertNotNull((Object)this.mDestinationFilePath));
        }
    }

    static abstract class Unpacker {
        protected final String mNameInApk;
        private final String mFileName;
        @Nullable
        protected File mDestinationFilePath;

        public Unpacker(String nameInApk, String fileName) {
            this.mNameInApk = nameInApk;
            this.mFileName = fileName;
        }

        public void setDestinationDirectory(File destinationDirectoryPath) {
            this.mDestinationFilePath = new File(destinationDirectoryPath, this.mFileName);
        }

        public abstract boolean shouldReconstructDir(Context var1, byte[] var2) throws IOException;

        public void unpack(Context context, byte[] ioBuffer) throws IOException {
            AssetManager am = context.getAssets();
            try (InputStream is = am.open(this.mNameInApk, 2);
                 FileOutputStream fileOutputStream = new FileOutputStream((File)Assertions.assertNotNull((Object)this.mDestinationFilePath));){
                UnpackingJSBundleLoader.copyBytes(fileOutputStream, is, ioBuffer, Integer.MAX_VALUE);
            }
        }
    }

    public static class Builder {
        @Nullable
        private Context context = null;
        @Nullable
        private File destinationPath = null;
        @Nullable
        private String sourceURL = null;
        private final ArrayList<Unpacker> unpackers = new ArrayList();

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setDestinationPath(File destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        public Builder setSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return this;
        }

        public Builder unpackFile(String nameInApk, String destFileName) {
            this.unpackers.add(new ExistenceCheckingUnpacker(nameInApk, destFileName));
            return this;
        }

        public Builder checkAndUnpackFile(String nameInApk, String destFileName) {
            this.unpackers.add(new ContentCheckingUnpacker(nameInApk, destFileName));
            return this;
        }

        Builder addUnpacker(Unpacker u) {
            this.unpackers.add(u);
            return this;
        }

        public UnpackingJSBundleLoader build() {
            Assertions.assertNotNull((Object)this.destinationPath);
            for (int i = 0; i < this.unpackers.size(); ++i) {
                this.unpackers.get(i).setDestinationDirectory(this.destinationPath);
            }
            return new UnpackingJSBundleLoader(this);
        }
    }
}

