/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.DisabledDevSupportManager;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.devsupport.RedBoxHandler;
import java.lang.reflect.Constructor;
import javax.annotation.Nullable;

public class DevSupportManagerFactory {
    private static final String DEVSUPPORT_IMPL_PACKAGE = "com.facebook.react.devsupport";
    private static final String DEVSUPPORT_IMPL_CLASS = "DevSupportManagerImpl";

    public static DevSupportManager create(Context applicationContext, ReactInstanceDevCommandsHandler reactInstanceCommandsHandler, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate) {
        return DevSupportManagerFactory.create(applicationContext, reactInstanceCommandsHandler, packagerPathForJSBundleName, enableOnCreate, null);
    }

    public static DevSupportManager create(Context applicationContext, ReactInstanceDevCommandsHandler reactInstanceCommandsHandler, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler) {
        if (!enableOnCreate) {
            return new DisabledDevSupportManager();
        }
        try {
            String className = DEVSUPPORT_IMPL_PACKAGE + "." + DEVSUPPORT_IMPL_CLASS;
            Class<?> devSupportManagerClass = Class.forName(className);
            Constructor<?> constructor = devSupportManagerClass.getConstructor(Context.class, ReactInstanceDevCommandsHandler.class, String.class, Boolean.TYPE, RedBoxHandler.class);
            return (DevSupportManager)constructor.newInstance(applicationContext, reactInstanceCommandsHandler, packagerPathForJSBundleName, true, redBoxHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Requested enabled DevSupportManager, but DevSupportManagerImpl class was not found or could not be created", e);
        }
    }
}

