/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import com.facebook.react.bridge.JavaScriptModule;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import java.io.File;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class JSCHeapCapture
extends ReactContextBaseJavaModule {
    @Nullable
    private HeapCapture mHeapCapture = null;
    private boolean mOperationInProgress = false;
    private int mOperationToken = 0;
    @Nullable
    private String mOperationError = null;
    private static final HashSet<JSCHeapCapture> sRegisteredDumpers = new HashSet();

    private static synchronized void registerHeapCapture(JSCHeapCapture dumper) {
        if (sRegisteredDumpers.contains(dumper)) {
            throw new RuntimeException("a JSCHeapCapture registered more than once");
        }
        sRegisteredDumpers.add(dumper);
    }

    private static synchronized void unregisterHeapCapture(JSCHeapCapture dumper) {
        sRegisteredDumpers.remove(dumper);
    }

    public static synchronized List<String> captureHeap(String path, long timeout) throws CaptureException {
        LinkedList<String> captureFiles = new LinkedList<String>();
        if (sRegisteredDumpers.isEmpty()) {
            throw new CaptureException("No JSC registered");
        }
        int disambiguate = 0;
        File f = new File(path + "/capture" + Integer.toString(disambiguate) + ".json");
        while (f.delete()) {
            f = new File(path + "/capture" + Integer.toString(++disambiguate) + ".json");
        }
        disambiguate = 0;
        for (JSCHeapCapture dumper : sRegisteredDumpers) {
            String file = path + "/capture" + Integer.toString(disambiguate) + ".json";
            dumper.captureHeapHelper(file, timeout);
            captureFiles.add(file);
        }
        return captureFiles;
    }

    public JSCHeapCapture(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    private synchronized void captureHeapHelper(String path, long timeout) throws CaptureException {
        if (this.mHeapCapture == null) {
            throw new CaptureException("HeapCapture.js module not connected");
        }
        this.mHeapCapture.captureHeap(this.getOperationToken(), path);
        this.waitForOperation(timeout);
    }

    private int getOperationToken() throws CaptureException {
        if (this.mOperationInProgress) {
            throw new CaptureException("Another operation already in progress.");
        }
        this.mOperationInProgress = true;
        return ++this.mOperationToken;
    }

    private void waitForOperation(long timeout) throws CaptureException {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            throw new CaptureException("Waiting for heap capture failed: " + e.getMessage());
        }
        if (this.mOperationInProgress) {
            this.mOperationInProgress = false;
            throw new CaptureException("heap capture timed out.");
        }
        if (this.mOperationError != null) {
            throw new CaptureException(this.mOperationError);
        }
    }

    @ReactMethod
    public synchronized void operationComplete(int token, String error) {
        if (token != this.mOperationToken) {
            throw new RuntimeException("Completed operation is not in progress.");
        }
        this.mOperationInProgress = false;
        this.mOperationError = error;
        this.notify();
    }

    @Override
    public String getName() {
        return "JSCHeapCapture";
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mHeapCapture = this.getReactApplicationContext().getJSModule(HeapCapture.class);
        JSCHeapCapture.registerHeapCapture(this);
    }

    @Override
    public void onCatalystInstanceDestroy() {
        super.onCatalystInstanceDestroy();
        JSCHeapCapture.unregisterHeapCapture(this);
        this.mHeapCapture = null;
    }

    public static class CaptureException
    extends Exception {
        CaptureException(String message) {
            super(message);
        }
    }

    public static interface HeapCapture
    extends JavaScriptModule {
        public void captureHeap(int var1, String var2);

        public void setAllocationTracking(int var1, boolean var2);
    }
}

