/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Dialog;
import android.content.Context;
import android.net.Uri;
import android.os.AsyncTask;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.DoubleTapReloadRecognizer;
import com.facebook.react.devsupport.StackTraceHelper;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.json.JSONObject;

class RedBoxDialog
extends Dialog
implements AdapterView.OnItemClickListener {
    private final DevSupportManager mDevSupportManager;
    private final DoubleTapReloadRecognizer mDoubleTapReloadRecognizer;
    private ListView mStackView;
    private Button mReloadJs;
    private Button mDismiss;
    private Button mCopyToClipboard;

    protected RedBoxDialog(Context context, DevSupportManager devSupportManager) {
        super(context, R.style.Theme_Catalyst_RedBox);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.redbox_view);
        this.mDevSupportManager = devSupportManager;
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
        this.mStackView = (ListView)this.findViewById(R.id.rn_redbox_stack);
        this.mStackView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mReloadJs = (Button)this.findViewById(R.id.rn_redbox_reload_button);
        this.mReloadJs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RedBoxDialog.this.mDevSupportManager.handleReloadJS();
            }
        });
        this.mDismiss = (Button)this.findViewById(R.id.rn_redbox_dismiss_button);
        this.mDismiss.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RedBoxDialog.this.dismiss();
            }
        });
        this.mCopyToClipboard = (Button)this.findViewById(R.id.rn_redbox_copy_button);
        this.mCopyToClipboard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String title = RedBoxDialog.this.mDevSupportManager.getLastErrorTitle();
                StackTraceHelper.StackFrame[] stack = RedBoxDialog.this.mDevSupportManager.getLastErrorStack();
                Assertions.assertNotNull((Object)title);
                Assertions.assertNotNull((Object)stack);
                new CopyToHostClipBoardTask(RedBoxDialog.this.mDevSupportManager).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[]{StackTraceHelper.formatStackTrace(title, stack)});
            }
        });
    }

    public void setExceptionDetails(String title, StackTraceHelper.StackFrame[] stack) {
        this.mStackView.setAdapter((ListAdapter)new StackAdapter(title, stack));
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        new OpenStackFrameTask(this.mDevSupportManager).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new StackTraceHelper.StackFrame[]{(StackTraceHelper.StackFrame)this.mStackView.getAdapter().getItem(position)});
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82) {
            this.mDevSupportManager.showDevOptionsDialog();
            return true;
        }
        if (this.mDoubleTapReloadRecognizer.didDoubleTapR(keyCode, this.getCurrentFocus())) {
            this.mDevSupportManager.handleReloadJS();
        }
        return super.onKeyUp(keyCode, event);
    }

    private static class CopyToHostClipBoardTask
    extends AsyncTask<String, Void, Void> {
        private final DevSupportManager mDevSupportManager;

        private CopyToHostClipBoardTask(DevSupportManager devSupportManager) {
            this.mDevSupportManager = devSupportManager;
        }

        protected Void doInBackground(String ... clipBoardString) {
            try {
                String sendClipBoardUrl = Uri.parse((String)this.mDevSupportManager.getSourceUrl()).buildUpon().path("/copy-to-clipboard").query(null).build().toString();
                for (String string2 : clipBoardString) {
                    OkHttpClient client = new OkHttpClient();
                    RequestBody body = RequestBody.create(null, (String)string2);
                    Request request = new Request.Builder().url(sendClipBoardUrl).post(body).build();
                    client.newCall(request).execute();
                }
            }
            catch (Exception e) {
                FLog.e((String)"React", (String)"Could not copy to the host clipboard", (Throwable)e);
            }
            return null;
        }
    }

    private static class OpenStackFrameTask
    extends AsyncTask<StackTraceHelper.StackFrame, Void, Void> {
        private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
        private final DevSupportManager mDevSupportManager;

        private OpenStackFrameTask(DevSupportManager devSupportManager) {
            this.mDevSupportManager = devSupportManager;
        }

        protected Void doInBackground(StackTraceHelper.StackFrame ... stackFrames) {
            try {
                String openStackFrameUrl = Uri.parse((String)this.mDevSupportManager.getSourceUrl()).buildUpon().path("/open-stack-frame").query(null).build().toString();
                OkHttpClient client = new OkHttpClient();
                for (StackTraceHelper.StackFrame frame : stackFrames) {
                    String payload = OpenStackFrameTask.stackFrameToJson(frame).toString();
                    RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
                    Request request = new Request.Builder().url(openStackFrameUrl).post(body).build();
                    client.newCall(request).execute();
                }
            }
            catch (Exception e) {
                FLog.e((String)"React", (String)"Could not open stack frame", (Throwable)e);
            }
            return null;
        }

        private static JSONObject stackFrameToJson(StackTraceHelper.StackFrame frame) {
            return new JSONObject(MapBuilder.of("file", frame.getFile(), "methodName", frame.getMethod(), "lineNumber", frame.getLine(), "column", frame.getColumn()));
        }
    }

    private static class StackAdapter
    extends BaseAdapter {
        private static final int VIEW_TYPE_COUNT = 2;
        private static final int VIEW_TYPE_TITLE = 0;
        private static final int VIEW_TYPE_STACKFRAME = 1;
        private final String mTitle;
        private final StackTraceHelper.StackFrame[] mStack;

        public StackAdapter(String title, StackTraceHelper.StackFrame[] stack) {
            this.mTitle = title;
            this.mStack = stack;
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return position > 0;
        }

        public int getCount() {
            return this.mStack.length + 1;
        }

        public Object getItem(int position) {
            return position == 0 ? this.mTitle : this.mStack[position - 1];
        }

        public long getItemId(int position) {
            return position;
        }

        public int getViewTypeCount() {
            return 2;
        }

        public int getItemViewType(int position) {
            return position == 0 ? 0 : 1;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (position == 0) {
                TextView title = convertView != null ? (TextView)convertView : (TextView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.redbox_item_title, parent, false);
                title.setText((CharSequence)this.mTitle);
                return title;
            }
            if (convertView == null) {
                convertView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.redbox_item_frame, parent, false);
                convertView.setTag((Object)new FrameViewHolder(convertView));
            }
            StackTraceHelper.StackFrame frame = this.mStack[position - 1];
            FrameViewHolder holder = (FrameViewHolder)convertView.getTag();
            holder.mMethodView.setText((CharSequence)frame.getMethod());
            holder.mFileView.setText((CharSequence)StackTraceHelper.formatFrameSource(frame));
            return convertView;
        }

        private static class FrameViewHolder {
            private final TextView mMethodView;
            private final TextView mFileView;

            private FrameViewHolder(View v) {
                this.mMethodView = (TextView)v.findViewById(R.id.rn_frame_method);
                this.mFileView = (TextView)v.findViewById(R.id.rn_frame_file);
            }
        }
    }
}

