/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.i18nmanager;

import android.content.Context;
import android.content.SharedPreferences;

public class I18nUtil {
    private static I18nUtil sharedI18nUtilInstance = null;
    private static final String MY_PREFS_NAME = "com.facebook.react.modules.i18nmanager.I18nUtil";
    private static final String KEY_FOR_PREFS = "RCTI18nUtil_allowRTL";

    private I18nUtil() {
    }

    public static I18nUtil getInstance() {
        if (sharedI18nUtilInstance == null) {
            sharedI18nUtilInstance = new I18nUtil();
        }
        return sharedI18nUtilInstance;
    }

    public boolean isRTL(Context context) {
        return this.allowRTL(context);
    }

    private boolean allowRTL(Context context) {
        SharedPreferences prefs = context.getSharedPreferences(MY_PREFS_NAME, 0);
        return prefs.getBoolean(KEY_FOR_PREFS, false);
    }

    public void setAllowRTL(Context context, boolean allowRTL) {
        SharedPreferences.Editor editor = context.getSharedPreferences(MY_PREFS_NAME, 0).edit();
        editor.putBoolean(KEY_FOR_PREFS, allowRTL);
        editor.apply();
    }
}

