/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import com.facebook.infer.annotation.Assertions;

public class MatrixMathHelper {
    private static final double EPSILON = 1.0E-5;

    private static boolean isZero(double d) {
        if (Double.isNaN(d)) {
            return false;
        }
        return Math.abs(d) < 1.0E-5;
    }

    public static void decomposeMatrix(double[] transformMatrix, MatrixDecompositionContext ctx) {
        Assertions.assertCondition((transformMatrix.length == 16 ? 1 : 0) != 0);
        double[] perspective = ctx.perspective;
        double[] quaternion = ctx.quaternion;
        double[] scale = ctx.scale;
        double[] skew = ctx.skew;
        double[] translation = ctx.translation;
        double[] rotationDegrees = ctx.rotationDegrees;
        if (MatrixMathHelper.isZero(transformMatrix[15])) {
            return;
        }
        double[][] matrix = new double[4][4];
        double[] perspectiveMatrix = new double[16];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                double value;
                matrix[i][j] = value = transformMatrix[i * 4 + j] / transformMatrix[15];
                perspectiveMatrix[i * 4 + j] = j == 3 ? 0.0 : value;
            }
        }
        perspectiveMatrix[15] = 1.0;
        if (MatrixMathHelper.isZero(MatrixMathHelper.determinant(perspectiveMatrix))) {
            return;
        }
        if (!(MatrixMathHelper.isZero(matrix[0][3]) && MatrixMathHelper.isZero(matrix[1][3]) && MatrixMathHelper.isZero(matrix[2][3]))) {
            double[] rightHandSide = new double[]{matrix[0][3], matrix[1][3], matrix[2][3], matrix[3][3]};
            double[] inversePerspectiveMatrix = MatrixMathHelper.inverse(perspectiveMatrix);
            double[] transposedInversePerspectiveMatrix = MatrixMathHelper.transpose(inversePerspectiveMatrix);
            MatrixMathHelper.multiplyVectorByMatrix(rightHandSide, transposedInversePerspectiveMatrix, perspective);
        } else {
            perspective[2] = 0.0;
            perspective[1] = 0.0;
            perspective[0] = 0.0;
            perspective[3] = 1.0;
        }
        for (int i = 0; i < 3; ++i) {
            translation[i] = matrix[3][i];
        }
        double[][] row = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            row[i][0] = matrix[i][0];
            row[i][1] = matrix[i][1];
            row[i][2] = matrix[i][2];
        }
        scale[0] = MatrixMathHelper.v3Length(row[0]);
        row[0] = MatrixMathHelper.v3Normalize(row[0], scale[0]);
        skew[0] = MatrixMathHelper.v3Dot(row[0], row[1]);
        row[1] = MatrixMathHelper.v3Combine(row[1], row[0], 1.0, -skew[0]);
        skew[0] = MatrixMathHelper.v3Dot(row[0], row[1]);
        row[1] = MatrixMathHelper.v3Combine(row[1], row[0], 1.0, -skew[0]);
        scale[1] = MatrixMathHelper.v3Length(row[1]);
        row[1] = MatrixMathHelper.v3Normalize(row[1], scale[1]);
        skew[0] = skew[0] / scale[1];
        skew[1] = MatrixMathHelper.v3Dot(row[0], row[2]);
        row[2] = MatrixMathHelper.v3Combine(row[2], row[0], 1.0, -skew[1]);
        skew[2] = MatrixMathHelper.v3Dot(row[1], row[2]);
        row[2] = MatrixMathHelper.v3Combine(row[2], row[1], 1.0, -skew[2]);
        scale[2] = MatrixMathHelper.v3Length(row[2]);
        row[2] = MatrixMathHelper.v3Normalize(row[2], scale[2]);
        skew[1] = skew[1] / scale[2];
        skew[2] = skew[2] / scale[2];
        double[] pdum3 = MatrixMathHelper.v3Cross(row[1], row[2]);
        if (MatrixMathHelper.v3Dot(row[0], pdum3) < 0.0) {
            for (int i = 0; i < 3; ++i) {
                int n = i;
                scale[n] = scale[n] * -1.0;
                double[] dArray = row[i];
                dArray[0] = dArray[0] * -1.0;
                double[] dArray2 = row[i];
                dArray2[1] = dArray2[1] * -1.0;
                double[] dArray3 = row[i];
                dArray3[2] = dArray3[2] * -1.0;
            }
        }
        quaternion[0] = 0.5 * Math.sqrt(Math.max(1.0 + row[0][0] - row[1][1] - row[2][2], 0.0));
        quaternion[1] = 0.5 * Math.sqrt(Math.max(1.0 - row[0][0] + row[1][1] - row[2][2], 0.0));
        quaternion[2] = 0.5 * Math.sqrt(Math.max(1.0 - row[0][0] - row[1][1] + row[2][2], 0.0));
        quaternion[3] = 0.5 * Math.sqrt(Math.max(1.0 + row[0][0] + row[1][1] + row[2][2], 0.0));
        if (row[2][1] > row[1][2]) {
            quaternion[0] = -quaternion[0];
        }
        if (row[0][2] > row[2][0]) {
            quaternion[1] = -quaternion[1];
        }
        if (row[1][0] > row[0][1]) {
            quaternion[2] = -quaternion[2];
        }
        if (quaternion[0] < 0.001 && quaternion[0] >= 0.0 && quaternion[1] < 0.001 && quaternion[1] >= 0.0) {
            rotationDegrees[1] = 0.0;
            rotationDegrees[0] = 0.0;
            rotationDegrees[2] = MatrixMathHelper.roundTo3Places(Math.atan2(row[0][1], row[0][0]) * 180.0 / Math.PI);
        } else {
            MatrixMathHelper.quaternionToDegreesXYZ(quaternion, rotationDegrees);
        }
    }

    public static double determinant(double[] matrix) {
        double m00 = matrix[0];
        double m01 = matrix[1];
        double m02 = matrix[2];
        double m03 = matrix[3];
        double m10 = matrix[4];
        double m11 = matrix[5];
        double m12 = matrix[6];
        double m13 = matrix[7];
        double m20 = matrix[8];
        double m21 = matrix[9];
        double m22 = matrix[10];
        double m23 = matrix[11];
        double m30 = matrix[12];
        double m31 = matrix[13];
        double m32 = matrix[14];
        double m33 = matrix[15];
        return m03 * m12 * m21 * m30 - m02 * m13 * m21 * m30 - m03 * m11 * m22 * m30 + m01 * m13 * m22 * m30 + m02 * m11 * m23 * m30 - m01 * m12 * m23 * m30 - m03 * m12 * m20 * m31 + m02 * m13 * m20 * m31 + m03 * m10 * m22 * m31 - m00 * m13 * m22 * m31 - m02 * m10 * m23 * m31 + m00 * m12 * m23 * m31 + m03 * m11 * m20 * m32 - m01 * m13 * m20 * m32 - m03 * m10 * m21 * m32 + m00 * m13 * m21 * m32 + m01 * m10 * m23 * m32 - m00 * m11 * m23 * m32 - m02 * m11 * m20 * m33 + m01 * m12 * m20 * m33 + m02 * m10 * m21 * m33 - m00 * m12 * m21 * m33 - m01 * m10 * m22 * m33 + m00 * m11 * m22 * m33;
    }

    public static double[] inverse(double[] matrix) {
        double det = MatrixMathHelper.determinant(matrix);
        if (MatrixMathHelper.isZero(det)) {
            return matrix;
        }
        double m00 = matrix[0];
        double m01 = matrix[1];
        double m02 = matrix[2];
        double m03 = matrix[3];
        double m10 = matrix[4];
        double m11 = matrix[5];
        double m12 = matrix[6];
        double m13 = matrix[7];
        double m20 = matrix[8];
        double m21 = matrix[9];
        double m22 = matrix[10];
        double m23 = matrix[11];
        double m30 = matrix[12];
        double m31 = matrix[13];
        double m32 = matrix[14];
        double m33 = matrix[15];
        return new double[]{(m12 * m23 * m31 - m13 * m22 * m31 + m13 * m21 * m32 - m11 * m23 * m32 - m12 * m21 * m33 + m11 * m22 * m33) / det, (m03 * m22 * m31 - m02 * m23 * m31 - m03 * m21 * m32 + m01 * m23 * m32 + m02 * m21 * m33 - m01 * m22 * m33) / det, (m02 * m13 * m31 - m03 * m12 * m31 + m03 * m11 * m32 - m01 * m13 * m32 - m02 * m11 * m33 + m01 * m12 * m33) / det, (m03 * m12 * m21 - m02 * m13 * m21 - m03 * m11 * m22 + m01 * m13 * m22 + m02 * m11 * m23 - m01 * m12 * m23) / det, (m13 * m22 * m30 - m12 * m23 * m30 - m13 * m20 * m32 + m10 * m23 * m32 + m12 * m20 * m33 - m10 * m22 * m33) / det, (m02 * m23 * m30 - m03 * m22 * m30 + m03 * m20 * m32 - m00 * m23 * m32 - m02 * m20 * m33 + m00 * m22 * m33) / det, (m03 * m12 * m30 - m02 * m13 * m30 - m03 * m10 * m32 + m00 * m13 * m32 + m02 * m10 * m33 - m00 * m12 * m33) / det, (m02 * m13 * m20 - m03 * m12 * m20 + m03 * m10 * m22 - m00 * m13 * m22 - m02 * m10 * m23 + m00 * m12 * m23) / det, (m11 * m23 * m30 - m13 * m21 * m30 + m13 * m20 * m31 - m10 * m23 * m31 - m11 * m20 * m33 + m10 * m21 * m33) / det, (m03 * m21 * m30 - m01 * m23 * m30 - m03 * m20 * m31 + m00 * m23 * m31 + m01 * m20 * m33 - m00 * m21 * m33) / det, (m01 * m13 * m30 - m03 * m11 * m30 + m03 * m10 * m31 - m00 * m13 * m31 - m01 * m10 * m33 + m00 * m11 * m33) / det, (m03 * m11 * m20 - m01 * m13 * m20 - m03 * m10 * m21 + m00 * m13 * m21 + m01 * m10 * m23 - m00 * m11 * m23) / det, (m12 * m21 * m30 - m11 * m22 * m30 - m12 * m20 * m31 + m10 * m22 * m31 + m11 * m20 * m32 - m10 * m21 * m32) / det, (m01 * m22 * m30 - m02 * m21 * m30 + m02 * m20 * m31 - m00 * m22 * m31 - m01 * m20 * m32 + m00 * m21 * m32) / det, (m02 * m11 * m30 - m01 * m12 * m30 - m02 * m10 * m31 + m00 * m12 * m31 + m01 * m10 * m32 - m00 * m11 * m32) / det, (m01 * m12 * m20 - m02 * m11 * m20 + m02 * m10 * m21 - m00 * m12 * m21 - m01 * m10 * m22 + m00 * m11 * m22) / det};
    }

    public static double[] transpose(double[] m) {
        return new double[]{m[0], m[4], m[8], m[12], m[1], m[5], m[9], m[13], m[2], m[6], m[10], m[14], m[3], m[7], m[11], m[15]};
    }

    public static void multiplyVectorByMatrix(double[] v, double[] m, double[] result) {
        double vx = v[0];
        double vy = v[1];
        double vz = v[2];
        double vw = v[3];
        result[0] = vx * m[0] + vy * m[4] + vz * m[8] + vw * m[12];
        result[1] = vx * m[1] + vy * m[5] + vz * m[9] + vw * m[13];
        result[2] = vx * m[2] + vy * m[6] + vz * m[10] + vw * m[14];
        result[3] = vx * m[3] + vy * m[7] + vz * m[11] + vw * m[15];
    }

    public static double v3Length(double[] a) {
        return Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
    }

    public static double[] v3Normalize(double[] vector, double norm) {
        double im = 1.0 / (MatrixMathHelper.isZero(norm) ? MatrixMathHelper.v3Length(vector) : norm);
        return new double[]{vector[0] * im, vector[1] * im, vector[2] * im};
    }

    public static double v3Dot(double[] a, double[] b) {
        return a[0] * b[0] + a[1] * b[1] + a[2] * b[2];
    }

    public static double[] v3Combine(double[] a, double[] b, double aScale, double bScale) {
        return new double[]{aScale * a[0] + bScale * b[0], aScale * a[1] + bScale * b[1], aScale * a[2] + bScale * b[2]};
    }

    public static double[] v3Cross(double[] a, double[] b) {
        return new double[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
    }

    public static void quaternionToDegreesXYZ(double[] q, double[] result) {
        double qx = q[0];
        double qy = q[1];
        double qz = q[2];
        double qw = q[3];
        double qw2 = qw * qw;
        double qx2 = qx * qx;
        double qy2 = qy * qy;
        double qz2 = qz * qz;
        double test = qx * qy + qz * qw;
        double unit = qw2 + qx2 + qy2 + qz2;
        double conv = 57.29577951308232;
        if (test > 0.49999 * unit) {
            result[0] = 0.0;
            result[1] = 2.0 * Math.atan2(qx, qw) * conv;
            result[2] = 90.0;
            return;
        }
        if (test < -0.49999 * unit) {
            result[0] = 0.0;
            result[1] = -2.0 * Math.atan2(qx, qw) * conv;
            result[2] = -90.0;
            return;
        }
        result[0] = MatrixMathHelper.roundTo3Places(Math.atan2(2.0 * qx * qw - 2.0 * qy * qz, 1.0 - 2.0 * qx2 - 2.0 * qz2) * conv);
        result[1] = MatrixMathHelper.roundTo3Places(Math.atan2(2.0 * qy * qw - 2.0 * qx * qz, 1.0 - 2.0 * qy2 - 2.0 * qz2) * conv);
        result[2] = MatrixMathHelper.roundTo3Places(Math.asin(2.0 * qx * qy + 2.0 * qz * qw) * conv);
    }

    public static double roundTo3Places(double n) {
        return (double)Math.round(n * 1000.0) * 0.001;
    }

    public static class MatrixDecompositionContext {
        double[] perspective = new double[4];
        double[] quaternion = new double[4];
        double[] scale = new double[3];
        double[] skew = new double[3];
        double[] translation = new double[3];
        double[] rotationDegrees = new double[3];
    }
}

