/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.WeakHashMap;

public abstract class ViewGroupManager<T extends ViewGroup>
extends BaseViewManager<T, LayoutShadowNode> {
    public static WeakHashMap<View, Integer> mZIndexHash = new WeakHashMap();

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new LayoutShadowNode();
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return LayoutShadowNode.class;
    }

    @Override
    public void updateExtraData(T root, Object extraData) {
    }

    public void addView(T parent, View child, int index) {
        parent.addView(child, index);
        ViewGroupManager.reorderChildrenByZIndex(parent);
    }

    public static void setViewZIndex(View view, int zIndex) {
        mZIndexHash.put(view, zIndex);
        ViewGroup parent = (ViewGroup)view.getParent();
        if (parent != null) {
            ViewGroupManager.reorderChildrenByZIndex(parent);
        }
    }

    public static void reorderChildrenByZIndex(ViewGroup view) {
        int i;
        Collection<Integer> zIndexes = mZIndexHash.values();
        boolean containsZIndexedElement = false;
        for (Integer zIndex : zIndexes) {
            if (zIndex == 0) continue;
            containsZIndexedElement = true;
            break;
        }
        if (!containsZIndexedElement) {
            return;
        }
        ArrayList<View> viewsToSort = new ArrayList<View>();
        for (i = 0; i < view.getChildCount(); ++i) {
            viewsToSort.add(view.getChildAt(i));
        }
        Collections.sort(viewsToSort, new Comparator<View>(){

            @Override
            public int compare(View view1, View view2) {
                Integer view2ZIndex;
                Integer view1ZIndex = mZIndexHash.get(view1);
                if (view1ZIndex == null) {
                    view1ZIndex = 0;
                }
                if ((view2ZIndex = mZIndexHash.get(view2)) == null) {
                    view2ZIndex = 0;
                }
                return view1ZIndex - view2ZIndex;
            }
        });
        for (i = 0; i < viewsToSort.size(); ++i) {
            ((View)viewsToSort.get(i)).bringToFront();
        }
        view.invalidate();
    }

    public int getChildCount(T parent) {
        return parent.getChildCount();
    }

    public View getChildAt(T parent, int index) {
        return parent.getChildAt(index);
    }

    public void removeViewAt(T parent, int index) {
        parent.removeViewAt(index);
    }

    public void removeView(T parent, View view) {
        for (int i = 0; i < this.getChildCount(parent); ++i) {
            if (this.getChildAt(parent, i) != view) continue;
            this.removeViewAt(parent, i);
            break;
        }
    }

    public void removeAllViews(T parent) {
        for (int i = this.getChildCount(parent) - 1; i >= 0; --i) {
            this.removeViewAt(parent, i);
        }
    }

    public boolean needsCustomLayoutForChildren() {
        return false;
    }

    public boolean shouldPromoteGrandchildren() {
        return false;
    }
}

