/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.picker;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.SimpleViewManager;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.picker.ReactPicker;
import com.facebook.react.views.picker.events.PickerItemSelectEvent;
import javax.annotation.Nullable;

public abstract class ReactPickerManager
extends SimpleViewManager<ReactPicker> {
    @ReactProp(name="items")
    public void setItems(ReactPicker view, @Nullable ReadableArray items) {
        if (items != null) {
            ReadableMap[] data = new ReadableMap[items.size()];
            for (int i = 0; i < items.size(); ++i) {
                data[i] = items.getMap(i);
            }
            ReactPickerAdapter adapter = new ReactPickerAdapter(view.getContext(), data);
            adapter.setPrimaryTextColor(view.getPrimaryColor());
            view.setAdapter((SpinnerAdapter)adapter);
        } else {
            view.setAdapter(null);
        }
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ReactPicker view, @Nullable Integer color) {
        view.setPrimaryColor(color);
        ReactPickerAdapter adapter = (ReactPickerAdapter)view.getAdapter();
        if (adapter != null) {
            adapter.setPrimaryTextColor(color);
        }
    }

    @ReactProp(name="prompt")
    public void setPrompt(ReactPicker view, @Nullable String prompt) {
        view.setPrompt(prompt);
    }

    @ReactProp(name="enabled", defaultBoolean=true)
    public void setEnabled(ReactPicker view, boolean enabled) {
        view.setEnabled(enabled);
    }

    @ReactProp(name="selected")
    public void setSelected(ReactPicker view, int selected) {
        view.setStagedSelection(selected);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactPicker view) {
        super.onAfterUpdateTransaction(view);
        view.updateStagedSelection();
    }

    @Override
    protected void addEventEmitters(ThemedReactContext reactContext, ReactPicker picker) {
        picker.setOnSelectListener(new PickerEventEmitter(picker, reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher()));
    }

    private static class PickerEventEmitter
    implements ReactPicker.OnSelectListener {
        private final ReactPicker mReactPicker;
        private final EventDispatcher mEventDispatcher;

        public PickerEventEmitter(ReactPicker reactPicker, EventDispatcher eventDispatcher) {
            this.mReactPicker = reactPicker;
            this.mEventDispatcher = eventDispatcher;
        }

        @Override
        public void onItemSelected(int position) {
            this.mEventDispatcher.dispatchEvent(new PickerItemSelectEvent(this.mReactPicker.getId(), SystemClock.nanoTime(), position));
        }
    }

    private static class ReactPickerAdapter
    extends ArrayAdapter<ReadableMap> {
        private final LayoutInflater mInflater;
        @Nullable
        private Integer mPrimaryTextColor;

        public ReactPickerAdapter(Context context, ReadableMap[] data) {
            super(context, 0, (Object[])data);
            this.mInflater = (LayoutInflater)Assertions.assertNotNull((Object)context.getSystemService("layout_inflater"));
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            return this.getView(position, convertView, parent, false);
        }

        public View getDropDownView(int position, View convertView, ViewGroup parent) {
            return this.getView(position, convertView, parent, true);
        }

        private View getView(int position, View convertView, ViewGroup parent, boolean isDropdown) {
            ReadableMap item = (ReadableMap)this.getItem(position);
            if (convertView == null) {
                int layoutResId = isDropdown ? 0x1090009 : 17367048;
                convertView = this.mInflater.inflate(layoutResId, parent, false);
            }
            TextView textView = (TextView)convertView;
            textView.setText((CharSequence)item.getString("label"));
            if (!isDropdown && this.mPrimaryTextColor != null) {
                textView.setTextColor(this.mPrimaryTextColor.intValue());
            } else if (item.hasKey("color") && !item.isNull("color")) {
                textView.setTextColor(item.getInt("color"));
            }
            return convertView;
        }

        public void setPrimaryTextColor(@Nullable Integer primaryTextColor) {
            this.mPrimaryTextColor = primaryTextColor;
            this.notifyDataSetChanged();
        }
    }
}

