/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.slider;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.SeekBar;
import javax.annotation.Nullable;

public class ReactSlider
extends SeekBar {
    private static int DEFAULT_TOTAL_STEPS = 128;
    private double mMinValue = 0.0;
    private double mMaxValue = 0.0;
    private double mValue = 0.0;
    private double mStep = 0.0;

    public ReactSlider(Context context, @Nullable AttributeSet attrs, int style2) {
        super(context, attrs, style2);
    }

    void setMaxValue(double max) {
        this.mMaxValue = max;
        this.updateAll();
    }

    void setMinValue(double min) {
        this.mMinValue = min;
        this.updateAll();
    }

    void setValue(double value) {
        this.mValue = value;
        this.updateValue();
    }

    void setStep(double step) {
        this.mStep = step;
        this.updateAll();
    }

    public double toRealProgress(int seekBarProgress) {
        if (seekBarProgress == this.getMax()) {
            return this.mMaxValue;
        }
        return (double)seekBarProgress * this.mStep + this.mMinValue;
    }

    private void updateAll() {
        if (this.mStep == 0.0) {
            this.mStep = (this.mMaxValue - this.mMinValue) / (double)DEFAULT_TOTAL_STEPS;
        }
        this.setMax(this.getTotalSteps());
        this.updateValue();
    }

    private void updateValue() {
        this.setProgress((int)Math.round((this.mValue - this.mMinValue) / (this.mMaxValue - this.mMinValue) * (double)this.getTotalSteps()));
    }

    private int getTotalSteps() {
        return (int)Math.ceil((this.mMaxValue - this.mMinValue) / this.mStep);
    }
}

