/*
 * Decompiled with CFR 0.152.
 */
package net.xprinter.service;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.IBinder;
import android.util.Log;
import java.util.List;
import net.xprinter.asynncTask.XpAsynncTask;
import net.xprinter.utils.RoundQueue;
import net.xprinter.utils.XPrinterDev;
import net.xprinter.xpinterface.BackgroundInit;
import net.xprinter.xpinterface.IMyBinder;
import net.xprinter.xpinterface.ProcessData;
import net.xprinter.xpinterface.UiExecute;

public class XprinterService
extends Service {
    private XPrinterDev xPrinterDev;
    private XPrinterDev.ReturnMessage mMsg;
    private boolean isConnected = false;
    private RoundQueue<byte[]> que;
    private IBinder myBinder = new MyBinder();

    private RoundQueue<byte[]> getinstaceRoundQueue() {
        if (this.que == null) {
            this.que = new RoundQueue(500);
        }
        return this.que;
    }

    public void onCreate() {
        super.onCreate();
        Log.i((String)"TAG", (String)"onCreate");
    }

    public IBinder onBind(Intent intent) {
        Log.i((String)"TAG", (String)"onBind");
        return this.myBinder;
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.xPrinterDev != null) {
            this.xPrinterDev.Close();
        }
    }

    public class MyBinder
    extends Binder
    implements IMyBinder {
        @Override
        public void connectNetPort(final String ethernetIP, final int ethernetPort, UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    XprinterService.this.xPrinterDev = new XPrinterDev(XPrinterDev.PortType.Ethernet, ethernetIP, ethernetPort);
                    XprinterService.this.mMsg = XprinterService.this.xPrinterDev.Open();
                    if (XprinterService.this.mMsg.GetErrorCode().equals((Object)XPrinterDev.ErrorCode.OpenPortSuccess)) {
                        XprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void connectBtPort(final String bluetoothID, UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    XprinterService.this.xPrinterDev = new XPrinterDev(XPrinterDev.PortType.Bluetooth, bluetoothID);
                    XprinterService.this.mMsg = XprinterService.this.xPrinterDev.Open();
                    if (XprinterService.this.mMsg.GetErrorCode().equals((Object)XPrinterDev.ErrorCode.OpenPortSuccess)) {
                        XprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void connectUsbPort(final Context context, final String usbPathName, UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    XprinterService.this.xPrinterDev = new XPrinterDev(XPrinterDev.PortType.USB, context, usbPathName);
                    XprinterService.this.mMsg = XprinterService.this.xPrinterDev.Open();
                    if (XprinterService.this.mMsg.GetErrorCode().equals((Object)XPrinterDev.ErrorCode.OpenPortSuccess)) {
                        XprinterService.this.isConnected = true;
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void disconnectCurrentPort(UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    XprinterService.this.mMsg = XprinterService.this.xPrinterDev.Close();
                    if (XprinterService.this.mMsg.GetErrorCode().equals((Object)XPrinterDev.ErrorCode.ClosePortSuccess)) {
                        XprinterService.this.isConnected = false;
                        if (XprinterService.this.que != null) {
                            XprinterService.this.que.clear();
                        }
                        return true;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void write(final byte[] data, UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    if (data != null) {
                        XprinterService.this.mMsg = XprinterService.this.xPrinterDev.Write(data);
                        if (XprinterService.this.mMsg.GetErrorCode().equals((Object)XPrinterDev.ErrorCode.WriteDataSuccess)) {
                            XprinterService.this.isConnected = true;
                            return true;
                        }
                        XprinterService.this.isConnected = false;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void writeDataByYouself(UiExecute execute, final ProcessData processData) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    List<byte[]> list = processData.processDataBeforeSend();
                    if (list != null) {
                        int i = 0;
                        while (i < list.size()) {
                            XprinterService.this.mMsg = XprinterService.this.xPrinterDev.Write(list.get(i));
                            ++i;
                        }
                        if (XprinterService.this.mMsg.GetErrorCode().equals((Object)XPrinterDev.ErrorCode.WriteDataSuccess)) {
                            XprinterService.this.isConnected = true;
                            return true;
                        }
                        XprinterService.this.isConnected = false;
                    }
                    return false;
                }
            });
            task.execute(new Void[0]);
        }

        @Override
        public void acceptdatafromprinter(UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    XprinterService.this.que = XprinterService.this.getinstaceRoundQueue();
                    byte[] buffer = new byte[4];
                    XprinterService.this.que.clear();
                    Log.i((String)"TAG", (String)XprinterService.this.xPrinterDev.Read(buffer).GetErrorCode().toString());
                    while (XprinterService.this.xPrinterDev.Read(buffer).GetErrorCode().equals((Object)XPrinterDev.ErrorCode.ReadDataSuccess)) {
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                            return false;
                        }
                        XprinterService.this.que.addLast(buffer);
                    }
                    XprinterService.this.isConnected = false;
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }

        @Override
        public RoundQueue<byte[]> readBuffer() {
            RoundQueue queue = new RoundQueue(500);
            queue = XprinterService.this.que;
            return queue;
        }

        @Override
        public void clearBuffer() {
            XprinterService.this.que.clear();
        }

        @Override
        public void checkLinkedState(UiExecute execute) {
            XpAsynncTask task = new XpAsynncTask(execute, new BackgroundInit(){

                @Override
                public boolean doinbackground() {
                    while (XprinterService.this.isConnected) {
                        XprinterService.this.isConnected = XprinterService.this.xPrinterDev.GetPortInfo().PortIsOpen();
                    }
                    return false;
                }
            });
            task.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        }
    }
}

