/*
 * Decompiled with CFR 0.152.
 */
package net.xprinter.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import java.util.ArrayList;

public class BitmapToByteData {
    public static byte[] rasterBmpToSendData(int m, Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.toGrayscale(mBitmap);
        switch (bmpType) {
            case Dithering: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case Threshold: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        if (width > 1016) {
            width = 1016;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height);
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
        int n = (width + 7) / 8;
        byte xL = (byte)(n % 256);
        byte xH = (byte)(n / 256);
        int x = (height + 23) / 24;
        ArrayList<Byte> list = new ArrayList<Byte>();
        byte[] byArray = new byte[8];
        byArray[0] = 29;
        byArray[1] = 118;
        byArray[2] = 48;
        byArray[3] = (byte)m;
        byArray[4] = xL;
        byArray[5] = xH;
        byArray[6] = 24;
        byte[] head = byArray;
        int i = 0;
        while (i < x) {
            byte b;
            byte[] newdata;
            if (i == x - 1) {
                if (height % 24 == 0) {
                    head[6] = 24;
                    newdata = new byte[n * 24];
                    System.arraycopy(data, 24 * i * n, newdata, 0, 24 * n);
                } else {
                    head[6] = (byte)(height % 24);
                    newdata = new byte[height % 24 * n];
                    System.arraycopy(data, 24 * i * n, newdata, 0, height % 24 * n);
                }
            } else {
                newdata = new byte[n * 24];
                System.arraycopy(data, 24 * i * n, newdata, 0, 24 * n);
            }
            byte[] byArray2 = head;
            int n2 = head.length;
            int n3 = 0;
            while (n3 < n2) {
                b = byArray2[n3];
                list.add(b);
                ++n3;
            }
            byArray2 = newdata;
            n2 = newdata.length;
            n3 = 0;
            while (n3 < n2) {
                b = byArray2[n3];
                list.add(b);
                ++n3;
            }
            ++i;
        }
        byte[] byteData = new byte[list.size()];
        int i2 = 0;
        while (i2 < byteData.length) {
            byteData[i2] = (Byte)list.get(i2);
            ++i2;
        }
        return byteData;
    }

    public static byte[] flashBmpToSendData(Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.convertBmp(mBitmap);
        bitmap = BitmapToByteData.toGrayscale(bitmap);
        switch (bmpType) {
            case Dithering: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case Threshold: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int n = (width + 7) / 8;
        int h = (height + 7) / 8;
        if (n > 1023 || h > 288 || n == 0 || h == 0) {
            return new byte[0];
        }
        if (n * h >= 1023) {
            return new byte[0];
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
        byte xL = (byte)(n % 256);
        byte xH = (byte)(n / 256);
        byte yL = (byte)(h % 256);
        byte yH = (byte)(h / 256);
        byte[] head = new byte[]{xL, xH, yL, yH};
        data = BitmapToByteData.byteMerger(head, data);
        return data;
    }

    public static byte[] downLoadBmpToSendTSCdownloadcommand(Bitmap mBitmap) {
        Bitmap bitmap = mBitmap;
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] send = new byte[width * height];
        int i = 0;
        while (i < pixels.length) {
            send[i] = (byte)pixels[i];
            ++i;
        }
        byte[] data = BitmapToByteData.getbmpdataTsc(pixels, width, height);
        return data;
    }

    public static byte[] downLoadBmpToSendTSCData(Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.toGrayscale(mBitmap);
        switch (bmpType) {
            case Dithering: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case Threshold: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int n = (width + 7) / 8;
        int h = (height + 7) / 8;
        if (n > 255 || h > 48 || n == 0 || h == 0) {
            return new byte[0];
        }
        if (n * h > 912) {
            return new byte[0];
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = BitmapToByteData.getbmpdataTsc(pixels, width, height);
        return data;
    }

    public static byte[] downLoadBmpToSendData(Bitmap mBitmap, BmpType bmpType) {
        Bitmap bitmap = BitmapToByteData.convertBmp(mBitmap);
        bitmap = BitmapToByteData.toGrayscale(bitmap);
        switch (bmpType) {
            case Dithering: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
                break;
            }
            case Threshold: {
                bitmap = BitmapToByteData.convertGreyImgByFloyd(bitmap);
                break;
            }
            default: {
                bitmap = BitmapToByteData.convertGreyImg(bitmap);
            }
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int n = (width + 7) / 8;
        int h = (height + 7) / 8;
        if (n > 255 || h > 48 || n == 0 || h == 0) {
            return new byte[0];
        }
        if (n * h > 912) {
            return new byte[0];
        }
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        byte[] data = BitmapToByteData.getbmpdata(pixels, width, height);
        byte[] head = new byte[]{(byte)n, (byte)h};
        data = BitmapToByteData.byteMerger(head, data);
        return data;
    }

    private static Bitmap toGrayscale(Bitmap bmpOriginal) {
        int height = bmpOriginal.getHeight();
        int width = bmpOriginal.getWidth();
        Bitmap bmpGrayscale = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas c = new Canvas(bmpGrayscale);
        Paint paint = new Paint();
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        ColorMatrixColorFilter f = new ColorMatrixColorFilter(cm);
        paint.setColorFilter((ColorFilter)f);
        c.drawBitmap(bmpOriginal, 0.0f, 0.0f, paint);
        return bmpGrayscale;
    }

    private static Bitmap convertGreyImg(Bitmap img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        double redSum = 0.0;
        double total = width * height;
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int grey = pixels[width * i + j];
                int red = (grey & 0xFF0000) >> 16;
                redSum += (double)red;
                ++j;
            }
            ++i;
        }
        int m = (int)(redSum / total);
        int i2 = 0;
        while (i2 < height) {
            int j = 0;
            while (j < width) {
                int grey = pixels[width * i2 + j];
                int alpha1 = -16777216;
                int red = (grey & 0xFF0000) >> 16;
                int green = (grey & 0xFF00) >> 8;
                int blue = grey & 0xFF;
                if (red >= m) {
                    blue = 255;
                    green = 255;
                    red = 255;
                } else {
                    blue = 0;
                    green = 0;
                    red = 0;
                }
                pixels[width * i2 + j] = grey = alpha1 | red << 16 | green << 8 | blue;
                ++j;
            }
            ++i2;
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    private static Bitmap convertGreyImgByFloyd(Bitmap img) {
        int width = img.getWidth();
        int height = img.getHeight();
        int[] pixels = new int[width * height];
        img.getPixels(pixels, 0, width, 0, 0, width, height);
        int[] gray = new int[height * width];
        int i = 0;
        while (i < height) {
            int j = 0;
            while (j < width) {
                int red;
                int grey = pixels[width * i + j];
                gray[width * i + j] = red = (grey & 0xFF0000) >> 16;
                ++j;
            }
            ++i;
        }
        int e = 0;
        int i2 = 0;
        while (i2 < height) {
            int j = 0;
            while (j < width) {
                int g = gray[width * i2 + j];
                if (g >= 128) {
                    pixels[width * i2 + j] = -1;
                    e = g - 255;
                } else {
                    pixels[width * i2 + j] = -16777216;
                    e = g - 0;
                }
                if (j < width - 1 && i2 < height - 1) {
                    int n = width * i2 + j + 1;
                    gray[n] = gray[n] + 3 * e / 8;
                    int n2 = width * (i2 + 1) + j;
                    gray[n2] = gray[n2] + 3 * e / 8;
                    int n3 = width * (i2 + 1) + j + 1;
                    gray[n3] = gray[n3] + e / 4;
                } else if (j == width - 1 && i2 < height - 1) {
                    int n = width * (i2 + 1) + j;
                    gray[n] = gray[n] + 3 * e / 8;
                } else if (j < width - 1 && i2 == height - 1) {
                    int n = width * i2 + j + 1;
                    gray[n] = gray[n] + e / 4;
                }
                ++j;
            }
            ++i2;
        }
        Bitmap mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        mBitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return mBitmap;
    }

    private static byte[] getbmpdata(int[] b, int w, int h) {
        int n = (w + 7) / 8;
        byte[] data = new byte[n * h];
        int mask = 1;
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < n * 8) {
                if (x < w) {
                    if ((b[y * w + x] & 0xFF0000) >> 16 != 0) {
                        int n2 = y * n + x / 8;
                        data[n2] = (byte)(data[n2] | (byte)(mask << 7 - x % 8));
                    }
                } else if (x >= w) {
                    int n3 = y * n + x / 8;
                    data[n3] = (byte)(data[n3] | (byte)(mask << 7 - x % 8));
                }
                ++x;
            }
            ++y;
        }
        int i = 0;
        while (i < data.length) {
            data[i] = ~data[i];
            ++i;
        }
        return data;
    }

    private static byte[] getbmpdataTsc(int[] b, int w, int h) {
        int n = (w + 7) / 8;
        byte[] data = new byte[n * h];
        int mask = 1;
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < n * 8) {
                if (x < w) {
                    if ((b[y * w + x] & 0xFF0000) >> 16 != 0) {
                        int n2 = y * n + x / 8;
                        data[n2] = (byte)(data[n2] | (byte)(mask << 7 - x % 8));
                    }
                } else if (x >= w) {
                    int n3 = y * n + x / 8;
                    data[n3] = (byte)(data[n3] | (byte)(mask << 7 - x % 8));
                }
                ++x;
            }
            ++y;
        }
        return data;
    }

    private static byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    private static Bitmap convertBmp(Bitmap bmp) {
        int w = bmp.getWidth();
        int h = bmp.getHeight();
        Bitmap convertBmp = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(convertBmp);
        Matrix matrix = new Matrix();
        matrix.postScale(-1.0f, 1.0f);
        matrix.postRotate(-90.0f);
        Bitmap newBmp = Bitmap.createBitmap((Bitmap)bmp, (int)0, (int)0, (int)w, (int)h, (Matrix)matrix, (boolean)true);
        cv.drawBitmap(newBmp, new Rect(0, 0, newBmp.getWidth(), newBmp.getHeight()), new Rect(0, 0, w, h), null);
        return convertBmp;
    }

    public static enum BmpType {
        Dithering,
        Threshold;

    }
}

