/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Toast;
import com.facebook.common.logging.FLog;
import com.facebook.react.ReactApplication;
import com.facebook.react.ReactInstanceManager;
import com.facebook.react.ReactNativeHost;
import com.facebook.react.ReactRootView;
import com.facebook.react.devsupport.DoubleTapReloadRecognizer;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.PermissionAwareActivity;
import com.facebook.react.modules.core.PermissionListener;
import javax.annotation.Nullable;

public abstract class ReactActivity
extends Activity
implements DefaultHardwareBackBtnHandler,
PermissionAwareActivity {
    private static final String REDBOX_PERMISSION_MESSAGE = "Overlay permissions needs to be granted in order for react native apps to run in dev mode";
    @Nullable
    private PermissionListener mPermissionListener;
    @Nullable
    private ReactInstanceManager mReactInstanceManager;
    @Nullable
    private ReactRootView mReactRootView;
    private DoubleTapReloadRecognizer mDoubleTapReloadRecognizer;
    private boolean mDoRefresh = false;

    @Nullable
    protected Bundle getLaunchOptions() {
        return null;
    }

    protected abstract String getMainComponentName();

    protected ReactRootView createRootView() {
        return new ReactRootView((Context)this);
    }

    protected ReactNativeHost getReactNativeHost() {
        return ((ReactApplication)this.getApplication()).getReactNativeHost();
    }

    protected boolean getUseDeveloperSupport() {
        return ((ReactApplication)this.getApplication()).getReactNativeHost().getUseDeveloperSupport();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getUseDeveloperSupport() && Build.VERSION.SDK_INT >= 23 && !Settings.canDrawOverlays((Context)this)) {
            Intent serviceIntent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION");
            this.startActivity(serviceIntent);
            FLog.w((String)"React", (String)REDBOX_PERMISSION_MESSAGE);
            Toast.makeText((Context)this, (CharSequence)REDBOX_PERMISSION_MESSAGE, (int)1).show();
        }
        this.mReactRootView = this.createRootView();
        this.mReactRootView.startReactApplication(this.getReactNativeHost().getReactInstanceManager(), this.getMainComponentName(), this.getLaunchOptions());
        this.setContentView((View)this.mReactRootView);
        this.mDoubleTapReloadRecognizer = new DoubleTapReloadRecognizer();
    }

    protected void onPause() {
        super.onPause();
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostPause();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onHostResume(this, this);
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mReactRootView != null) {
            this.mReactRootView.unmountReactApplication();
            this.mReactRootView = null;
        }
        this.getReactNativeHost().clear();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onActivityResult(requestCode, resultCode, data);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.getReactNativeHost().hasInstance() && this.getUseDeveloperSupport()) {
            if (keyCode == 82) {
                this.getReactNativeHost().getReactInstanceManager().showDevOptionsDialog();
                return true;
            }
            if (this.mDoubleTapReloadRecognizer.didDoubleTapR(keyCode, this.getCurrentFocus())) {
                this.getReactNativeHost().getReactInstanceManager().getDevSupportManager().handleReloadJS();
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public void onBackPressed() {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onBackPressed();
        } else {
            super.onBackPressed();
        }
    }

    @Override
    public void invokeDefaultOnBackPressed() {
        super.onBackPressed();
    }

    public void onNewIntent(Intent intent) {
        if (this.getReactNativeHost().hasInstance()) {
            this.getReactNativeHost().getReactInstanceManager().onNewIntent(intent);
        } else {
            super.onNewIntent(intent);
        }
    }

    @Override
    public void requestPermissions(String[] permissions, int requestCode, PermissionListener listener) {
        this.mPermissionListener = listener;
        this.requestPermissions(permissions, requestCode);
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (this.mPermissionListener != null && this.mPermissionListener.onRequestPermissionsResult(requestCode, permissions, grantResults)) {
            this.mPermissionListener = null;
        }
    }
}

