/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.JavaOnlyArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JavaOnlyMap
implements ReadableMap,
WritableMap {
    private final Map mBackingMap;

    public static JavaOnlyMap of(Object ... keysAndValues) {
        return new JavaOnlyMap(keysAndValues);
    }

    private JavaOnlyMap(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("You must provide the same number of keys and values");
        }
        this.mBackingMap = new HashMap();
        for (int i = 0; i < keysAndValues.length; i += 2) {
            this.mBackingMap.put(keysAndValues[i], keysAndValues[i + 1]);
        }
    }

    public JavaOnlyMap() {
        this.mBackingMap = new HashMap();
    }

    @Override
    public boolean hasKey(String name) {
        return this.mBackingMap.containsKey(name);
    }

    @Override
    public boolean isNull(String name) {
        return this.mBackingMap.get(name) == null;
    }

    @Override
    public boolean getBoolean(String name) {
        return (Boolean)this.mBackingMap.get(name);
    }

    @Override
    public double getDouble(String name) {
        return (Double)this.mBackingMap.get(name);
    }

    @Override
    public int getInt(String name) {
        return (Integer)this.mBackingMap.get(name);
    }

    @Override
    public String getString(String name) {
        return (String)this.mBackingMap.get(name);
    }

    @Override
    public JavaOnlyMap getMap(String name) {
        return (JavaOnlyMap)this.mBackingMap.get(name);
    }

    @Override
    public JavaOnlyArray getArray(String name) {
        return (JavaOnlyArray)this.mBackingMap.get(name);
    }

    @Override
    public ReadableType getType(String name) {
        throw new UnsupportedOperationException("Method not implemented");
    }

    @Override
    public ReadableMapKeySetIterator keySetIterator() {
        return new ReadableMapKeySetIterator(){
            Iterator<String> mIterator;
            {
                this.mIterator = JavaOnlyMap.this.mBackingMap.keySet().iterator();
            }

            @Override
            public boolean hasNextKey() {
                return this.mIterator.hasNext();
            }

            @Override
            public String nextKey() {
                return this.mIterator.next();
            }
        };
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putDouble(String key, double value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putInt(String key, int value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putString(String key, String value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void putNull(String key) {
        this.mBackingMap.put(key, null);
    }

    @Override
    public void putMap(String key, WritableMap value) {
        this.mBackingMap.put(key, value);
    }

    @Override
    public void merge(ReadableMap source) {
        this.mBackingMap.putAll(((JavaOnlyMap)source).mBackingMap);
    }

    @Override
    public void putArray(String key, WritableArray value) {
        this.mBackingMap.put(key, value);
    }

    public String toString() {
        return this.mBackingMap.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaOnlyMap that = (JavaOnlyMap)o;
        return !(this.mBackingMap != null ? !this.mBackingMap.equals(that.mBackingMap) : that.mBackingMap != null);
    }

    public int hashCode() {
        return this.mBackingMap != null ? this.mBackingMap.hashCode() : 0;
    }
}

