/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.cxxbridge;

import android.content.Context;
import com.facebook.react.cxxbridge.CatalystInstanceImpl;

public abstract class JSBundleLoader {
    public static JSBundleLoader createFileLoader(final Context context, final String fileName) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(CatalystInstanceImpl instance) {
                if (fileName.startsWith("assets://")) {
                    instance.loadScriptFromAssets(context.getAssets(), fileName);
                } else {
                    instance.loadScriptFromFile(fileName, fileName);
                }
            }

            @Override
            public String getSourceUrl() {
                return fileName;
            }
        };
    }

    public static JSBundleLoader createCachedBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(CatalystInstanceImpl instance) {
                instance.loadScriptFromFile(cachedFileLocation, sourceURL);
            }

            @Override
            public String getSourceUrl() {
                return sourceURL;
            }
        };
    }

    public static JSBundleLoader createRemoteDebuggerBundleLoader(final String proxySourceURL, final String realSourceURL) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(CatalystInstanceImpl instance) {
                instance.loadScriptFromFile(null, proxySourceURL);
            }

            @Override
            public String getSourceUrl() {
                return realSourceURL;
            }
        };
    }

    public abstract void loadScript(CatalystInstanceImpl var1);

    public abstract String getSourceUrl();
}

