/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.widget.Toast;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.DefaultNativeModuleCallExceptionHandler;
import com.facebook.react.bridge.JavaJSExecutor;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WebsocketJavaScriptExecutor;
import com.facebook.react.common.ShakeDetector;
import com.facebook.react.common.futures.SimpleSettableFuture;
import com.facebook.react.devsupport.DebugOverlayController;
import com.facebook.react.devsupport.DebugServerException;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.DevOptionHandler;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSettingsActivity;
import com.facebook.react.devsupport.DevSupportManager;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.JSCHeapCapture;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.devsupport.RedBoxDialog;
import com.facebook.react.devsupport.RedBoxHandler;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.modules.debug.DeveloperSettings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class DevSupportManagerImpl
implements DevSupportManager {
    private static final int JAVA_ERROR_COOKIE = -1;
    private static final String JS_BUNDLE_FILE_NAME = "ReactNativeDevBundle.js";
    private static final String EXOPACKAGE_LOCATION_FORMAT = "/data/local/tmp/exopackage/%s//secondary-dex";
    private final Context mApplicationContext;
    private final ShakeDetector mShakeDetector;
    private final BroadcastReceiver mReloadAppBroadcastReceiver;
    private final DevServerHelper mDevServerHelper;
    private final LinkedHashMap<String, DevOptionHandler> mCustomDevOptions = new LinkedHashMap();
    private final ReactInstanceDevCommandsHandler mReactInstanceCommandsHandler;
    @Nullable
    private final String mJSAppBundleName;
    private final File mJSBundleTempFile;
    private final DefaultNativeModuleCallExceptionHandler mDefaultNativeModuleCallExceptionHandler;
    @Nullable
    private RedBoxDialog mRedBoxDialog;
    @Nullable
    private AlertDialog mDevOptionsDialog;
    @Nullable
    private DebugOverlayController mDebugOverlayController;
    @Nullable
    private ReactContext mCurrentContext;
    private DevInternalSettings mDevSettings;
    private boolean mIsReceiverRegistered = false;
    private boolean mIsShakeDetectorStarted = false;
    private boolean mIsDevSupportEnabled = false;
    @Nullable
    private RedBoxHandler mRedBoxHandler;

    public DevSupportManagerImpl(Context applicationContext, ReactInstanceDevCommandsHandler reactInstanceCommandsHandler, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate) {
        this(applicationContext, reactInstanceCommandsHandler, packagerPathForJSBundleName, enableOnCreate, null);
    }

    public DevSupportManagerImpl(Context applicationContext, ReactInstanceDevCommandsHandler reactInstanceCommandsHandler, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler) {
        this.mReactInstanceCommandsHandler = reactInstanceCommandsHandler;
        this.mApplicationContext = applicationContext;
        this.mJSAppBundleName = packagerPathForJSBundleName;
        this.mDevSettings = new DevInternalSettings(applicationContext, this);
        this.mDevServerHelper = new DevServerHelper(this.mDevSettings);
        this.mShakeDetector = new ShakeDetector(new ShakeDetector.ShakeListener(){

            @Override
            public void onShake() {
                DevSupportManagerImpl.this.showDevOptionsDialog();
            }
        });
        this.mReloadAppBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevServerHelper.getReloadAppAction(context).equals(action)) {
                    if (intent.getBooleanExtra("jsproxy", false)) {
                        DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(true);
                        DevSupportManagerImpl.this.mDevServerHelper.launchJSDevtools();
                    } else {
                        DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(false);
                    }
                    DevSupportManagerImpl.this.handleReloadJS();
                }
            }
        };
        this.mJSBundleTempFile = new File(applicationContext.getFilesDir(), JS_BUNDLE_FILE_NAME);
        this.mDefaultNativeModuleCallExceptionHandler = new DefaultNativeModuleCallExceptionHandler();
        this.setDevSupportEnabled(enableOnCreate);
        this.mRedBoxHandler = redBoxHandler;
    }

    @Override
    public void handleException(Exception e) {
        if (this.mIsDevSupportEnabled) {
            FLog.e((String)"React", (String)"Exception in native call from JS", (Throwable)e);
            this.showNewJavaError(e.getMessage(), e);
        } else {
            this.mDefaultNativeModuleCallExceptionHandler.handleException(e);
        }
    }

    @Override
    public void showNewJavaError(String message, Throwable e) {
        this.showNewError(message, StackTraceHelper.convertJavaStackTrace(e), -1, ErrorType.NATIVE);
    }

    @Override
    public void addCustomDevOption(String optionName, DevOptionHandler optionHandler) {
        this.mCustomDevOptions.put(optionName, optionHandler);
    }

    @Override
    public void showNewJSError(String message, ReadableArray details, int errorCookie) {
        this.showNewError(message, StackTraceHelper.convertJsStackTrace(details), errorCookie, ErrorType.JS);
    }

    @Override
    public void updateJSError(final String message, final ReadableArray details, final int errorCookie) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevSupportManagerImpl.this.mRedBoxDialog == null || !DevSupportManagerImpl.this.mRedBoxDialog.isShowing() || errorCookie != DevSupportManagerImpl.this.mRedBoxDialog.getErrorCookie()) {
                    return;
                }
                StackTraceHelper.StackFrame[] stack = StackTraceHelper.convertJsStackTrace(details);
                DevSupportManagerImpl.this.mRedBoxDialog.setExceptionDetails(message, stack);
                DevSupportManagerImpl.this.mRedBoxDialog.setErrorCookie(errorCookie);
                if (DevSupportManagerImpl.this.mRedBoxHandler != null) {
                    DevSupportManagerImpl.this.mRedBoxHandler.handleRedbox(message, stack, RedBoxHandler.ErrorType.JS);
                }
                DevSupportManagerImpl.this.mRedBoxDialog.show();
            }
        });
    }

    @Override
    public void hideRedboxDialog() {
        if (this.mRedBoxDialog != null) {
            this.mRedBoxDialog.dismiss();
        }
    }

    private void showNewError(final String message, final StackTraceHelper.StackFrame[] stack, final int errorCookie, final ErrorType errorType) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevSupportManagerImpl.this.mRedBoxDialog == null) {
                    DevSupportManagerImpl.this.mRedBoxDialog = new RedBoxDialog(DevSupportManagerImpl.this.mApplicationContext, DevSupportManagerImpl.this);
                    DevSupportManagerImpl.this.mRedBoxDialog.getWindow().setType(2003);
                }
                if (DevSupportManagerImpl.this.mRedBoxDialog.isShowing()) {
                    return;
                }
                DevSupportManagerImpl.this.mRedBoxDialog.setExceptionDetails(message, stack);
                DevSupportManagerImpl.this.mRedBoxDialog.setErrorCookie(errorCookie);
                if (DevSupportManagerImpl.this.mRedBoxHandler != null && errorType == ErrorType.NATIVE) {
                    DevSupportManagerImpl.this.mRedBoxHandler.handleRedbox(message, stack, RedBoxHandler.ErrorType.NATIVE);
                }
                DevSupportManagerImpl.this.mRedBoxDialog.show();
            }
        });
    }

    @Override
    public void showDevOptionsDialog() {
        if (this.mDevOptionsDialog != null || !this.mIsDevSupportEnabled) {
            return;
        }
        LinkedHashMap<String, DevOptionHandler> options = new LinkedHashMap<String, DevOptionHandler>();
        options.put(this.mApplicationContext.getString(R.string.catalyst_reloadjs), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
        options.put(this.mDevSettings.isRemoteJSDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_debugjs_off) : this.mApplicationContext.getString(R.string.catalyst_debugjs), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setRemoteJSDebugEnabled(!DevSupportManagerImpl.this.mDevSettings.isRemoteJSDebugEnabled());
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
        options.put(this.mDevSettings.isReloadOnJSChangeEnabled() ? this.mApplicationContext.getString(R.string.catalyst_live_reload_off) : this.mApplicationContext.getString(R.string.catalyst_live_reload), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setReloadOnJSChangeEnabled(!DevSupportManagerImpl.this.mDevSettings.isReloadOnJSChangeEnabled());
            }
        });
        options.put(this.mDevSettings.isHotModuleReplacementEnabled() ? this.mApplicationContext.getString(R.string.catalyst_hot_module_replacement_off) : this.mApplicationContext.getString(R.string.catalyst_hot_module_replacement), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setHotModuleReplacementEnabled(!DevSupportManagerImpl.this.mDevSettings.isHotModuleReplacementEnabled());
                DevSupportManagerImpl.this.handleReloadJS();
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_element_inspector), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setElementInspectorEnabled(!DevSupportManagerImpl.this.mDevSettings.isElementInspectorEnabled());
                DevSupportManagerImpl.this.mReactInstanceCommandsHandler.toggleElementInspector();
            }
        });
        options.put(this.mDevSettings.isFpsDebugEnabled() ? this.mApplicationContext.getString(R.string.catalyst_perf_monitor_off) : this.mApplicationContext.getString(R.string.catalyst_perf_monitor), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManagerImpl.this.mDevSettings.setFpsDebugEnabled(!DevSupportManagerImpl.this.mDevSettings.isFpsDebugEnabled());
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_heap_capture), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                try {
                    String heapDumpPath = DevSupportManagerImpl.this.mApplicationContext.getCacheDir().getPath();
                    List<String> captureFiles = JSCHeapCapture.captureHeap(heapDumpPath, 60000L);
                    for (String captureFile : captureFiles) {
                        Toast.makeText((Context)DevSupportManagerImpl.this.mCurrentContext, (CharSequence)("Heap captured to " + captureFile), (int)1).show();
                    }
                }
                catch (JSCHeapCapture.CaptureException e) {
                    DevSupportManagerImpl.this.showNewJavaError(e.getMessage(), e);
                }
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_settings), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                Intent intent = new Intent(DevSupportManagerImpl.this.mApplicationContext, DevSettingsActivity.class);
                intent.setFlags(0x10000000);
                DevSupportManagerImpl.this.mApplicationContext.startActivity(intent);
            }
        });
        if (this.mCustomDevOptions.size() > 0) {
            options.putAll(this.mCustomDevOptions);
        }
        final DevOptionHandler[] optionHandlers = options.values().toArray(new DevOptionHandler[0]);
        this.mDevOptionsDialog = new AlertDialog.Builder(this.mApplicationContext).setItems((CharSequence[])options.keySet().toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                optionHandlers[which].onOptionSelected();
                DevSupportManagerImpl.this.mDevOptionsDialog = null;
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DevSupportManagerImpl.this.mDevOptionsDialog = null;
            }
        }).create();
        this.mDevOptionsDialog.getWindow().setType(2003);
        this.mDevOptionsDialog.show();
    }

    @Override
    public void setDevSupportEnabled(boolean isDevSupportEnabled) {
        this.mIsDevSupportEnabled = isDevSupportEnabled;
        this.reload();
    }

    @Override
    public boolean getDevSupportEnabled() {
        return this.mIsDevSupportEnabled;
    }

    @Override
    public DeveloperSettings getDevSettings() {
        return this.mDevSettings;
    }

    @Override
    public void onNewReactContextCreated(ReactContext reactContext) {
        this.resetCurrentContext(reactContext);
    }

    @Override
    public void onReactInstanceDestroyed(ReactContext reactContext) {
        if (reactContext == this.mCurrentContext) {
            this.resetCurrentContext(null);
        }
    }

    @Override
    public String getSourceMapUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceMapUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getSourceUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getJSBundleURLForRemoteDebugging() {
        return this.mDevServerHelper.getJSBundleURLForRemoteDebugging((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    @Override
    public String getDownloadedJSBundleFile() {
        return this.mJSBundleTempFile.getAbsolutePath();
    }

    @Override
    public boolean hasUpToDateJSBundleInCache() {
        if (this.mIsDevSupportEnabled && this.mJSBundleTempFile.exists()) {
            try {
                String packageName = this.mApplicationContext.getPackageName();
                PackageInfo thisPackage = this.mApplicationContext.getPackageManager().getPackageInfo(packageName, 0);
                if (this.mJSBundleTempFile.lastModified() > thisPackage.lastUpdateTime) {
                    File exopackageDir = new File(String.format(Locale.US, EXOPACKAGE_LOCATION_FORMAT, packageName));
                    if (exopackageDir.exists()) {
                        return this.mJSBundleTempFile.lastModified() > exopackageDir.lastModified();
                    }
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                FLog.e((String)"React", (String)"DevSupport is unable to get current app info");
            }
        }
        return false;
    }

    public boolean hasBundleInAssets(String bundleAssetName) {
        try {
            String[] assets = this.mApplicationContext.getAssets().list("");
            for (int i = 0; i < assets.length; ++i) {
                if (!assets[i].equals(bundleAssetName)) continue;
                return true;
            }
        }
        catch (IOException e) {
            FLog.e((String)"React", (String)"Error while loading assets list");
        }
        return false;
    }

    private void resetCurrentContext(@Nullable ReactContext reactContext) {
        if (this.mCurrentContext == reactContext) {
            return;
        }
        this.mCurrentContext = reactContext;
        if (this.mDebugOverlayController != null) {
            this.mDebugOverlayController.setFpsDebugViewVisible(false);
        }
        if (reactContext != null) {
            this.mDebugOverlayController = new DebugOverlayController(reactContext);
        }
        if (this.mDevSettings.isHotModuleReplacementEnabled() && this.mCurrentContext != null) {
            try {
                URL sourceUrl = new URL(this.getSourceUrl());
                String path = sourceUrl.getPath().substring(1);
                String host = sourceUrl.getHost();
                int port = sourceUrl.getPort();
                this.mCurrentContext.getJSModule(HMRClient.class).enable("android", path, host, port);
            }
            catch (MalformedURLException e) {
                this.showNewJavaError(e.getMessage(), e);
            }
        }
        this.reloadSettings();
    }

    @Override
    public void reloadSettings() {
        this.reload();
    }

    @Override
    public void handleReloadJS() {
        UiThreadUtil.assertOnUiThread();
        if (this.mRedBoxDialog != null) {
            this.mRedBoxDialog.dismiss();
        }
        AlertDialog dialog = new AlertDialog.Builder(this.mApplicationContext).setTitle(R.string.catalyst_jsload_title).setMessage((CharSequence)this.mApplicationContext.getString(this.mDevSettings.isRemoteJSDebugEnabled() ? R.string.catalyst_remotedbg_message : R.string.catalyst_jsload_message)).create();
        dialog.getWindow().setType(2003);
        dialog.show();
        if (this.mDevSettings.isRemoteJSDebugEnabled()) {
            this.reloadJSInProxyMode(dialog);
        } else {
            this.reloadJSFromServer(dialog);
        }
    }

    @Override
    public void isPackagerRunning(DevServerHelper.PackagerStatusCallback callback) {
        this.mDevServerHelper.isPackagerRunning(callback);
    }

    private void reloadJSInProxyMode(final AlertDialog progressDialog) {
        this.mDevServerHelper.launchJSDevtools();
        JavaJSExecutor.Factory factory = new JavaJSExecutor.Factory(){

            @Override
            public JavaJSExecutor create() throws Exception {
                WebsocketJavaScriptExecutor executor = new WebsocketJavaScriptExecutor();
                SimpleSettableFuture future = new SimpleSettableFuture();
                executor.connect(DevSupportManagerImpl.this.mDevServerHelper.getWebsocketProxyURL(), DevSupportManagerImpl.this.getExecutorConnectCallback(progressDialog, future));
                try {
                    future.get(90L, TimeUnit.SECONDS);
                    return executor;
                }
                catch (ExecutionException e) {
                    throw (Exception)e.getCause();
                }
                catch (InterruptedException | TimeoutException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.mReactInstanceCommandsHandler.onReloadWithJSDebugger(factory);
    }

    private WebsocketJavaScriptExecutor.JSExecutorConnectCallback getExecutorConnectCallback(final AlertDialog progressDialog, final SimpleSettableFuture<Boolean> future) {
        return new WebsocketJavaScriptExecutor.JSExecutorConnectCallback(){

            @Override
            public void onSuccess() {
                future.set(true);
                progressDialog.dismiss();
            }

            @Override
            public void onFailure(Throwable cause) {
                progressDialog.dismiss();
                FLog.e((String)"React", (String)"Unable to connect to remote debugger", (Throwable)cause);
                future.setException(new IOException(DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_remotedbg_error), cause));
            }
        };
    }

    private void reloadJSFromServer(final AlertDialog progressDialog) {
        this.mDevServerHelper.downloadBundleFromURL(new DevServerHelper.BundleDownloadCallback(){

            @Override
            public void onSuccess() {
                progressDialog.dismiss();
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DevSupportManagerImpl.this.mReactInstanceCommandsHandler.onJSBundleLoadedFromServer();
                    }
                });
            }

            @Override
            public void onFailure(final Exception cause) {
                progressDialog.dismiss();
                FLog.e((String)"React", (String)"Unable to download JS bundle", (Throwable)cause);
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (cause instanceof DebugServerException) {
                            DebugServerException debugServerException = (DebugServerException)cause;
                            DevSupportManagerImpl.this.showNewJavaError(debugServerException.getMessage(), cause);
                        } else {
                            DevSupportManagerImpl.this.showNewJavaError(DevSupportManagerImpl.this.mApplicationContext.getString(R.string.catalyst_jsload_error), cause);
                        }
                    }
                });
            }
        }, (String)Assertions.assertNotNull((Object)this.mJSAppBundleName), this.mJSBundleTempFile);
        progressDialog.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DevSupportManagerImpl.this.mDevServerHelper.cancelDownloadBundleFromURL();
            }
        });
        progressDialog.setCancelable(true);
    }

    private void reload() {
        if (this.mIsDevSupportEnabled) {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(this.mDevSettings.isFpsDebugEnabled());
            }
            if (!this.mIsShakeDetectorStarted) {
                this.mShakeDetector.start((SensorManager)this.mApplicationContext.getSystemService("sensor"));
                this.mIsShakeDetectorStarted = true;
            }
            if (!this.mIsReceiverRegistered) {
                IntentFilter filter = new IntentFilter();
                filter.addAction(DevServerHelper.getReloadAppAction(this.mApplicationContext));
                this.mApplicationContext.registerReceiver(this.mReloadAppBroadcastReceiver, filter);
                this.mIsReceiverRegistered = true;
            }
            if (this.mDevSettings.isReloadOnJSChangeEnabled()) {
                this.mDevServerHelper.startPollingOnChangeEndpoint(new DevServerHelper.OnServerContentChangeListener(){

                    @Override
                    public void onServerContentChanged() {
                        DevSupportManagerImpl.this.handleReloadJS();
                    }
                });
            } else {
                this.mDevServerHelper.stopPollingOnChangeEndpoint();
            }
        } else {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(false);
            }
            if (this.mIsShakeDetectorStarted) {
                this.mShakeDetector.stop();
                this.mIsShakeDetectorStarted = false;
            }
            if (this.mIsReceiverRegistered) {
                this.mApplicationContext.unregisterReceiver(this.mReloadAppBroadcastReceiver);
                this.mIsReceiverRegistered = false;
            }
            if (this.mRedBoxDialog != null) {
                this.mRedBoxDialog.dismiss();
            }
            if (this.mDevOptionsDialog != null) {
                this.mDevOptionsDialog.dismiss();
            }
            this.mDevServerHelper.stopPollingOnChangeEndpoint();
        }
    }

    private static enum ErrorType {
        JS,
        NATIVE;

    }
}

