/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.image;

import android.net.Uri;
import com.facebook.common.executors.CallerThreadExecutor;
import com.facebook.common.references.CloseableReference;
import com.facebook.datasource.BaseDataSubscriber;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import java.util.concurrent.Executor;

public class ImageLoaderModule
extends ReactContextBaseJavaModule {
    private static final String ERROR_INVALID_URI = "E_INVALID_URI";
    private static final String ERROR_PREFETCH_FAILURE = "E_PREFETCH_FAILURE";
    private static final String ERROR_GET_SIZE_FAILURE = "E_GET_SIZE_FAILURE";
    private final Object mCallerContext;

    public ImageLoaderModule(ReactApplicationContext reactContext) {
        super(reactContext);
        this.mCallerContext = this;
    }

    public ImageLoaderModule(ReactApplicationContext reactContext, Object callerContext) {
        super(reactContext);
        this.mCallerContext = callerContext;
    }

    @Override
    public String getName() {
        return "ImageLoader";
    }

    @ReactMethod
    public void getSize(String uriString, final Promise promise) {
        if (uriString == null || uriString.isEmpty()) {
            promise.reject(ERROR_INVALID_URI, "Cannot get the size of an image for an empty URI");
            return;
        }
        Uri uri = Uri.parse((String)uriString);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).build();
        DataSource dataSource = Fresco.getImagePipeline().fetchDecodedImage(request, this.mCallerContext);
        BaseDataSubscriber<CloseableReference<CloseableImage>> dataSubscriber = new BaseDataSubscriber<CloseableReference<CloseableImage>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                CloseableReference ref = (CloseableReference)dataSource.getResult();
                if (ref != null) {
                    try {
                        CloseableImage image = (CloseableImage)ref.get();
                        WritableMap sizes = Arguments.createMap();
                        sizes.putInt("width", image.getWidth());
                        sizes.putInt("height", image.getHeight());
                        promise.resolve(sizes);
                    }
                    catch (Exception e) {
                        promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE, e);
                    }
                    finally {
                        CloseableReference.closeSafely((CloseableReference)ref);
                    }
                } else {
                    promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE);
                }
            }

            protected void onFailureImpl(DataSource<CloseableReference<CloseableImage>> dataSource) {
                promise.reject(ImageLoaderModule.ERROR_GET_SIZE_FAILURE, dataSource.getFailureCause());
            }
        };
        dataSource.subscribe((DataSubscriber)dataSubscriber, (Executor)CallerThreadExecutor.getInstance());
    }

    @ReactMethod
    public void prefetchImage(String uriString, final Promise promise) {
        if (uriString == null || uriString.isEmpty()) {
            promise.reject(ERROR_INVALID_URI, "Cannot prefetch an image for an empty URI");
            return;
        }
        Uri uri = Uri.parse((String)uriString);
        ImageRequest request = ImageRequestBuilder.newBuilderWithSource((Uri)uri).build();
        DataSource prefetchSource = Fresco.getImagePipeline().prefetchToDiskCache(request, this.mCallerContext);
        BaseDataSubscriber<Void> prefetchSubscriber = new BaseDataSubscriber<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onNewResultImpl(DataSource<Void> dataSource) {
                if (!dataSource.isFinished()) {
                    return;
                }
                try {
                    promise.resolve(true);
                }
                finally {
                    dataSource.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onFailureImpl(DataSource<Void> dataSource) {
                try {
                    promise.reject(ImageLoaderModule.ERROR_PREFETCH_FAILURE, dataSource.getFailureCause());
                }
                finally {
                    dataSource.close();
                }
            }
        };
        prefetchSource.subscribe((DataSubscriber)prefetchSubscriber, (Executor)CallerThreadExecutor.getInstance());
    }
}

