/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.ExecutorToken;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.common.network.OkHttpCallUtil;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.network.CookieJarContainer;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.NetworkInterceptorCreator;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.modules.network.ProgressRequestListener;
import com.facebook.react.modules.network.RequestBodyUtil;
import com.facebook.react.modules.network.ResponseUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.CookieHandler;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.Headers;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public final class NetworkingModule
extends ReactContextBaseJavaModule {
    private static final String CONTENT_ENCODING_HEADER_NAME = "content-encoding";
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String REQUEST_BODY_KEY_STRING = "string";
    private static final String REQUEST_BODY_KEY_URI = "uri";
    private static final String REQUEST_BODY_KEY_FORMDATA = "formData";
    private static final String USER_AGENT_HEADER_NAME = "user-agent";
    private static final int CHUNK_TIMEOUT_NS = 100000000;
    private static final int MAX_CHUNK_SIZE_BETWEEN_FLUSHES = 8192;
    private final OkHttpClient mClient;
    private final ForwardingCookieHandler mCookieHandler;
    @Nullable
    private final String mDefaultUserAgent;
    private final CookieJarContainer mCookieJarContainer;
    private final Set<Integer> mRequestIds;
    private boolean mShuttingDown;

    NetworkingModule(ReactApplicationContext reactContext, @Nullable String defaultUserAgent, OkHttpClient client, @Nullable List<NetworkInterceptorCreator> networkInterceptorCreators) {
        super(reactContext);
        if (networkInterceptorCreators != null) {
            OkHttpClient.Builder clientBuilder = client.newBuilder();
            for (NetworkInterceptorCreator networkInterceptorCreator : networkInterceptorCreators) {
                clientBuilder.addNetworkInterceptor(networkInterceptorCreator.create());
            }
            client = clientBuilder.build();
        }
        this.mClient = client;
        OkHttpClientProvider.replaceOkHttpClient(client);
        this.mCookieHandler = new ForwardingCookieHandler(reactContext);
        this.mCookieJarContainer = (CookieJarContainer)this.mClient.cookieJar();
        this.mShuttingDown = false;
        this.mDefaultUserAgent = defaultUserAgent;
        this.mRequestIds = new HashSet<Integer>();
    }

    NetworkingModule(ReactApplicationContext context, @Nullable String defaultUserAgent, OkHttpClient client) {
        this(context, defaultUserAgent, client, null);
    }

    public NetworkingModule(ReactApplicationContext context) {
        this(context, null, OkHttpClientProvider.getOkHttpClient(), null);
    }

    public NetworkingModule(ReactApplicationContext context, List<NetworkInterceptorCreator> networkInterceptorCreators) {
        this(context, null, OkHttpClientProvider.getOkHttpClient(), networkInterceptorCreators);
    }

    public NetworkingModule(ReactApplicationContext context, String defaultUserAgent) {
        this(context, defaultUserAgent, OkHttpClientProvider.getOkHttpClient(), null);
    }

    @Override
    public void initialize() {
        this.mCookieJarContainer.setCookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)this.mCookieHandler));
    }

    @Override
    public String getName() {
        return "RCTNetworking";
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
        this.cancelAllRequests();
        this.mCookieHandler.destroy();
        this.mCookieJarContainer.removeCookieJar();
    }

    @ReactMethod
    public void sendRequest(ExecutorToken executorToken, String method, String url, final int requestId, ReadableArray headers, ReadableMap data, final boolean useIncrementalUpdates, int timeout) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (requestId != 0) {
            requestBuilder.tag((Object)requestId);
        }
        OkHttpClient client = this.mClient;
        if (timeout != this.mClient.connectTimeoutMillis()) {
            client = this.mClient.newBuilder().readTimeout((long)timeout, TimeUnit.MILLISECONDS).build();
        }
        final DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter = this.getEventEmitter(executorToken);
        Headers requestHeaders = this.extractHeaders(headers, data);
        if (requestHeaders == null) {
            ResponseUtil.onRequestError(eventEmitter, requestId, "Unrecognized headers format", null);
            return;
        }
        String contentType = requestHeaders.get(CONTENT_TYPE_HEADER_NAME);
        String contentEncoding = requestHeaders.get(CONTENT_ENCODING_HEADER_NAME);
        requestBuilder.headers(requestHeaders);
        if (data == null) {
            requestBuilder.method(method, RequestBodyUtil.getEmptyBody(method));
        } else if (data.hasKey(REQUEST_BODY_KEY_STRING)) {
            if (contentType == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Payload is set but no content-type header specified", null);
                return;
            }
            String body = data.getString(REQUEST_BODY_KEY_STRING);
            MediaType contentMediaType = MediaType.parse((String)contentType);
            if (RequestBodyUtil.isGzipEncoding(contentEncoding)) {
                RequestBody requestBody = RequestBodyUtil.createGzip(contentMediaType, body);
                if (requestBody == null) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, "Failed to gzip request body", null);
                    return;
                }
                requestBuilder.method(method, requestBody);
            } else {
                requestBuilder.method(method, RequestBody.create((MediaType)contentMediaType, (String)body));
            }
        } else if (data.hasKey(REQUEST_BODY_KEY_URI)) {
            if (contentType == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Payload is set but no content-type header specified", null);
                return;
            }
            String uri = data.getString(REQUEST_BODY_KEY_URI);
            InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), uri);
            if (fileInputStream == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Could not retrieve file for uri " + uri, null);
                return;
            }
            requestBuilder.method(method, RequestBodyUtil.create(MediaType.parse((String)contentType), fileInputStream));
        } else if (data.hasKey(REQUEST_BODY_KEY_FORMDATA)) {
            ReadableArray parts;
            MultipartBody.Builder multipartBuilder;
            if (contentType == null) {
                contentType = "multipart/form-data";
            }
            if ((multipartBuilder = this.constructMultipartBody(executorToken, parts = data.getArray(REQUEST_BODY_KEY_FORMDATA), contentType, requestId)) == null) {
                return;
            }
            requestBuilder.method(method, (RequestBody)RequestBodyUtil.createProgressRequest((RequestBody)multipartBuilder.build(), new ProgressRequestListener(){
                long last = System.nanoTime();

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    long now = System.nanoTime();
                    if (done || NetworkingModule.shouldDispatch(now, this.last)) {
                        ResponseUtil.onDataSend(eventEmitter, requestId, bytesWritten, contentLength);
                        this.last = now;
                    }
                }
            }));
        } else {
            requestBuilder.method(method, RequestBodyUtil.getEmptyBody(method));
        }
        this.addRequest(requestId);
        client.newCall(requestBuilder.build()).enqueue(new okhttp3.Callback(){

            public void onFailure(Call call, IOException e) {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.removeRequest(requestId);
                ResponseUtil.onRequestError(eventEmitter, requestId, e.getMessage(), e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.removeRequest(requestId);
                ResponseUtil.onResponseReceived(eventEmitter, requestId, response.code(), NetworkingModule.translateHeaders(response.headers()), response.request().url().toString());
                ResponseBody responseBody = response.body();
                try {
                    if (useIncrementalUpdates) {
                        NetworkingModule.this.readWithProgress(eventEmitter, requestId, responseBody);
                        ResponseUtil.onRequestSuccess(eventEmitter, requestId);
                    } else {
                        ResponseUtil.onDataReceived(eventEmitter, requestId, responseBody.string());
                        ResponseUtil.onRequestSuccess(eventEmitter, requestId);
                    }
                }
                catch (IOException e) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, e.getMessage(), e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWithProgress(DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter, int requestId, ResponseBody responseBody) throws IOException {
        try (Reader reader = responseBody.charStream();){
            int read;
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer)) != -1) {
                ResponseUtil.onDataReceived(eventEmitter, requestId, new String(buffer, 0, read));
            }
        }
    }

    private static boolean shouldDispatch(long now, long last) {
        return last + 100000000L < now;
    }

    private synchronized void addRequest(int requestId) {
        this.mRequestIds.add(requestId);
    }

    private synchronized void removeRequest(int requestId) {
        this.mRequestIds.remove(requestId);
    }

    private synchronized void cancelAllRequests() {
        for (Integer requestId : this.mRequestIds) {
            this.cancelRequest(requestId);
        }
        this.mRequestIds.clear();
    }

    private static WritableMap translateHeaders(Headers headers) {
        WritableMap responseHeaders = Arguments.createMap();
        for (int i = 0; i < headers.size(); ++i) {
            String headerName = headers.name(i);
            if (responseHeaders.hasKey(headerName)) {
                responseHeaders.putString(headerName, responseHeaders.getString(headerName) + ", " + headers.value(i));
                continue;
            }
            responseHeaders.putString(headerName, headers.value(i));
        }
        return responseHeaders;
    }

    @ReactMethod
    public void abortRequest(ExecutorToken executorToken, int requestId) {
        this.cancelRequest(requestId);
        this.removeRequest(requestId);
    }

    private void cancelRequest(final int requestId) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                OkHttpCallUtil.cancelTag(NetworkingModule.this.mClient, requestId);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void clearCookies(ExecutorToken executorToken, Callback callback) {
        this.mCookieHandler.clearCookies(callback);
    }

    @Override
    public boolean supportsWebWorkers() {
        return true;
    }

    @Nullable
    private MultipartBody.Builder constructMultipartBody(ExecutorToken ExecutorToken2, ReadableArray body, String contentType, int requestId) {
        DeviceEventManagerModule.RCTDeviceEventEmitter eventEmitter = this.getEventEmitter(ExecutorToken2);
        MultipartBody.Builder multipartBuilder = new MultipartBody.Builder();
        multipartBuilder.setType(MediaType.parse((String)contentType));
        int size = body.size();
        for (int i = 0; i < size; ++i) {
            ReadableMap bodyPart = body.getMap(i);
            ReadableArray headersArray = bodyPart.getArray("headers");
            Headers headers = this.extractHeaders(headersArray, null);
            if (headers == null) {
                ResponseUtil.onRequestError(eventEmitter, requestId, "Missing or invalid header format for FormData part.", null);
                return null;
            }
            MediaType partContentType = null;
            String partContentTypeStr = headers.get(CONTENT_TYPE_HEADER_NAME);
            if (partContentTypeStr != null) {
                partContentType = MediaType.parse((String)partContentTypeStr);
                headers = headers.newBuilder().removeAll(CONTENT_TYPE_HEADER_NAME).build();
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_STRING)) {
                String bodyValue = bodyPart.getString(REQUEST_BODY_KEY_STRING);
                multipartBuilder.addPart(headers, RequestBody.create((MediaType)partContentType, (String)bodyValue));
                continue;
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_URI)) {
                if (partContentType == null) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, "Binary FormData part needs a content-type header.", null);
                    return null;
                }
                String fileContentUriStr = bodyPart.getString(REQUEST_BODY_KEY_URI);
                InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), fileContentUriStr);
                if (fileInputStream == null) {
                    ResponseUtil.onRequestError(eventEmitter, requestId, "Could not retrieve file for uri " + fileContentUriStr, null);
                    return null;
                }
                multipartBuilder.addPart(headers, RequestBodyUtil.create(partContentType, fileInputStream));
                continue;
            }
            ResponseUtil.onRequestError(eventEmitter, requestId, "Unrecognized FormData part.", null);
        }
        return multipartBuilder;
    }

    @Nullable
    private Headers extractHeaders(@Nullable ReadableArray headersArray, @Nullable ReadableMap requestData) {
        boolean isGzipSupported;
        if (headersArray == null) {
            return null;
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headersArray.size();
        for (int headersIdx = 0; headersIdx < size; ++headersIdx) {
            ReadableArray header = headersArray.getArray(headersIdx);
            if (header == null || header.size() != 2) {
                return null;
            }
            String headerName = header.getString(0);
            String headerValue = header.getString(1);
            headersBuilder.add(headerName, headerValue);
        }
        if (headersBuilder.get(USER_AGENT_HEADER_NAME) == null && this.mDefaultUserAgent != null) {
            headersBuilder.add(USER_AGENT_HEADER_NAME, this.mDefaultUserAgent);
        }
        boolean bl = isGzipSupported = requestData != null && requestData.hasKey(REQUEST_BODY_KEY_STRING);
        if (!isGzipSupported) {
            headersBuilder.removeAll(CONTENT_ENCODING_HEADER_NAME);
        }
        return headersBuilder.build();
    }

    private DeviceEventManagerModule.RCTDeviceEventEmitter getEventEmitter(ExecutorToken ExecutorToken2) {
        return this.getReactApplicationContext().getJSModule(ExecutorToken2, DeviceEventManagerModule.RCTDeviceEventEmitter.class);
    }
}

