/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import android.net.Uri;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.network.ProgressRequestBody;
import com.facebook.react.modules.network.ProgressRequestListener;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.ByteString;
import okio.Okio;
import okio.Source;

class RequestBodyUtil {
    private static final String CONTENT_ENCODING_GZIP = "gzip";

    RequestBodyUtil() {
    }

    public static boolean isGzipEncoding(@Nullable String encodingType) {
        return CONTENT_ENCODING_GZIP.equalsIgnoreCase(encodingType);
    }

    @Nullable
    public static InputStream getFileInputStream(Context context, String fileContentUriStr) {
        try {
            Uri fileContentUri = Uri.parse((String)fileContentUriStr);
            return context.getContentResolver().openInputStream(fileContentUri);
        }
        catch (Exception e) {
            FLog.e((String)"React", (String)("Could not retrieve file for contentUri " + fileContentUriStr), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static RequestBody createGzip(MediaType mediaType, String body) {
        ByteArrayOutputStream gzipByteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(gzipByteArrayOutputStream);
            ((OutputStream)gzipOutputStream).write(body.getBytes());
            ((OutputStream)gzipOutputStream).close();
        }
        catch (IOException e) {
            return null;
        }
        return RequestBody.create((MediaType)mediaType, (byte[])gzipByteArrayOutputStream.toByteArray());
    }

    public static RequestBody create(final MediaType mediaType, final InputStream inputStream) {
        return new RequestBody(){

            public MediaType contentType() {
                return mediaType;
            }

            public long contentLength() {
                try {
                    return inputStream.available();
                }
                catch (IOException e) {
                    return 0L;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void writeTo(BufferedSink sink) throws IOException {
                Source source = null;
                try {
                    source = Okio.source((InputStream)inputStream);
                    sink.writeAll(source);
                }
                finally {
                    Util.closeQuietly((Closeable)source);
                }
            }
        };
    }

    public static ProgressRequestBody createProgressRequest(RequestBody requestBody, ProgressRequestListener listener) {
        return new ProgressRequestBody(requestBody, listener);
    }

    public static RequestBody getEmptyBody(String method) {
        if (method.equals("POST") || method.equals("PUT") || method.equals("PATCH")) {
            return RequestBody.create(null, (ByteString)ByteString.EMPTY);
        }
        return null;
    }
}

