/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.view.ReactViewGroup;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ReactModalHostView
extends ViewGroup
implements LifecycleEventListener {
    private DialogRootViewGroup mHostView;
    @Nullable
    private Dialog mDialog;
    private boolean mTransparent;
    private String mAnimationType;
    private boolean mPropertyRequiresNewDialog;
    @Nullable
    private DialogInterface.OnShowListener mOnShowListener;
    @Nullable
    private OnRequestCloseListener mOnRequestCloseListener;

    public ReactModalHostView(Context context) {
        super(context);
        ((ReactContext)context).addLifecycleEventListener(this);
        this.mHostView = new DialogRootViewGroup(context);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public void addView(View child, int index) {
        this.mHostView.addView(child, index);
    }

    public int getChildCount() {
        return this.mHostView.getChildCount();
    }

    public View getChildAt(int index) {
        return this.mHostView.getChildAt(index);
    }

    public void removeView(View child) {
        this.mHostView.removeView(child);
    }

    public void removeViewAt(int index) {
        View child = this.getChildAt(index);
        this.mHostView.removeView(child);
    }

    public void addChildrenForAccessibility(ArrayList<View> outChildren) {
    }

    public void onDropInstance() {
        ((ReactContext)this.getContext()).removeLifecycleEventListener(this);
        this.dismiss();
    }

    private void dismiss() {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
            this.mDialog = null;
            ViewGroup parent = (ViewGroup)this.mHostView.getParent();
            parent.removeViewAt(0);
        }
    }

    protected void setOnRequestCloseListener(OnRequestCloseListener listener) {
        this.mOnRequestCloseListener = listener;
    }

    protected void setOnShowListener(DialogInterface.OnShowListener listener) {
        this.mOnShowListener = listener;
    }

    protected void setTransparent(boolean transparent) {
        this.mTransparent = transparent;
    }

    protected void setAnimationType(String animationType) {
        this.mAnimationType = animationType;
        this.mPropertyRequiresNewDialog = true;
    }

    @Override
    public void onHostResume() {
        this.showOrUpdate();
    }

    @Override
    public void onHostPause() {
        this.dismiss();
    }

    @Override
    public void onHostDestroy() {
        this.onDropInstance();
    }

    @Nullable
    @VisibleForTesting
    public Dialog getDialog() {
        return this.mDialog;
    }

    protected void showOrUpdate() {
        if (this.mDialog != null) {
            if (this.mPropertyRequiresNewDialog) {
                this.dismiss();
            } else {
                this.updateProperties();
                return;
            }
        }
        this.mPropertyRequiresNewDialog = false;
        int theme = R.style.Theme_FullScreenDialog;
        if (this.mAnimationType.equals("fade")) {
            theme = R.style.Theme_FullScreenDialogAnimatedFade;
        } else if (this.mAnimationType.equals("slide")) {
            theme = R.style.Theme_FullScreenDialogAnimatedSlide;
        }
        this.mDialog = new Dialog(this.getContext(), theme);
        this.mDialog.setContentView((View)this.mHostView);
        this.updateProperties();
        this.mDialog.setOnShowListener(this.mOnShowListener);
        this.mDialog.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                if (keyCode == 4) {
                    if (event.getAction() == 1) {
                        Assertions.assertNotNull((Object)ReactModalHostView.this.mOnRequestCloseListener, (String)"setOnRequestCloseListener must be called by the manager");
                        ReactModalHostView.this.mOnRequestCloseListener.onRequestClose(dialog);
                    }
                    return true;
                }
                return false;
            }
        });
        this.mDialog.show();
    }

    private void updateProperties() {
        Assertions.assertNotNull((Object)this.mDialog, (String)"mDialog must exist when we call updateProperties");
        this.mDialog.getWindow().addFlags(0x4000000);
        if (this.mTransparent) {
            this.mDialog.getWindow().clearFlags(2);
        } else {
            this.mDialog.getWindow().setDimAmount(0.5f);
            this.mDialog.getWindow().setFlags(2, 2);
        }
    }

    static class DialogRootViewGroup
    extends ReactViewGroup
    implements RootView {
        private final JSTouchDispatcher mJSTouchDispatcher = new JSTouchDispatcher(this);

        public DialogRootViewGroup(Context context) {
            super(context);
        }

        @Override
        public boolean onInterceptTouchEvent(MotionEvent event) {
            this.mJSTouchDispatcher.handleTouchEvent(event, this.getEventDispatcher());
            return super.onInterceptTouchEvent(event);
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            this.mJSTouchDispatcher.handleTouchEvent(event, this.getEventDispatcher());
            super.onTouchEvent(event);
            return true;
        }

        @Override
        public void onChildStartedNativeGesture(MotionEvent androidEvent) {
            this.mJSTouchDispatcher.onChildStartedNativeGesture(androidEvent, this.getEventDispatcher());
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        private EventDispatcher getEventDispatcher() {
            ReactContext reactContext = (ReactContext)this.getContext();
            return reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }
    }

    public static interface OnRequestCloseListener {
        public void onRequestClose(DialogInterface var1);
    }
}

