/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.swiperefresh;

import android.content.Context;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.MotionEvent;
import android.view.View;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.NativeGestureUtil;

public class ReactSwipeRefreshLayout
extends SwipeRefreshLayout {
    private static final float DEFAULT_CIRCLE_TARGET = 64.0f;
    private boolean mDidLayout = false;
    private boolean mRefreshing = false;
    private float mProgressViewOffset = 0.0f;

    public ReactSwipeRefreshLayout(ReactContext reactContext) {
        super((Context)reactContext);
    }

    public void setRefreshing(boolean refreshing) {
        this.mRefreshing = refreshing;
        if (this.mDidLayout) {
            super.setRefreshing(refreshing);
        }
    }

    public void setProgressViewOffset(float offset) {
        this.mProgressViewOffset = offset;
        if (this.mDidLayout) {
            int diameter = this.getProgressCircleDiameter();
            int start = Math.round(PixelUtil.toPixelFromDIP(offset)) - diameter;
            int end = Math.round(PixelUtil.toPixelFromDIP(offset + 64.0f) - (float)diameter);
            this.setProgressViewOffset(false, start, end);
        }
    }

    public void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (!this.mDidLayout) {
            this.mDidLayout = true;
            this.setProgressViewOffset(this.mProgressViewOffset);
            this.setRefreshing(this.mRefreshing);
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            return true;
        }
        return false;
    }
}

