/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.text.BoringLayout;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import com.facebook.csslayout.CSSConstants;
import com.facebook.csslayout.CSSMeasureMode;
import com.facebook.csslayout.CSSNode;
import com.facebook.csslayout.MeasureOutput;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.UIViewOperationQueue;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.CustomStyleSpan;
import com.facebook.react.views.text.ReactTagSpan;
import com.facebook.react.views.text.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.ShadowStyleSpan;
import com.facebook.react.views.text.TextInlineImageSpan;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class ReactTextShadowNode
extends LayoutShadowNode {
    private static final String INLINE_IMAGE_PLACEHOLDER = "I";
    public static final int UNSET = -1;
    @VisibleForTesting
    public static final String PROP_TEXT = "text";
    public static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    public static final String PROP_SHADOW_OFFSET_WIDTH = "width";
    public static final String PROP_SHADOW_OFFSET_HEIGHT = "height";
    public static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    public static final String PROP_SHADOW_COLOR = "textShadowColor";
    public static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    private static final TextPaint sTextPaintInstance = new TextPaint();
    private static final CSSNode.MeasureFunction TEXT_MEASURE_FUNCTION;
    private int mLineHeight = -1;
    private boolean mIsColorSet = false;
    private int mColor;
    private boolean mIsBackgroundColorSet = false;
    private int mBackgroundColor;
    protected int mNumberOfLines = -1;
    protected int mFontSize = -1;
    private float mTextShadowOffsetDx = 0.0f;
    private float mTextShadowOffsetDy = 0.0f;
    private float mTextShadowRadius = 1.0f;
    private int mTextShadowColor = 0x55000000;
    private boolean mIsUnderlineTextDecorationSet = false;
    private boolean mIsLineThroughTextDecorationSet = false;
    private int mFontStyle = -1;
    private int mFontWeight = -1;
    @Nullable
    private String mFontFamily = null;
    @Nullable
    private String mText = null;
    @Nullable
    private Spannable mPreparedSpannableText;
    private final boolean mIsVirtual;
    protected boolean mContainsImages = false;

    private static void buildSpannedFromTextCSSNode(ReactTextShadowNode textCSSNode, SpannableStringBuilder sb, List<SetSpanOperation> ops) {
        int start = sb.length();
        if (textCSSNode.mText != null) {
            sb.append((CharSequence)textCSSNode.mText);
        }
        int length = textCSSNode.getChildCount();
        for (int i = 0; i < length; ++i) {
            ReactShadowNode child = textCSSNode.getChildAt(i);
            if (child instanceof ReactTextShadowNode) {
                ReactTextShadowNode.buildSpannedFromTextCSSNode((ReactTextShadowNode)child, sb, ops);
            } else if (child instanceof ReactTextInlineImageShadowNode) {
                sb.append((CharSequence)INLINE_IMAGE_PLACEHOLDER);
                ops.add(new SetSpanOperation(sb.length() - INLINE_IMAGE_PLACEHOLDER.length(), sb.length(), (Object)((ReactTextInlineImageShadowNode)child).buildInlineImageSpan()));
            } else {
                throw new IllegalViewOperationException("Unexpected view type nested under text node: " + child.getClass());
            }
            child.markUpdateSeen();
        }
        int end = sb.length();
        if (end >= start) {
            if (textCSSNode.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ForegroundColorSpan(textCSSNode.mColor)));
            }
            if (textCSSNode.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new BackgroundColorSpan(textCSSNode.mBackgroundColor)));
            }
            if (textCSSNode.mFontSize != -1) {
                ops.add(new SetSpanOperation(start, end, new AbsoluteSizeSpan(textCSSNode.mFontSize)));
            }
            if (textCSSNode.mFontStyle != -1 || textCSSNode.mFontWeight != -1 || textCSSNode.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, (Object)new CustomStyleSpan(textCSSNode.mFontStyle, textCSSNode.mFontWeight, textCSSNode.mFontFamily, textCSSNode.getThemedContext().getAssets())));
            }
            if (textCSSNode.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new UnderlineSpan()));
            }
            if (textCSSNode.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new StrikethroughSpan()));
            }
            if (textCSSNode.mTextShadowOffsetDx != 0.0f || textCSSNode.mTextShadowOffsetDy != 0.0f) {
                ops.add(new SetSpanOperation(start, end, (Object)new ShadowStyleSpan(textCSSNode.mTextShadowOffsetDx, textCSSNode.mTextShadowOffsetDy, textCSSNode.mTextShadowRadius, textCSSNode.mTextShadowColor)));
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(textCSSNode.getReactTag())));
        }
    }

    protected static Spannable fromTextCSSNode(ReactTextShadowNode textCSSNode) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        ReactTextShadowNode.buildSpannedFromTextCSSNode(textCSSNode, sb, ops);
        if (textCSSNode.mFontSize == -1) {
            sb.setSpan((Object)new AbsoluteSizeSpan((int)Math.ceil(PixelUtil.toPixelFromSP(14.0f))), 0, sb.length(), 17);
        }
        textCSSNode.mContainsImages = false;
        for (int i = ops.size() - 1; i >= 0; --i) {
            SetSpanOperation op = (SetSpanOperation)ops.get(i);
            if (op.what instanceof TextInlineImageSpan) {
                textCSSNode.mContainsImages = true;
            }
            op.execute(sb);
        }
        return sb;
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    public ReactTextShadowNode(boolean isVirtual) {
        this.mIsVirtual = isVirtual;
        if (!isVirtual) {
            this.setMeasureFunction(TEXT_MEASURE_FUNCTION);
        }
    }

    @Override
    public void onBeforeLayout() {
        if (this.mIsVirtual) {
            return;
        }
        this.mPreparedSpannableText = ReactTextShadowNode.fromTextCSSNode(this);
        this.markUpdated();
    }

    @Override
    protected void markUpdated() {
        super.markUpdated();
        if (!this.mIsVirtual) {
            super.dirty();
        }
    }

    @ReactProp(name="text")
    public void setText(@Nullable String text) {
        this.mText = text;
        this.markUpdated();
    }

    @ReactProp(name="numberOfLines", defaultInt=-1)
    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines;
        this.markUpdated();
    }

    @ReactProp(name="lineHeight", defaultInt=-1)
    public void setLineHeight(int lineHeight) {
        this.mLineHeight = lineHeight;
        this.markUpdated();
    }

    @ReactProp(name="fontSize", defaultFloat=-1.0f)
    public void setFontSize(float fontSize) {
        if (fontSize != -1.0f) {
            fontSize = (float)Math.ceil(PixelUtil.toPixelFromSP(fontSize));
        }
        this.mFontSize = (int)fontSize;
        this.markUpdated();
    }

    @ReactProp(name="color")
    public void setColor(@Nullable Integer color) {
        boolean bl = this.mIsColorSet = color != null;
        if (this.mIsColorSet) {
            this.mColor = color;
        }
        this.markUpdated();
    }

    @ReactProp(name="backgroundColor")
    public void setBackgroundColor(Integer color) {
        if (!this.isVirtualAnchor()) {
            boolean bl = this.mIsBackgroundColorSet = color != null;
            if (this.mIsBackgroundColorSet) {
                this.mBackgroundColor = color;
            }
            this.markUpdated();
        }
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(@Nullable String fontFamily) {
        this.mFontFamily = fontFamily;
        this.markUpdated();
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(@Nullable String fontWeightString) {
        int fontWeightNumeric = fontWeightString != null ? ReactTextShadowNode.parseNumericFontWeight(fontWeightString) : -1;
        int fontWeight = -1;
        if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
            fontWeight = 0;
        }
        if (fontWeight != this.mFontWeight) {
            this.mFontWeight = fontWeight;
            this.markUpdated();
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        if (fontStyle != this.mFontStyle) {
            this.mFontStyle = fontStyle;
            this.markUpdated();
        }
    }

    @ReactProp(name="textDecorationLine")
    public void setTextDecorationLine(@Nullable String textDecorationLineString) {
        this.mIsUnderlineTextDecorationSet = false;
        this.mIsLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split(" ")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    this.mIsUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"line-through".equals(textDecorationLineSubString)) continue;
                this.mIsLineThroughTextDecorationSet = true;
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowOffset")
    public void setTextShadowOffset(ReadableMap offsetMap) {
        this.mTextShadowOffsetDx = 0.0f;
        this.mTextShadowOffsetDy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_WIDTH) && !offsetMap.isNull(PROP_SHADOW_OFFSET_WIDTH)) {
                this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_WIDTH));
            }
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_HEIGHT) && !offsetMap.isNull(PROP_SHADOW_OFFSET_HEIGHT)) {
                this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_HEIGHT));
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowRadius", defaultInt=1)
    public void setTextShadowRadius(float textShadowRadius) {
        if (textShadowRadius != this.mTextShadowRadius) {
            this.mTextShadowRadius = textShadowRadius;
            this.markUpdated();
        }
    }

    @ReactProp(name="textShadowColor", defaultInt=0x55000000, customType="Color")
    public void setTextShadowColor(int textShadowColor) {
        if (textShadowColor != this.mTextShadowColor) {
            this.mTextShadowColor = textShadowColor;
            this.markUpdated();
        }
    }

    @Override
    public boolean isVirtualAnchor() {
        return !this.mIsVirtual;
    }

    @Override
    public boolean isVirtual() {
        return this.mIsVirtual;
    }

    @Override
    public void onCollectExtraUpdates(UIViewOperationQueue uiViewOperationQueue) {
        if (this.mIsVirtual) {
            return;
        }
        super.onCollectExtraUpdates(uiViewOperationQueue);
        if (this.mPreparedSpannableText != null) {
            ReactTextUpdate reactTextUpdate = new ReactTextUpdate(this.mPreparedSpannableText, -1, this.mContainsImages);
            uiViewOperationQueue.enqueueUpdateExtraData(this.getReactTag(), reactTextUpdate);
        }
    }

    static {
        sTextPaintInstance.setFlags(1);
        TEXT_MEASURE_FUNCTION = new CSSNode.MeasureFunction(){

            @Override
            public void measure(CSSNode node, float width, CSSMeasureMode widthMode, float height, CSSMeasureMode heightMode, MeasureOutput measureOutput) {
                boolean unconstrainedWidth;
                ReactTextShadowNode reactCSSNode = (ReactTextShadowNode)node;
                TextPaint textPaint = sTextPaintInstance;
                Spanned text = (Spanned)Assertions.assertNotNull((Object)reactCSSNode.mPreparedSpannableText, (String)"Spannable element has not been prepared in onBeforeLayout");
                BoringLayout.Metrics boring = BoringLayout.isBoring((CharSequence)text, (TextPaint)textPaint);
                float desiredWidth = boring == null ? Layout.getDesiredWidth((CharSequence)text, (TextPaint)textPaint) : Float.NaN;
                boolean bl = unconstrainedWidth = widthMode == CSSMeasureMode.UNDEFINED || width < 0.0f;
                Object layout2 = boring == null && (unconstrainedWidth || !CSSConstants.isUndefined(desiredWidth) && desiredWidth <= width) ? new StaticLayout((CharSequence)text, textPaint, (int)Math.ceil(desiredWidth), Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true) : (boring != null && (unconstrainedWidth || (float)boring.width <= width) ? BoringLayout.make((CharSequence)text, (TextPaint)textPaint, (int)boring.width, (Layout.Alignment)Layout.Alignment.ALIGN_NORMAL, (float)1.0f, (float)0.0f, (BoringLayout.Metrics)boring, (boolean)true) : new StaticLayout((CharSequence)text, textPaint, (int)width, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, true));
                measureOutput.height = layout2.getHeight();
                measureOutput.width = layout2.getWidth();
                if (reactCSSNode.mNumberOfLines != -1 && reactCSSNode.mNumberOfLines < layout2.getLineCount()) {
                    measureOutput.height = layout2.getLineBottom(reactCSSNode.mNumberOfLines - 1);
                }
                if (reactCSSNode.mLineHeight != -1) {
                    int lines = reactCSSNode.mNumberOfLines != -1 ? Math.min(reactCSSNode.mNumberOfLines, layout2.getLineCount()) : layout2.getLineCount();
                    float lineHeight = PixelUtil.toPixelFromSP(reactCSSNode.mLineHeight);
                    measureOutput.height = lineHeight * (float)lines;
                }
            }
        };
    }

    private static class SetSpanOperation {
        protected int start;
        protected int end;
        protected Object what;

        SetSpanOperation(int start, int end, Object what) {
            this.start = start;
            this.end = end;
            this.what = what;
        }

        public void execute(SpannableStringBuilder sb) {
            int spanFlags = 34;
            if (this.start == 0) {
                spanFlags = 18;
            }
            sb.setSpan(this.what, this.start, this.end, spanFlags);
        }
    }
}

