/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.common.SystemClock;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.ReactTextUpdate;
import com.facebook.react.views.text.TextInlineImageSpan;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import com.facebook.react.views.textinput.ReactTextInputBlurEvent;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputEvent;
import com.facebook.react.views.textinput.ReactTextInputFocusEvent;
import com.facebook.react.views.textinput.ReactTextInputSelectionEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.SelectionWatcher;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactTextInputManager
extends BaseViewManager<ReactEditText, LayoutShadowNode> {
    static final String REACT_CLASS = "AndroidTextInput";
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    private static final int INPUT_TYPE_KEYBOARD_NUMBERED = 12290;
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";
    private static final String KEYBOARD_TYPE_PHONE_PAD = "phone-pad";
    private static final InputFilter[] EMPTY_FILTERS = new InputFilter[0];
    private static final int UNSET = -1;
    private static final int IME_ACTION_ID = 1648;

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactEditText createViewInstance(ThemedReactContext context) {
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setImeOptions(6);
        editText.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(14.0f)));
        return editText;
    }

    @Override
    public LayoutShadowNode createShadowNodeInstance() {
        return new ReactTextInputShadowNode();
    }

    @Override
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return ReactTextInputShadowNode.class;
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topSubmitEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSubmitEditing", "captured", "onSubmitEditingCapture"))).put("topEndEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onEndEditing", "captured", "onEndEditingCapture"))).put("topTextInput", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTextInput", "captured", "onTextInputCapture"))).put("topFocus", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onFocus", "captured", "onFocusCapture"))).put("topBlur", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onBlur", "captured", "onBlurCapture"))).build();
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("focusTextInput", 1, "blurTextInput", 2);
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                reactEditText.requestFocusFromJS();
                break;
            }
            case 2: {
                reactEditText.clearFocusFromJS();
            }
        }
    }

    @Override
    public void updateExtraData(ReactEditText view, Object extraData) {
        if (extraData instanceof float[]) {
            float[] padding = (float[])extraData;
            view.setPadding((int)Math.ceil(padding[0]), (int)Math.ceil(padding[1]), (int)Math.ceil(padding[2]), (int)Math.ceil(padding[3]));
        } else if (extraData instanceof ReactTextUpdate) {
            ReactTextUpdate update = (ReactTextUpdate)extraData;
            if (update.containsImages()) {
                Spannable spannable = update.getText();
                TextInlineImageSpan.possiblyUpdateInlineImageSpans(spannable, (TextView)view);
            }
            view.maybeSetText(update);
        }
    }

    @ReactProp(name="fontSize", defaultFloat=14.0f)
    public void setFontSize(ReactEditText view, float fontSize) {
        view.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(fontSize)));
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(ReactEditText view, String fontFamily) {
        int style2 = 0;
        if (view.getTypeface() != null) {
            style2 = view.getTypeface().getStyle();
        }
        Typeface newTypeface = Typeface.create((String)fontFamily, (int)style2);
        view.setTypeface(newTypeface);
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(ReactEditText view, @Nullable String fontWeightString) {
        int fontWeightNumeric = fontWeightString != null ? ReactTextInputManager.parseNumericFontWeight(fontWeightString) : -1;
        int fontWeight = -1;
        if (fontWeightNumeric >= 500 || "bold".equals(fontWeightString)) {
            fontWeight = 1;
        } else if ("normal".equals(fontWeightString) || fontWeightNumeric != -1 && fontWeightNumeric < 500) {
            fontWeight = 0;
        }
        Typeface currentTypeface = view.getTypeface();
        if (currentTypeface == null) {
            currentTypeface = Typeface.DEFAULT;
        }
        if (fontWeight != currentTypeface.getStyle()) {
            view.setTypeface(currentTypeface, fontWeight);
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(ReactEditText view, @Nullable String fontStyleString) {
        int fontStyle = -1;
        if ("italic".equals(fontStyleString)) {
            fontStyle = 2;
        } else if ("normal".equals(fontStyleString)) {
            fontStyle = 0;
        }
        Typeface currentTypeface = view.getTypeface();
        if (currentTypeface == null) {
            currentTypeface = Typeface.DEFAULT;
        }
        if (fontStyle != currentTypeface.getStyle()) {
            view.setTypeface(currentTypeface, fontStyle);
        }
    }

    @ReactProp(name="onSelectionChange", defaultBoolean=false)
    public void setOnSelectionChange(ReactEditText view, boolean onSelectionChange) {
        if (onSelectionChange) {
            view.setSelectionWatcher(new ReactSelectionWatcher(view));
        } else {
            view.setSelectionWatcher(null);
        }
    }

    @ReactProp(name="blurOnSubmit", defaultBoolean=true)
    public void setBlurOnSubmit(ReactEditText view, boolean blurOnSubmit) {
        view.setBlurOnSubmit(blurOnSubmit);
    }

    @ReactProp(name="placeholder")
    public void setPlaceholder(ReactEditText view, @Nullable String placeholder) {
        view.setHint(placeholder);
    }

    @ReactProp(name="placeholderTextColor", customType="Color")
    public void setPlaceholderTextColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(view.getContext()));
        } else {
            view.setHintTextColor(color);
        }
    }

    @ReactProp(name="selectionColor", customType="Color")
    public void setSelectionColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setHighlightColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(view.getContext()));
        } else {
            view.setHighlightColor(color);
        }
    }

    @ReactProp(name="selectTextOnFocus", defaultBoolean=false)
    public void setSelectTextOnFocus(ReactEditText view, boolean selectTextOnFocus) {
        view.setSelectAllOnFocus(selectTextOnFocus);
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(ReactEditText view, @Nullable Integer color) {
        if (color == null) {
            view.setTextColor(DefaultStyleValuesUtil.getDefaultTextColor(view.getContext()));
        } else {
            view.setTextColor(color);
        }
    }

    @ReactProp(name="underlineColorAndroid", customType="Color")
    public void setUnderlineColor(ReactEditText view, @Nullable Integer underlineColor) {
        if (underlineColor == null) {
            view.getBackground().clearColorFilter();
        } else {
            view.getBackground().setColorFilter(underlineColor.intValue(), PorterDuff.Mode.SRC_IN);
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(ReactEditText view, @Nullable String textAlign) {
        if (textAlign == null || "auto".equals(textAlign)) {
            view.setGravityHorizontal(0);
        } else if ("left".equals(textAlign)) {
            view.setGravityHorizontal(3);
        } else if ("right".equals(textAlign)) {
            view.setGravityHorizontal(5);
        } else if ("center".equals(textAlign)) {
            view.setGravityHorizontal(1);
        } else if ("justify".equals(textAlign)) {
            view.setGravityHorizontal(3);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
        }
    }

    @ReactProp(name="textAlignVertical")
    public void setTextAlignVertical(ReactEditText view, @Nullable String textAlignVertical) {
        if (textAlignVertical == null || "auto".equals(textAlignVertical)) {
            view.setGravityVertical(0);
        } else if ("top".equals(textAlignVertical)) {
            view.setGravityVertical(48);
        } else if ("bottom".equals(textAlignVertical)) {
            view.setGravityVertical(80);
        } else if ("center".equals(textAlignVertical)) {
            view.setGravityVertical(16);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlignVertical: " + textAlignVertical);
        }
    }

    @ReactProp(name="editable", defaultBoolean=true)
    public void setEditable(ReactEditText view, boolean editable) {
        view.setEnabled(editable);
    }

    @ReactProp(name="numberOfLines", defaultInt=1)
    public void setNumLines(ReactEditText view, int numLines) {
        view.setLines(numLines);
    }

    @ReactProp(name="maxLength")
    public void setMaxLength(ReactEditText view, @Nullable Integer maxLength) {
        InputFilter[] currentFilters = view.getFilters();
        InputFilter[] newFilters = EMPTY_FILTERS;
        if (maxLength == null) {
            if (currentFilters.length > 0) {
                LinkedList<InputFilter> list = new LinkedList<InputFilter>();
                for (int i = 0; i < currentFilters.length; ++i) {
                    if (currentFilters[i] instanceof InputFilter.LengthFilter) continue;
                    list.add(currentFilters[i]);
                }
                if (!list.isEmpty()) {
                    newFilters = list.toArray(new InputFilter[list.size()]);
                }
            }
        } else if (currentFilters.length > 0) {
            newFilters = currentFilters;
            boolean replaced = false;
            for (int i = 0; i < currentFilters.length; ++i) {
                if (!(currentFilters[i] instanceof InputFilter.LengthFilter)) continue;
                currentFilters[i] = new InputFilter.LengthFilter(maxLength.intValue());
                replaced = true;
            }
            if (!replaced) {
                newFilters = new InputFilter[currentFilters.length + 1];
                System.arraycopy(currentFilters, 0, newFilters, 0, currentFilters.length);
                currentFilters[currentFilters.length] = new InputFilter.LengthFilter(maxLength.intValue());
            }
        } else {
            newFilters = new InputFilter[]{new InputFilter.LengthFilter(maxLength.intValue())};
        }
        view.setFilters(newFilters);
    }

    @ReactProp(name="autoCorrect")
    public void setAutoCorrect(ReactEditText view, @Nullable Boolean autoCorrect) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 557056, autoCorrect != null ? (autoCorrect.booleanValue() ? 32768 : 524288) : 0);
    }

    @ReactProp(name="multiline", defaultBoolean=false)
    public void setMultiline(ReactEditText view, boolean multiline) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, multiline ? 0 : 131072, multiline ? 131072 : 0);
    }

    @ReactProp(name="secureTextEntry", defaultBoolean=false)
    public void setSecureTextEntry(ReactEditText view, boolean password) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, password ? 0 : 144, password ? 128 : 0);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="autoCapitalize")
    public void setAutoCapitalize(ReactEditText view, int autoCapitalize) {
        ReactTextInputManager.updateStagedInputTypeFlag(view, 28672, autoCapitalize);
    }

    @ReactProp(name="keyboardType")
    public void setKeyboardType(ReactEditText view, @Nullable String keyboardType) {
        int flagsToSet = 1;
        if (KEYBOARD_TYPE_NUMERIC.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 12290;
        } else if (KEYBOARD_TYPE_EMAIL_ADDRESS.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 33;
        } else if (KEYBOARD_TYPE_PHONE_PAD.equalsIgnoreCase(keyboardType)) {
            flagsToSet = 3;
        }
        ReactTextInputManager.updateStagedInputTypeFlag(view, 12323, flagsToSet);
        ReactTextInputManager.checkPasswordType(view);
    }

    @ReactProp(name="returnKeyType")
    public void setReturnKeyType(ReactEditText view, String returnKeyType) {
        switch (returnKeyType) {
            case "done": {
                view.setImeOptions(6);
                break;
            }
            case "go": {
                view.setImeOptions(2);
                break;
            }
            case "next": {
                view.setImeOptions(5);
                break;
            }
            case "none": {
                view.setImeOptions(1);
                break;
            }
            case "previous": {
                view.setImeOptions(7);
                break;
            }
            case "search": {
                view.setImeOptions(3);
                break;
            }
            case "send": {
                view.setImeOptions(4);
            }
        }
    }

    @ReactProp(name="returnKeyLabel")
    public void setReturnKeyLabel(ReactEditText view, String returnKeyLabel) {
        view.setImeActionLabel(returnKeyLabel, 1648);
    }

    @Override
    protected void onAfterUpdateTransaction(ReactEditText view) {
        super.onAfterUpdateTransaction(view);
        view.commitStagedInputType();
    }

    private static void checkPasswordType(ReactEditText view) {
        if ((view.getStagedInputType() & 0x3002) != 0 && (view.getStagedInputType() & 0x80) != 0) {
            ReactTextInputManager.updateStagedInputTypeFlag(view, 128, 16);
        }
    }

    private static int parseNumericFontWeight(String fontWeightString) {
        return fontWeightString.length() == 3 && fontWeightString.endsWith("00") && fontWeightString.charAt(0) <= '9' && fontWeightString.charAt(0) >= '1' ? 100 * (fontWeightString.charAt(0) - 48) : -1;
    }

    private static void updateStagedInputTypeFlag(ReactEditText view, int flagsToUnset, int flagsToSet) {
        view.setStagedInputType(view.getStagedInputType() & ~flagsToUnset | flagsToSet);
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactEditText editText) {
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                if (hasFocus) {
                    eventDispatcher.dispatchEvent(new ReactTextInputFocusEvent(editText.getId(), SystemClock.nanoTime()));
                } else {
                    eventDispatcher.dispatchEvent(new ReactTextInputBlurEvent(editText.getId(), SystemClock.nanoTime()));
                    eventDispatcher.dispatchEvent(new ReactTextInputEndEditingEvent(editText.getId(), SystemClock.nanoTime(), editText.getText().toString()));
                }
            }
        });
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent keyEvent) {
                if ((actionId & 0xFF) > 0 || actionId == 0) {
                    EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                    eventDispatcher.dispatchEvent(new ReactTextInputSubmitEditingEvent(editText.getId(), SystemClock.nanoTime(), editText.getText().toString()));
                }
                if (actionId == 5 || actionId == 7) {
                    if (editText.getBlurOnSubmit()) {
                        editText.clearFocus();
                    }
                    return true;
                }
                return !editText.getBlurOnSubmit();
            }
        });
    }

    @Override
    @Nullable
    public Map getExportedViewConstants() {
        return MapBuilder.of("AutoCapitalizationType", MapBuilder.of("none", 0, "characters", 4096, "words", 8192, "sentences", 16384));
    }

    private class ReactSelectionWatcher
    implements SelectionWatcher {
        private ReactEditText mReactEditText;
        private EventDispatcher mEventDispatcher;
        private int mPreviousSelectionStart;
        private int mPreviousSelectionEnd;

        public ReactSelectionWatcher(ReactEditText editText) {
            this.mReactEditText = editText;
            ReactContext reactContext = (ReactContext)editText.getContext();
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
        }

        @Override
        public void onSelectionChanged(int start, int end) {
            if (this.mPreviousSelectionStart != start || this.mPreviousSelectionEnd != end) {
                this.mEventDispatcher.dispatchEvent(new ReactTextInputSelectionEvent(this.mReactEditText.getId(), SystemClock.nanoTime(), start, end));
                this.mPreviousSelectionStart = start;
                this.mPreviousSelectionEnd = end;
            }
        }
    }

    private class ReactTextInputTextWatcher
    implements TextWatcher {
        private EventDispatcher mEventDispatcher;
        private ReactEditText mEditText;
        private String mPreviousText;

        public ReactTextInputTextWatcher(ReactContext reactContext, ReactEditText editText) {
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            this.mEditText = editText;
            this.mPreviousText = null;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.mPreviousText = s.toString();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count == 0 && before == 0) {
                return;
            }
            Assertions.assertNotNull((Object)this.mPreviousText);
            String newText = s.toString().substring(start, start + count);
            String oldText = this.mPreviousText.substring(start, start + before);
            if (count == before && newText.equals(oldText)) {
                return;
            }
            int contentWidth = this.mEditText.getWidth();
            int contentHeight = this.mEditText.getHeight();
            if (this.mEditText.getLayout() != null) {
                contentWidth = this.mEditText.getCompoundPaddingLeft() + this.mEditText.getLayout().getWidth() + this.mEditText.getCompoundPaddingRight();
                contentHeight = this.mEditText.getCompoundPaddingTop() + this.mEditText.getLayout().getHeight() + this.mEditText.getCompoundPaddingTop();
            }
            this.mEventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.mEditText.getId(), SystemClock.nanoTime(), s.toString(), (int)PixelUtil.toDIPFromPixel(contentWidth), (int)PixelUtil.toDIPFromPixel(contentHeight), this.mEditText.incrementAndGetEventCounter()));
            this.mEventDispatcher.dispatchEvent(new ReactTextInputEvent(this.mEditText.getId(), SystemClock.nanoTime(), newText, oldText, start, start + before));
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

