/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.amap.api.mapcore.util.dp;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBoundsCreator;
import com.amap.api.maps.model.RuntimeRemoteException;

public final class LatLngBounds
implements Parcelable {
    public static final LatLngBoundsCreator CREATOR = new LatLngBoundsCreator();
    private final int a;
    public final LatLng southwest;
    public final LatLng northeast;

    LatLngBounds(int n2, LatLng latLng, LatLng latLng2) {
        boolean bl2 = true;
        try {
            if (latLng == null) {
                throw new RuntimeRemoteException("null southwest");
            }
            if (latLng2 == null) {
                throw new RuntimeRemoteException("null northeast");
            }
            if (latLng2.latitude < latLng.latitude) {
                throw new RuntimeRemoteException("southern latitude exceeds northern latitude (" + latLng.latitude + " > " + latLng2.latitude + ")");
            }
        }
        catch (Throwable throwable) {
            Log.e((String)"LatLngBounds", (String)"the structure parameters are illegal!");
            throwable.printStackTrace();
            bl2 = false;
        }
        this.a = bl2 ? n2 : 0;
        this.southwest = bl2 ? latLng : null;
        this.northeast = bl2 ? latLng2 : null;
    }

    public LatLngBounds(LatLng latLng, LatLng latLng2) {
        this(1, latLng, latLng2);
    }

    int a() {
        return this.a;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean contains(LatLng latLng) {
        if (latLng == null) {
            return false;
        }
        if (this.northeast == null || this.southwest == null) {
            Log.e((String)"LatLngBounds", (String)"current LatLngBounds is invalid, please check the structure parameters are legal");
            return false;
        }
        LatLng latLng2 = latLng;
        return this.a(latLng2.latitude) && this.b(latLng2.longitude);
    }

    public boolean contains(LatLngBounds latLngBounds) {
        boolean bl2 = false;
        if (latLngBounds == null) {
            return bl2;
        }
        if (this.contains(latLngBounds.southwest) && this.contains(latLngBounds.northeast)) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean intersects(LatLngBounds latLngBounds) {
        if (latLngBounds == null) {
            return false;
        }
        if (this.northeast == null || this.southwest == null) {
            Log.e((String)"LatLngBounds", (String)"current LatLngBounds is invalid, please check the structure parameters are legal");
            return false;
        }
        return this.a(latLngBounds) || latLngBounds.a(this);
    }

    private boolean a(LatLngBounds latLngBounds) {
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null) {
            return false;
        }
        double d2 = latLngBounds.northeast.longitude + latLngBounds.southwest.longitude - this.northeast.longitude - this.southwest.longitude;
        double d3 = this.northeast.longitude - this.southwest.longitude + latLngBounds.northeast.longitude - this.southwest.longitude;
        double d4 = latLngBounds.northeast.latitude + latLngBounds.southwest.latitude - this.northeast.latitude - this.southwest.latitude;
        double d5 = this.northeast.latitude - this.southwest.latitude + latLngBounds.northeast.latitude - latLngBounds.southwest.latitude;
        return Math.abs(d2) < d3 && Math.abs(d4) < d5;
    }

    public LatLngBounds including(LatLng latLng) {
        if (latLng == null) {
            return this;
        }
        if (this.northeast == null || this.southwest == null) {
            Log.e((String)"LatLngBounds", (String)"current LatLngBounds is invalid, please check the structure parameters are legal");
            return this;
        }
        double d2 = Math.min(this.southwest.latitude, latLng.latitude);
        double d3 = Math.max(this.northeast.latitude, latLng.latitude);
        double d4 = this.northeast.longitude;
        double d5 = this.southwest.longitude;
        double d6 = latLng.longitude;
        if (!this.b(d6)) {
            if (LatLngBounds.c(d5, d6) < LatLngBounds.d(d4, d6)) {
                d5 = d6;
            } else {
                d4 = d6;
            }
        }
        try {
            return new LatLngBounds(new LatLng(d2, d5, false), new LatLng(d3, d4, false));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this;
        }
    }

    private static double c(double d2, double d3) {
        return (d2 - d3 + 360.0) % 360.0;
    }

    private static double d(double d2, double d3) {
        return (d3 - d2 + 360.0) % 360.0;
    }

    private boolean a(double d2) {
        return this.southwest.latitude <= d2 && d2 <= this.northeast.latitude;
    }

    private boolean b(double d2) {
        if (this.southwest.longitude <= this.northeast.longitude) {
            return this.southwest.longitude <= d2 && d2 <= this.northeast.longitude;
        }
        return this.southwest.longitude <= d2 || d2 <= this.northeast.longitude;
    }

    public int hashCode() {
        return dp.a(new Object[]{this.southwest, this.northeast});
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LatLngBounds)) {
            return false;
        }
        LatLngBounds latLngBounds = (LatLngBounds)object;
        return this.southwest.equals(latLngBounds.southwest) && this.northeast.equals(latLngBounds.northeast);
    }

    public String toString() {
        return dp.a(dp.a("southwest", this.southwest), dp.a("northeast", this.northeast));
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n2) {
        LatLngBoundsCreator.a(this, parcel, n2);
    }

    public static final class Builder {
        private double a = Double.POSITIVE_INFINITY;
        private double b = Double.NEGATIVE_INFINITY;
        private double c = Double.NaN;
        private double d = Double.NaN;

        public Builder include(LatLng latLng) {
            if (latLng == null) {
                return this;
            }
            this.a = Math.min(this.a, latLng.latitude);
            this.b = Math.max(this.b, latLng.latitude);
            double d2 = latLng.longitude;
            if (Double.isNaN(this.c)) {
                this.c = d2;
                this.d = d2;
            } else if (!this.a(d2)) {
                if (LatLngBounds.c(this.c, d2) < LatLngBounds.d(this.d, d2)) {
                    this.c = d2;
                } else {
                    this.d = d2;
                }
            }
            return this;
        }

        private boolean a(double d2) {
            if (this.c <= this.d) {
                return this.c <= d2 && d2 <= this.d;
            }
            return this.c <= d2 || d2 <= this.d;
        }

        public LatLngBounds build() {
            if (Double.isNaN(this.c)) {
                Log.w((String)"LatLngBounds", (String)"no included points");
                return null;
            }
            if (this.c > this.d) {
                double d2 = this.c;
                this.c = this.d;
                this.d = d2;
            }
            if (this.a > this.b) {
                double d3 = this.a;
                this.a = this.b;
                this.b = d3;
            }
            return new LatLngBounds(new LatLng(this.a, this.c, false), new LatLng(this.b, this.d, false));
        }
    }
}

