/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.utils;

import android.util.Pair;
import com.amap.api.maps.model.LatLng;
import com.autonavi.amap.mapcore.DPoint;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpatialRelationUtil {
    public static Pair<Integer, LatLng> calShortestDistancePoint(List<LatLng> list, LatLng latLng) {
        if (list == null || latLng == null || list.size() == 0) {
            return null;
        }
        ArrayList<DPoint> arrayList = new ArrayList<DPoint>();
        int n2 = 0;
        for (LatLng pair2 : list) {
            arrayList.add(new DPoint(pair2.latitude, pair2.longitude));
            if (pair2.equals(latLng)) {
                return new Pair((Object)n2, (Object)latLng);
            }
            ++n2;
        }
        DPoint dPoint = new DPoint(latLng.latitude, latLng.longitude);
        Pair<Integer, DPoint> pair = SpatialRelationUtil.calShortestDistancePoint(arrayList, dPoint);
        if (pair != null) {
            return new Pair(pair.first, (Object)new LatLng(((DPoint)pair.second).x, ((DPoint)pair.second).y));
        }
        return null;
    }

    public static Pair<Integer, DPoint> calShortestDistancePoint(List<DPoint> list, DPoint dPoint) {
        int n2 = list.size();
        if (n2 < 2) {
            return null;
        }
        Pair pair = null;
        DPoint dPoint2 = dPoint;
        DPoint dPoint3 = null;
        DPoint dPoint4 = null;
        double d2 = 0.0;
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            if (i2 == 0) {
                dPoint3 = list.get(i2);
                if (dPoint3.equals(dPoint)) {
                    return new Pair((Object)i2, (Object)dPoint);
                }
            } else {
                dPoint3 = dPoint4;
            }
            if ((dPoint4 = list.get(i2 + 1)).equals(dPoint)) {
                return new Pair((Object)(i2 + 1), (Object)dPoint);
            }
            Pair<Double, DPoint> pair2 = SpatialRelationUtil.pointToSegDist(dPoint2.x, dPoint2.y, dPoint3.x, dPoint3.y, dPoint4.x, dPoint4.y);
            if (pair == null) {
                d2 = (Double)pair2.first;
                pair = new Pair((Object)i2, pair2.second);
                continue;
            }
            if (!(d2 > (Double)pair2.first)) continue;
            d2 = (Double)pair2.first;
            pair = new Pair((Object)i2, pair2.second);
        }
        return pair;
    }

    private static Pair<Double, DPoint> pointToSegDist(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = (d6 - d4) * (d2 - d4) + (d7 - d5) * (d3 - d5);
        if (d8 <= 0.0) {
            return new Pair((Object)Math.sqrt((d2 - d4) * (d2 - d4) + (d3 - d5) * (d3 - d5)), (Object)new DPoint(d4, d5));
        }
        double d9 = (d6 - d4) * (d6 - d4) + (d7 - d5) * (d7 - d5);
        if (d8 >= d9) {
            return new Pair((Object)Math.sqrt((d2 - d6) * (d2 - d6) + (d3 - d7) * (d3 - d7)), (Object)new DPoint(d6, d7));
        }
        double d10 = d8 / d9;
        double d11 = d4 + (d6 - d4) * d10;
        double d12 = d5 + (d7 - d5) * d10;
        double d13 = Math.sqrt((d2 - d11) * (d2 - d11) + (d12 - d3) * (d12 - d3));
        Pair pair = new Pair((Object)d13, (Object)new DPoint(d11, d12));
        return pair;
    }
}

