/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.utils.overlay;

import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.amap.api.maps.AMap;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.model.BitmapDescriptor;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.MarkerOptions;
import com.amap.api.maps.model.animation.TranslateAnimation;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmoothMoveMarker {
    private AMap mAMap;
    private long duration = 10000L;
    private LinkedList<LatLng> points = new LinkedList();
    private LinkedList<Double> eachDistance = new LinkedList();
    private double totalDistance = 0.0;
    private double remainDistance = 0.0;
    private LatLng endPoint;
    private LatLng lastEndPoint;
    private Marker marker = null;
    private BitmapDescriptor descriptor;
    private TranslateAnimation animation;
    private int index = 0;
    private boolean useDefaultDescriptor = false;
    private Thread moveThread = null;
    private Timer timer = null;
    boolean exitFlag = false;
    private MoveListener moveListener;
    private LatLng tempPosition;

    public SmoothMoveMarker(AMap aMap) {
        this.mAMap = aMap;
    }

    public void setPoints(List<LatLng> list) {
        this.points.clear();
        for (LatLng latLng : list) {
            this.points.add(latLng);
        }
        if (list.size() > 1) {
            this.endPoint = list.get(list.size() - 1);
            this.lastEndPoint = list.get(list.size() - 2);
        }
        this.eachDistance.clear();
        this.totalDistance = 0.0;
        for (int i2 = 0; i2 < list.size() - 1; ++i2) {
            double d2 = AMapUtils.calculateLineDistance(list.get(i2), list.get(i2 + 1));
            this.eachDistance.add(d2);
            this.totalDistance += d2;
        }
        this.remainDistance = this.totalDistance;
        LatLng latLng = this.points.removeFirst();
        if (this.marker != null) {
            this.marker.setPosition(latLng);
            this.checkMarkerIcon();
        } else {
            if (this.descriptor == null) {
                this.useDefaultDescriptor = true;
            }
            this.marker = this.mAMap.addMarker(new MarkerOptions().belowMaskLayer(true).position(latLng).icon(this.descriptor).title("").anchor(0.5f, 0.5f));
        }
    }

    private void checkMarkerIcon() {
        if (this.useDefaultDescriptor) {
            if (this.descriptor == null) {
                this.useDefaultDescriptor = true;
            } else {
                this.marker.setIcon(this.descriptor);
                this.useDefaultDescriptor = false;
            }
        }
    }

    public void setTotalDuration(int n2) {
        this.duration = n2 * 1000;
    }

    public void startSmoothMove() {
        if (this.points.size() < 1) {
            return;
        }
        this.index = 0;
        this.exitFlag = false;
        if (this.moveThread != null) {
            this.moveThread.interrupt();
        }
        this.moveThread = new Thread(new Runnable(){

            public void run() {
                this.a();
            }

            private void a() {
                try {
                    float f2;
                    if (SmoothMoveMarker.this.points.size() < 1) {
                        SmoothMoveMarker.this.setEndRotate();
                        return;
                    }
                    double d2 = (Double)SmoothMoveMarker.this.eachDistance.poll();
                    long l2 = (long)((double)SmoothMoveMarker.this.duration * (d2 / SmoothMoveMarker.this.totalDistance));
                    SmoothMoveMarker.this.remainDistance = SmoothMoveMarker.this.remainDistance - d2;
                    if (SmoothMoveMarker.this.moveListener != null) {
                        if (SmoothMoveMarker.this.remainDistance < 0.0) {
                            SmoothMoveMarker.this.remainDistance = 0.0;
                        }
                        SmoothMoveMarker.this.moveListener.move(SmoothMoveMarker.this.remainDistance);
                    }
                    LatLng latLng = SmoothMoveMarker.this.marker.getPosition();
                    if (SmoothMoveMarker.this.tempPosition != null && (f2 = AMapUtils.calculateLineDistance(SmoothMoveMarker.this.tempPosition, latLng)) < 10.0f) {
                        latLng = (LatLng)SmoothMoveMarker.this.points.poll();
                        SmoothMoveMarker.this.marker.setPosition(latLng);
                    }
                    SmoothMoveMarker.this.tempPosition = latLng;
                    LatLng latLng2 = (LatLng)SmoothMoveMarker.this.points.poll();
                    if (SmoothMoveMarker.this.timer != null) {
                        SmoothMoveMarker.this.timer.cancel();
                    }
                    SmoothMoveMarker.this.timer = new Timer();
                    SmoothMoveMarker.this.timer.schedule(new TimerTask(){

                        public void run() {
                            if (SmoothMoveMarker.this.points.size() > 0) {
                                SmoothMoveMarker.this.index++;
                                this.a();
                            } else {
                                SmoothMoveMarker.this.setEndRotate();
                            }
                        }
                    }, l2);
                    float f3 = SmoothMoveMarker.this.getRotate(latLng, latLng2);
                    SmoothMoveMarker.this.marker.setRotateAngle(360.0f - f3 + ((SmoothMoveMarker)SmoothMoveMarker.this).mAMap.getCameraPosition().bearing);
                    SmoothMoveMarker.this.animation = new TranslateAnimation(latLng2);
                    SmoothMoveMarker.this.animation.setInterpolator((Interpolator)new LinearInterpolator());
                    SmoothMoveMarker.this.animation.setDuration(l2);
                    if (SmoothMoveMarker.this.exitFlag || Thread.interrupted()) {
                        SmoothMoveMarker.this.marker.setAnimation(null);
                        return;
                    }
                    SmoothMoveMarker.this.marker.setAnimation(SmoothMoveMarker.this.animation);
                    SmoothMoveMarker.this.marker.startAnimation();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        });
        this.moveThread.start();
    }

    private void setEndRotate() {
        if (this.marker == null) {
            return;
        }
        float f2 = this.getRotate(this.lastEndPoint, this.endPoint);
        this.marker.setRotateAngle(360.0f - f2 + this.mAMap.getCameraPosition().bearing);
        this.marker.setPosition(this.endPoint);
    }

    private float getRotate(LatLng latLng, LatLng latLng2) {
        if (latLng == null || latLng2 == null) {
            return 0.0f;
        }
        double d2 = latLng.latitude;
        double d3 = latLng2.latitude;
        double d4 = latLng.longitude;
        double d5 = latLng2.longitude;
        float f2 = (float)(Math.atan2(d5 - d4, d3 - d2) / Math.PI * 180.0);
        return f2;
    }

    public void stopMove() {
        this.exitFlag = true;
        if (this.marker != null) {
            this.marker.setAnimation(null);
        }
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.moveThread != null) {
            this.moveThread.interrupt();
        }
        this.index = 0;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public LatLng getPosition() {
        if (this.marker == null) {
            return null;
        }
        return this.marker.getPosition();
    }

    public int getIndex() {
        return this.index;
    }

    public void destroy() {
        this.stopMove();
        if (this.descriptor != null) {
            this.descriptor.recycle();
        }
        if (this.marker != null) {
            this.marker.destroy();
            this.marker = null;
        }
        this.points.clear();
        this.eachDistance.clear();
    }

    public void setDescriptor(BitmapDescriptor bitmapDescriptor) {
        if (this.descriptor != null) {
            this.descriptor.recycle();
        }
        this.descriptor = bitmapDescriptor;
        if (this.marker != null) {
            this.marker.setIcon(bitmapDescriptor);
        }
    }

    public void setRotate(float f2) {
        if (this.marker != null) {
            this.marker.setRotateAngle(360.0f - f2);
        }
    }

    public void setVisible(boolean bl2) {
        if (this.marker != null) {
            this.marker.setVisible(bl2);
        }
    }

    public void setMoveListener(MoveListener moveListener) {
        this.moveListener = moveListener;
    }

    public static interface MoveListener {
        public void move(double var1);
    }
}

