/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap;

import android.opengl.GLSurfaceView;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class GLMapRender
implements GLSurfaceView.Renderer {
    public static final int NORMAL_TICK_COUNT = 2;
    public static final int ANIMATION_TICK_COUNT = 10;
    public static final int LONG_TICK_COUNT = 6;
    public static final int LONG_LONG_TICK_COUNT = 30;
    static final int RENDER_FPS_MAX = 60;
    public static int RENDER_FPS_NAVI = 10;
    public static int RENDER_FPS_NORMAL = 15;
    public static int RENDER_FPS_ANIMATION = 30;
    public static int RENDER_FPS_GESTURE_ACTION = 40;
    static final long RENDER_TIMMER_DIFF_MIN = 16L;
    private static final int MAP_RENDER_MSG_SURFACE_RENDER = 10;
    private static final int MAP_RENDER_MSG_RUNNABLE_ONGLTHREAD = 100;
    public IAMap mGLMapView;
    static final String TAG = "render";
    private int mTargetFrameDurationMillis = (int)(1000.0f / (float)RENDER_FPS_NORMAL);
    private float mTargetRenderFPS = RENDER_FPS_NORMAL;
    private volatile boolean mIsRendPause = false;
    public volatile boolean mSurfacedestoryed = false;
    private HandlerThread mGLRenderThread = null;
    private Handler mGLRenderHandler = null;
    private long mLastFrameTime = System.currentTimeMillis();
    private boolean mIsTrafficMode = false;
    private volatile long mDrawFrameTickCount = 6L;

    public GLMapRender(IAMap iAMap) {
        this.mGLMapView = iAMap;
    }

    public void setTrafficMode(boolean bl2) {
        this.mIsTrafficMode = bl2;
    }

    public void resetTickCount(int n2) {
        if (!this.mIsRendPause && this.mGLRenderThread != null && this.mGLRenderHandler != null && this.mGLRenderThread.isAlive()) {
            if (this.mDrawFrameTickCount <= 0L) {
                this.mDrawFrameTickCount = n2;
                this.mGLRenderHandler.removeMessages(10);
                this.mGLRenderHandler.sendEmptyMessage(10);
            } else if (this.mDrawFrameTickCount < (long)n2) {
                this.mDrawFrameTickCount = n2;
            }
        } else if (this.mDrawFrameTickCount < (long)n2) {
            this.mDrawFrameTickCount = n2;
        }
    }

    public boolean isRenderPause() {
        return this.mIsRendPause;
    }

    public void setRenderFps(float f2) {
        if (this.mTargetRenderFPS != f2 && f2 > 0.0f) {
            this.mTargetFrameDurationMillis = (int)(1.0f / f2 * 1000.0f);
            this.mTargetRenderFPS = f2;
        }
    }

    public void sendToRenderEvent(Runnable runnable) {
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
            this.mGLRenderHandler.post(runnable);
        }
    }

    public void renderPause() {
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
            this.mGLRenderHandler.removeMessages(10);
        }
        this.mIsRendPause = true;
    }

    public void renderResume() {
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
            this.mGLRenderHandler.removeMessages(10);
        }
        this.mIsRendPause = false;
        this.mDrawFrameTickCount = -1L;
        this.resetTickCount(30);
    }

    public void onAttachedToWindow() {
        this.mGLRenderThread = new HandlerThread(" AMapGlRenderThread");
        this.mGLRenderThread.start();
        this.mGLRenderHandler = new Handler(this.mGLRenderThread.getLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 10: {
                        if (GLMapRender.this.mIsRendPause || GLMapRender.this.mGLMapView == null || GLMapRender.this.mGLMapView.getRenderMode() != 0) break;
                        GLMapRender.this.mGLMapView.requestRender();
                        break;
                    }
                    case 100: {
                        Runnable runnable = (Runnable)message.obj;
                        runnable.run();
                    }
                }
            }
        };
    }

    public void onDetachedFromWindow() {
        this.mGLRenderThread.quit();
        this.mGLRenderThread = null;
        this.mGLRenderHandler = null;
    }

    private void drawSingleFrame(GL10 gL10) {
        this.mGLMapView.drawFrame(gL10);
    }

    public void onDrawFrame(GL10 gL10) {
        gL10.glClearColor(0.9453125f, 0.93359f, 0.9101f, 1.0f);
        gL10.glClear(16640);
        if (!this.mIsRendPause) {
            this.mLastFrameTime = System.currentTimeMillis();
            this.drawSingleFrame(gL10);
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.mLastFrameTime;
            this.mLastFrameTime = l2;
            if (this.mGLMapView.getRenderMode() == 0 && this.mGLRenderHandler != null && this.mGLRenderThread != null && this.mGLRenderThread.isAlive()) {
                --this.mDrawFrameTickCount;
                long l4 = 0L;
                if (this.mDrawFrameTickCount <= 0L) {
                    if (this.mDrawFrameTickCount > -5L) {
                        l4 = 60L;
                    } else if (this.mDrawFrameTickCount > -7L) {
                        l4 = 100L;
                    } else if (this.mDrawFrameTickCount > -9L) {
                        l4 = 250L;
                    } else {
                        if (this.mIsTrafficMode) {
                            l4 = 10000L;
                        }
                        this.mDrawFrameTickCount = -9L;
                    }
                } else {
                    l4 = Math.max(16L, (long)this.mTargetFrameDurationMillis - l3);
                }
                if (l4 > 0L) {
                    this.mGLRenderHandler.removeMessages(10);
                    this.mGLRenderHandler.sendEmptyMessageDelayed(10, l4);
                }
            }
        }
    }

    public void onSurfaceChanged(GL10 gL10, int n2, int n3) {
        if (this.mSurfacedestoryed) {
            this.onSurfaceCreated(gL10, null);
        }
        this.mGLMapView.changeSurface(gL10, n2, n3);
        this.resetTickCount(30);
    }

    public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
        this.mIsRendPause = false;
        this.mSurfacedestoryed = false;
        this.mGLMapView.createSurface(gL10, eGLConfig);
    }

    public void onSurfaceDestory() {
        this.mIsRendPause = true;
        if (this.mGLRenderHandler != null && this.mGLRenderThread != null) {
            this.mGLRenderHandler.removeCallbacksAndMessages(null);
        }
        this.mGLMapView.destorySurface(1);
        this.mSurfacedestoryed = true;
    }
}

