/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import com.autonavi.ae.gmap.gesture.BaseGestureDetector;

public class MoveGestureDetector
extends BaseGestureDetector {
    private static final PointF FOCUS_DELTA_ZERO = new PointF();
    private final OnMoveGestureListener mListener;
    private PointF mCurrFocusInternal;
    private PointF mPrevFocusInternal;
    private PointF mFocusExternal = new PointF();
    private PointF mFocusDeltaExternal = new PointF();

    public MoveGestureDetector(Context context, OnMoveGestureListener onMoveGestureListener) {
        super(context);
        this.mListener = onMoveGestureListener;
    }

    protected void handleStartProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 0: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(motionEvent);
                break;
            }
            case 5: {
                if (this.mPrevEvent != null) {
                    this.mPrevEvent.recycle();
                }
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                this.updateStateByEvent(motionEvent);
                break;
            }
            case 2: {
                this.mGestureInProgress = this.mListener.onMoveBegin(this);
            }
        }
    }

    protected void handleInProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 1: 
            case 3: {
                this.mListener.onMoveEnd(this);
                this.resetState();
                break;
            }
            case 2: {
                boolean bl2;
                this.updateStateByEvent(motionEvent);
                if (!(this.mCurrPressure / this.mPrevPressure > 0.67f) || !(bl2 = this.mListener.onMove(this))) break;
                this.mPrevEvent.recycle();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            }
        }
    }

    protected void updateStateByEvent(MotionEvent motionEvent) {
        super.updateStateByEvent(motionEvent);
        MotionEvent motionEvent2 = this.mPrevEvent;
        this.mCurrFocusInternal = MoveGestureDetector.determineFocalPoint(motionEvent);
        this.mPrevFocusInternal = MoveGestureDetector.determineFocalPoint(motionEvent2);
        boolean bl2 = this.mPrevEvent.getPointerCount() != motionEvent.getPointerCount();
        PointF pointF = this.mFocusDeltaExternal = bl2 ? FOCUS_DELTA_ZERO : new PointF(this.mCurrFocusInternal.x - this.mPrevFocusInternal.x, this.mCurrFocusInternal.y - this.mPrevFocusInternal.y);
        if (bl2) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        }
        this.mFocusExternal.x += this.mFocusDeltaExternal.x;
        this.mFocusExternal.y += this.mFocusDeltaExternal.y;
    }

    public float getFocusX() {
        return this.mFocusExternal.x;
    }

    public float getFocusY() {
        return this.mFocusExternal.y;
    }

    public PointF getFocusDelta() {
        return this.mFocusDeltaExternal;
    }

    public static class SimpleOnMoveGestureListener
    implements OnMoveGestureListener {
        public boolean onMove(MoveGestureDetector moveGestureDetector) {
            return false;
        }

        public boolean onMoveBegin(MoveGestureDetector moveGestureDetector) {
            return true;
        }

        public void onMoveEnd(MoveGestureDetector moveGestureDetector) {
        }
    }

    public static interface OnMoveGestureListener {
        public boolean onMove(MoveGestureDetector var1);

        public boolean onMoveBegin(MoveGestureDetector var1);

        public void onMoveEnd(MoveGestureDetector var1);
    }
}

