/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewConfiguration;

public class ScaleGestureDetector {
    private static final float PRESSURE_THRESHOLD = 0.67f;
    private final Context mContext;
    private final OnScaleGestureListener mListener;
    private boolean mGestureInProgress;
    private MotionEvent mPrevEvent;
    private MotionEvent mCurrEvent;
    private float mFocusX;
    private float mFocusY;
    private float mPrevFingerDiffX;
    private float mPrevFingerDiffY;
    private float mCurrFingerDiffX;
    private float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float mScaleFactor;
    private float mCurrPressure;
    private float mPrevPressure;
    private long mTimeDelta;
    private final float mEdgeSlop;
    private float mRightSlopEdge;
    private float mBottomSlopEdge;
    private boolean mSloppyGesture;
    private boolean mInvalidGesture;
    private int mActiveId0;
    private int mActiveId1;
    private boolean mActive0MostRecent;

    public ScaleGestureDetector(Context context, OnScaleGestureListener onScaleGestureListener) {
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mContext = context;
        this.mListener = onScaleGestureListener;
        this.mEdgeSlop = viewConfiguration.getScaledEdgeSlop();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int n2 = motionEvent.getAction() & 0xFF;
        if (n2 == 0) {
            this.reset();
        }
        boolean bl2 = true;
        if (this.mInvalidGesture) {
            return false;
        }
        if (!this.mGestureInProgress) {
            switch (n2) {
                case 0: {
                    this.mActiveId0 = motionEvent.getPointerId(0);
                    this.mActive0MostRecent = true;
                    return bl2;
                }
                case 1: {
                    this.reset();
                    return bl2;
                }
                case 5: {
                    boolean bl3;
                    DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
                    this.mRightSlopEdge = (float)displayMetrics.widthPixels - this.mEdgeSlop;
                    this.mBottomSlopEdge = (float)displayMetrics.heightPixels - this.mEdgeSlop;
                    if (this.mPrevEvent != null) {
                        this.mPrevEvent.recycle();
                    }
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    this.mTimeDelta = 0L;
                    int n3 = 0;
                    int n4 = 0;
                    if (Build.VERSION.SDK_INT >= 8) {
                        n4 = motionEvent.getActionIndex();
                        n3 = motionEvent.findPointerIndex(this.mActiveId0);
                        this.mActiveId1 = motionEvent.getPointerId(n4);
                        if (n3 < 0 || n3 == n4) {
                            n3 = this.findNewActiveIndex(motionEvent, n3 == n4 ? -1 : this.mActiveId1, n3);
                            this.mActiveId0 = motionEvent.getPointerId(n3);
                        }
                    } else if (motionEvent.getPointerCount() > 0) {
                        n4 = motionEvent.findPointerIndex(1);
                        n3 = motionEvent.findPointerIndex(this.mActiveId0);
                        this.mActiveId1 = motionEvent.getPointerId(n4);
                    }
                    this.mActive0MostRecent = false;
                    this.setContext(motionEvent);
                    float f2 = this.mEdgeSlop;
                    float f3 = this.mRightSlopEdge;
                    float f4 = this.mBottomSlopEdge;
                    float f5 = ScaleGestureDetector.getRawX(motionEvent, n3);
                    float f6 = ScaleGestureDetector.getRawY(motionEvent, n3);
                    float f7 = ScaleGestureDetector.getRawX(motionEvent, n4);
                    float f8 = ScaleGestureDetector.getRawY(motionEvent, n4);
                    boolean bl4 = f5 < f2 || f6 < f2 || f5 > f3 || f6 > f4;
                    boolean bl5 = bl3 = f7 < f2 || f8 < f2 || f7 > f3 || f8 > f4;
                    if (bl4 && bl3) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        this.mSloppyGesture = true;
                        return bl2;
                    }
                    if (bl4) {
                        this.mFocusX = motionEvent.getX(n4);
                        this.mFocusY = motionEvent.getY(n4);
                        this.mSloppyGesture = true;
                        return bl2;
                    }
                    if (bl3) {
                        this.mFocusX = motionEvent.getX(n3);
                        this.mFocusY = motionEvent.getY(n3);
                        this.mSloppyGesture = true;
                        return bl2;
                    }
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    return bl2;
                }
                case 2: {
                    int n5;
                    boolean bl6;
                    if (!this.mSloppyGesture) return bl2;
                    float f9 = this.mEdgeSlop;
                    float f10 = this.mRightSlopEdge;
                    float f11 = this.mBottomSlopEdge;
                    int n6 = motionEvent.findPointerIndex(this.mActiveId0);
                    int n7 = motionEvent.findPointerIndex(this.mActiveId1);
                    float f12 = ScaleGestureDetector.getRawX(motionEvent, n6);
                    float f13 = ScaleGestureDetector.getRawY(motionEvent, n6);
                    float f14 = ScaleGestureDetector.getRawX(motionEvent, n7);
                    float f15 = ScaleGestureDetector.getRawY(motionEvent, n7);
                    boolean bl7 = f12 < f9 || f13 < f9 || f12 > f10 || f13 > f11;
                    boolean bl8 = bl6 = f14 < f9 || f15 < f9 || f14 > f10 || f15 > f11;
                    if (bl7 && (n5 = this.findNewActiveIndex(motionEvent, this.mActiveId1, n6)) >= 0) {
                        n6 = n5;
                        this.mActiveId0 = motionEvent.getPointerId(n5);
                        f12 = ScaleGestureDetector.getRawX(motionEvent, n5);
                        f13 = ScaleGestureDetector.getRawY(motionEvent, n5);
                        bl7 = false;
                    }
                    if (bl6 && (n5 = this.findNewActiveIndex(motionEvent, this.mActiveId0, n7)) >= 0) {
                        n7 = n5;
                        this.mActiveId1 = motionEvent.getPointerId(n5);
                        f14 = ScaleGestureDetector.getRawX(motionEvent, n5);
                        f15 = ScaleGestureDetector.getRawY(motionEvent, n5);
                        bl6 = false;
                    }
                    if (bl7 && bl6) {
                        this.mFocusX = -1.0f;
                        this.mFocusY = -1.0f;
                        return bl2;
                    }
                    if (bl7) {
                        this.mFocusX = motionEvent.getX(n7);
                        this.mFocusY = motionEvent.getY(n7);
                        return bl2;
                    }
                    if (bl6) {
                        this.mFocusX = motionEvent.getX(n6);
                        this.mFocusY = motionEvent.getY(n6);
                        return bl2;
                    }
                    this.mSloppyGesture = false;
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    return bl2;
                }
                case 6: {
                    if (!this.mSloppyGesture) return bl2;
                    int n8 = motionEvent.getPointerCount();
                    int n9 = 0;
                    if (Build.VERSION.SDK_INT >= 8) {
                        n9 = motionEvent.getActionIndex();
                    }
                    int n10 = n9;
                    int n11 = motionEvent.getPointerId(n10);
                    if (n8 > 2) {
                        if (n11 == this.mActiveId0) {
                            int n12 = this.findNewActiveIndex(motionEvent, this.mActiveId1, n10);
                            if (n12 < 0) return bl2;
                            this.mActiveId0 = motionEvent.getPointerId(n12);
                            return bl2;
                        }
                        if (n11 != this.mActiveId1) return bl2;
                        int n13 = this.findNewActiveIndex(motionEvent, this.mActiveId0, n10);
                        if (n13 < 0) return bl2;
                        this.mActiveId1 = motionEvent.getPointerId(n13);
                        return bl2;
                    }
                    int n14 = motionEvent.findPointerIndex(n11 == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0);
                    if (n14 < 0) {
                        this.mInvalidGesture = true;
                        if (!this.mGestureInProgress) return false;
                        this.mListener.onScaleEnd(this);
                        return false;
                    }
                    this.mActiveId0 = motionEvent.getPointerId(n14);
                    this.mActive0MostRecent = true;
                    this.mActiveId1 = -1;
                    this.mFocusX = motionEvent.getX(n14);
                    this.mFocusY = motionEvent.getY(n14);
                }
            }
            return bl2;
        } else {
            switch (n2) {
                case 5: {
                    this.mListener.onScaleEnd(this);
                    int n15 = this.mActiveId0;
                    int n16 = this.mActiveId1;
                    this.reset();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                    this.mActiveId0 = this.mActive0MostRecent ? n15 : n16;
                    this.mActiveId1 = Build.VERSION.SDK_INT >= 8 ? motionEvent.getPointerId(motionEvent.getActionIndex()) : motionEvent.getPointerId(1);
                    this.mActive0MostRecent = false;
                    int n17 = motionEvent.findPointerIndex(this.mActiveId0);
                    if (n17 < 0 || this.mActiveId0 == this.mActiveId1) {
                        n17 = this.findNewActiveIndex(motionEvent, this.mActiveId0 == this.mActiveId1 ? -1 : this.mActiveId1, n17);
                        this.mActiveId0 = motionEvent.getPointerId(n17);
                    }
                    this.setContext(motionEvent);
                    this.mGestureInProgress = this.mListener.onScaleBegin(this);
                    return bl2;
                }
                case 6: {
                    int n18;
                    int n19 = motionEvent.getPointerCount();
                    int n20 = 0;
                    if (Build.VERSION.SDK_INT >= 8) {
                        n20 = motionEvent.getActionIndex();
                    }
                    int n21 = n20;
                    int n22 = motionEvent.getPointerId(n21);
                    boolean bl9 = false;
                    if (n19 > 2) {
                        if (n22 == this.mActiveId0) {
                            n18 = this.findNewActiveIndex(motionEvent, this.mActiveId1, n21);
                            if (n18 >= 0) {
                                this.mListener.onScaleEnd(this);
                                this.mActiveId0 = motionEvent.getPointerId(n18);
                                this.mActive0MostRecent = true;
                                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                                this.setContext(motionEvent);
                                this.mGestureInProgress = this.mListener.onScaleBegin(this);
                            } else {
                                bl9 = true;
                            }
                        } else if (n22 == this.mActiveId1) {
                            n18 = this.findNewActiveIndex(motionEvent, this.mActiveId0, n21);
                            if (n18 >= 0) {
                                this.mListener.onScaleEnd(this);
                                this.mActiveId1 = motionEvent.getPointerId(n18);
                                this.mActive0MostRecent = false;
                                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                                this.setContext(motionEvent);
                                this.mGestureInProgress = this.mListener.onScaleBegin(this);
                            } else {
                                bl9 = true;
                            }
                        }
                        this.mPrevEvent.recycle();
                        this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                        this.setContext(motionEvent);
                    } else {
                        bl9 = true;
                    }
                    if (!bl9) return bl2;
                    this.setContext(motionEvent);
                    n18 = n22 == this.mActiveId0 ? this.mActiveId1 : this.mActiveId0;
                    int n23 = motionEvent.findPointerIndex(n18);
                    this.mFocusX = motionEvent.getX(n23);
                    this.mFocusY = motionEvent.getY(n23);
                    this.mListener.onScaleEnd(this);
                    this.reset();
                    this.mActiveId0 = n18;
                    this.mActive0MostRecent = true;
                    return bl2;
                }
                case 3: {
                    this.mListener.onScaleEnd(this);
                    this.reset();
                    return bl2;
                }
                case 1: {
                    this.reset();
                    return bl2;
                }
                case 2: {
                    this.setContext(motionEvent);
                    if (!(this.mCurrPressure / this.mPrevPressure > 0.67f)) return bl2;
                    boolean bl10 = this.mListener.onScale(this);
                    if (!bl10) return bl2;
                    this.mPrevEvent.recycle();
                    this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                }
            }
        }
        return bl2;
    }

    private int findNewActiveIndex(MotionEvent motionEvent, int n2, int n3) {
        int n4 = motionEvent.getPointerCount();
        int n5 = motionEvent.findPointerIndex(n2);
        int n6 = -1;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (i2 == n3 || i2 == n5) continue;
            float f2 = this.mEdgeSlop;
            float f3 = this.mRightSlopEdge;
            float f4 = this.mBottomSlopEdge;
            float f5 = ScaleGestureDetector.getRawX(motionEvent, i2);
            float f6 = ScaleGestureDetector.getRawY(motionEvent, i2);
            if (!(f5 >= f2) || !(f6 >= f2) || !(f5 <= f3) || !(f6 <= f4)) continue;
            n6 = i2;
            break;
        }
        return n6;
    }

    private static float getRawX(MotionEvent motionEvent, int n2) {
        if (n2 < 0) {
            return Float.MIN_VALUE;
        }
        if (n2 == 0) {
            return motionEvent.getRawX();
        }
        float f2 = motionEvent.getRawX() - motionEvent.getX();
        return motionEvent.getX(n2) + f2;
    }

    private static float getRawY(MotionEvent motionEvent, int n2) {
        if (n2 < 0) {
            return Float.MIN_VALUE;
        }
        if (n2 == 0) {
            return motionEvent.getRawY();
        }
        float f2 = motionEvent.getRawY() - motionEvent.getY();
        return motionEvent.getY(n2) + f2;
    }

    private void setContext(MotionEvent motionEvent) {
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
        }
        this.mCurrEvent = MotionEvent.obtain((MotionEvent)motionEvent);
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        this.mScaleFactor = -1.0f;
        MotionEvent motionEvent2 = this.mPrevEvent;
        int n2 = motionEvent2.findPointerIndex(this.mActiveId0);
        int n3 = motionEvent2.findPointerIndex(this.mActiveId1);
        int n4 = motionEvent.findPointerIndex(this.mActiveId0);
        int n5 = motionEvent.findPointerIndex(this.mActiveId1);
        if (n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0) {
            this.mInvalidGesture = true;
            if (this.mGestureInProgress) {
                this.mListener.onScaleEnd(this);
            }
            return;
        }
        float f2 = motionEvent2.getX(n2);
        float f3 = motionEvent2.getY(n2);
        float f4 = motionEvent2.getX(n3);
        float f5 = motionEvent2.getY(n3);
        float f6 = motionEvent.getX(n4);
        float f7 = motionEvent.getY(n4);
        float f8 = motionEvent.getX(n5);
        float f9 = motionEvent.getY(n5);
        float f10 = f4 - f2;
        float f11 = f5 - f3;
        float f12 = f8 - f6;
        float f13 = f9 - f7;
        this.mPrevFingerDiffX = f10;
        this.mPrevFingerDiffY = f11;
        this.mCurrFingerDiffX = f12;
        this.mCurrFingerDiffY = f13;
        this.mFocusX = f6 + f12 * 0.5f;
        this.mFocusY = f7 + f13 * 0.5f;
        this.mTimeDelta = motionEvent.getEventTime() - motionEvent2.getEventTime();
        this.mCurrPressure = motionEvent.getPressure(n4) + motionEvent.getPressure(n5);
        this.mPrevPressure = motionEvent2.getPressure(n2) + motionEvent2.getPressure(n3);
    }

    private void reset() {
        if (this.mPrevEvent != null) {
            this.mPrevEvent.recycle();
            this.mPrevEvent = null;
        }
        if (this.mCurrEvent != null) {
            this.mCurrEvent.recycle();
            this.mCurrEvent = null;
        }
        this.mSloppyGesture = false;
        this.mGestureInProgress = false;
        this.mActiveId0 = -1;
        this.mActiveId1 = -1;
        this.mInvalidGesture = false;
    }

    public boolean isInProgress() {
        return this.mGestureInProgress;
    }

    public float getFocusX() {
        return this.mFocusX;
    }

    public float getFocusY() {
        return this.mFocusY;
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float f2 = this.mCurrFingerDiffX;
            float f3 = this.mCurrFingerDiffY;
            this.mCurrLen = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        return this.mCurrLen;
    }

    public float getCurrentSpanX() {
        return this.mCurrFingerDiffX;
    }

    public float getCurrentSpanY() {
        return this.mCurrFingerDiffY;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float f2 = this.mPrevFingerDiffX;
            float f3 = this.mPrevFingerDiffY;
            this.mPrevLen = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        return this.mPrevLen;
    }

    public float getPreviousSpanX() {
        return this.mPrevFingerDiffX;
    }

    public float getPreviousSpanY() {
        return this.mPrevFingerDiffY;
    }

    public float getScaleFactor() {
        if (this.mScaleFactor == -1.0f) {
            this.mScaleFactor = this.getCurrentSpan() / this.getPreviousSpan();
        }
        return this.mScaleFactor;
    }

    public long getTimeDelta() {
        return this.mTimeDelta;
    }

    public long getEventTime() {
        return this.mCurrEvent.getEventTime();
    }

    public MotionEvent getEvent() {
        return this.mCurrEvent;
    }

    public static class SimpleOnScaleGestureListener
    implements OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        }
    }

    public static interface OnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector var1);

        public boolean onScaleBegin(ScaleGestureDetector var1);

        public void onScaleEnd(ScaleGestureDetector var1);
    }
}

