/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ViewConfiguration;
import com.autonavi.ae.gmap.gesture.BaseGestureDetector;

public abstract class TwoFingerGestureDetector
extends BaseGestureDetector {
    private final float mEdgeSlop;
    private float mRightSlopEdge;
    private float mBottomSlopEdge;
    protected float mPrevFingerDiffX;
    protected float mPrevFingerDiffY;
    protected float mCurrFingerDiffX;
    protected float mCurrFingerDiffY;
    private float mCurrLen;
    private float mPrevLen;
    private float finger0DiffX = 0.0f;
    private float finger0DiffY = 0.0f;
    private float finger1DiffX = 0.0f;
    private float finger1DiffY = 0.0f;

    public TwoFingerGestureDetector(Context context) {
        super(context);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mEdgeSlop = viewConfiguration.getScaledEdgeSlop();
    }

    protected abstract void handleStartProgressEvent(int var1, MotionEvent var2);

    protected abstract void handleInProgressEvent(int var1, MotionEvent var2);

    protected void updateStateByEvent(MotionEvent motionEvent) {
        super.updateStateByEvent(motionEvent);
        MotionEvent motionEvent2 = this.mPrevEvent;
        int n2 = this.mPrevEvent.getPointerCount();
        int n3 = motionEvent.getPointerCount();
        if (n3 != 2 || n3 != n2) {
            return;
        }
        this.mCurrLen = -1.0f;
        this.mPrevLen = -1.0f;
        float f2 = motionEvent2.getX(0);
        float f3 = motionEvent2.getY(0);
        float f4 = motionEvent2.getX(1);
        float f5 = motionEvent2.getY(1);
        float f6 = f4 - f2;
        float f7 = f5 - f3;
        this.mPrevFingerDiffX = f6;
        this.mPrevFingerDiffY = f7;
        float f8 = motionEvent.getX(0);
        float f9 = motionEvent.getY(0);
        float f10 = motionEvent.getX(1);
        float f11 = motionEvent.getY(1);
        float f12 = f10 - f8;
        float f13 = f11 - f9;
        this.mCurrFingerDiffX = f12;
        this.mCurrFingerDiffY = f13;
        this.finger0DiffX = f8 - f2;
        this.finger0DiffY = f9 - f3;
        this.finger1DiffX = f10 - f4;
        this.finger1DiffY = f11 - f5;
    }

    public PointF getPointerDelta(int n2) {
        if (n2 == 0) {
            return new PointF(this.finger0DiffX, this.finger0DiffY);
        }
        return new PointF(this.finger1DiffX, this.finger1DiffY);
    }

    public float getCurrentSpan() {
        if (this.mCurrLen == -1.0f) {
            float f2 = this.mCurrFingerDiffX;
            float f3 = this.mCurrFingerDiffY;
            this.mCurrLen = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        return this.mCurrLen;
    }

    public float getPreviousSpan() {
        if (this.mPrevLen == -1.0f) {
            float f2 = this.mPrevFingerDiffX;
            float f3 = this.mPrevFingerDiffY;
            this.mPrevLen = (float)Math.sqrt(f2 * f2 + f3 * f3);
        }
        return this.mPrevLen;
    }

    protected static float getRawX(MotionEvent motionEvent, int n2) {
        float f2 = motionEvent.getX() - motionEvent.getRawX();
        if (n2 < motionEvent.getPointerCount()) {
            return motionEvent.getX(n2) - f2;
        }
        return 0.0f;
    }

    protected static float getRawY(MotionEvent motionEvent, int n2) {
        float f2 = motionEvent.getY() - motionEvent.getRawY();
        if (n2 < motionEvent.getPointerCount()) {
            return motionEvent.getY(n2) - f2;
        }
        return 0.0f;
    }

    protected boolean isSloppyGesture(MotionEvent motionEvent) {
        boolean bl2;
        DisplayMetrics displayMetrics = this.mContext.getResources().getDisplayMetrics();
        this.mRightSlopEdge = (float)displayMetrics.widthPixels - this.mEdgeSlop;
        this.mBottomSlopEdge = (float)displayMetrics.heightPixels - this.mEdgeSlop;
        float f2 = this.mEdgeSlop;
        float f3 = this.mRightSlopEdge;
        float f4 = this.mBottomSlopEdge;
        float f5 = motionEvent.getRawX();
        float f6 = motionEvent.getRawY();
        float f7 = TwoFingerGestureDetector.getRawX(motionEvent, 1);
        float f8 = TwoFingerGestureDetector.getRawY(motionEvent, 1);
        boolean bl3 = f5 < f2 || f6 < f2 || f5 > f3 || f6 > f4;
        boolean bl4 = bl2 = f7 < f2 || f8 < f2 || f7 > f3 || f8 > f4;
        if (bl3 && bl2) {
            return true;
        }
        if (bl3) {
            return true;
        }
        return bl2;
    }
}

