/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gesture;

import android.content.Context;
import android.graphics.PointF;
import android.view.MotionEvent;
import com.autonavi.ae.gmap.gesture.TwoFingerGestureDetector;

public class ZoomOutGestureDetector
extends TwoFingerGestureDetector {
    private final OnZoomOutGestureListener mListener;
    private boolean mSloppyGesture;
    private static final PointF FOCUS_DELTA_ZERO = new PointF();
    private PointF mCurrFocusInternal;
    private PointF mPrevFocusInternal;
    private PointF mFocusExternal = new PointF();
    private PointF mFocusDeltaExternal = new PointF();

    public ZoomOutGestureDetector(Context context, OnZoomOutGestureListener onZoomOutGestureListener) {
        super(context);
        this.mListener = onZoomOutGestureListener;
    }

    protected void handleStartProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 5: {
                this.resetState();
                this.mPrevEvent = MotionEvent.obtain((MotionEvent)motionEvent);
                this.mTimeDelta = 0L;
                this.updateStateByEvent(motionEvent);
                this.mSloppyGesture = this.isSloppyGesture(motionEvent);
                if (this.mSloppyGesture) break;
                this.mGestureInProgress = this.mListener.onZoomOutBegin(this);
            }
        }
    }

    protected void handleInProgressEvent(int n2, MotionEvent motionEvent) {
        switch (n2) {
            case 6: {
                this.updateStateByEvent(motionEvent);
                if (!this.mSloppyGesture) {
                    this.mListener.onZoomOut(this);
                }
                this.resetState();
                break;
            }
            case 3: {
                this.resetState();
            }
        }
    }

    protected void resetState() {
        super.resetState();
        this.mSloppyGesture = false;
        this.mFocusExternal.x = 0.0f;
        this.mFocusDeltaExternal.x = 0.0f;
        this.mFocusExternal.y = 0.0f;
        this.mFocusDeltaExternal.y = 0.0f;
    }

    protected void updateStateByEvent(MotionEvent motionEvent) {
        super.updateStateByEvent(motionEvent);
        MotionEvent motionEvent2 = this.mPrevEvent;
        this.mCurrFocusInternal = ZoomOutGestureDetector.determineFocalPoint(motionEvent);
        this.mPrevFocusInternal = ZoomOutGestureDetector.determineFocalPoint(motionEvent2);
        boolean bl2 = this.mPrevEvent.getPointerCount() != motionEvent.getPointerCount();
        this.mFocusDeltaExternal = bl2 ? FOCUS_DELTA_ZERO : new PointF(this.mCurrFocusInternal.x - this.mPrevFocusInternal.x, this.mCurrFocusInternal.y - this.mPrevFocusInternal.y);
        this.mFocusExternal.x += this.mFocusDeltaExternal.x;
        this.mFocusExternal.y += this.mFocusDeltaExternal.y;
    }

    public float getFocusX() {
        return this.mFocusExternal.x;
    }

    public float getFocusY() {
        return this.mFocusExternal.y;
    }

    public static class SimpleOnZoomOutGestureListener
    implements OnZoomOutGestureListener {
        public boolean onZoomOutBegin(ZoomOutGestureDetector zoomOutGestureDetector) {
            return true;
        }

        public void onZoomOut(ZoomOutGestureDetector zoomOutGestureDetector) {
        }
    }

    public static interface OnZoomOutGestureListener {
        public boolean onZoomOutBegin(ZoomOutGestureDetector var1);

        public void onZoomOut(ZoomOutGestureDetector var1);
    }
}

