/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.glanimation;

import android.os.SystemClock;
import com.autonavi.ae.gmap.GLMapState;
import com.autonavi.ae.gmap.glanimation.ADGLAnimation;
import com.autonavi.ae.gmap.glanimation.ADGLAnimationParam2V;
import com.autonavi.amap.mapcore.FPoint;
import com.autonavi.amap.mapcore.IPoint;

public class ADGLMapAnimFling
extends ADGLAnimation {
    private float _velocityX;
    private float _velocityY;
    private IPoint _fromCenter;
    private ADGLAnimationParam2V _moveParam;
    private boolean _hasCheckParams;
    private boolean _needMove;
    private int _screenCenterX;
    private int _screenCenterY;
    private int _lastMoveX;
    private int _lastMoveY;

    public ADGLMapAnimFling(int n2, int n3, int n4) {
        this._screenCenterX = n3;
        this._screenCenterY = n4;
        this._lastMoveX = n3;
        this._lastMoveY = n4;
        this._moveParam = null;
        this.reset();
        this._duration = n2;
    }

    public void reset() {
        if (this._moveParam != null) {
            this._moveParam.reset();
        }
        this._velocityX = 0.0f;
        this._velocityY = 0.0f;
        this._needMove = false;
        this._hasCheckParams = false;
    }

    public void setPositionAndVelocity(float f2, float f3) {
        this._moveParam = null;
        this._velocityX = f2;
        this._velocityY = f3;
        this._moveParam = new ADGLAnimationParam2V();
        this._moveParam.setInterpolatorType(2, 1.2f);
        this._needMove = false;
        this._hasCheckParams = false;
    }

    public void commitAnimationold(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        this._hasCheckParams = false;
        this._isOver = true;
        float f2 = (float)Math.sqrt(this._velocityX * this._velocityX + this._velocityY * this._velocityY);
        float f3 = f2 / 1000.0f;
        if (f3 >= 0.1f) {
            float f4 = 0.02f * f3;
            if (this._fromCenter == null) {
                this._fromCenter = new IPoint();
            }
            gLMapState.getGeoCenter(this._fromCenter);
            this._isOver = false;
            this._moveParam.setFromValue(this._screenCenterX, this._screenCenterY);
            this._moveParam.setToValue((float)this._screenCenterX - this._velocityX * f4, (float)this._screenCenterY - this._velocityY * f4);
            this._needMove = this._moveParam.needToCaculate();
        }
        if (this._needMove) {
            // empty if block
        }
        this._hasCheckParams = true;
        this._startTime = SystemClock.uptimeMillis();
    }

    public void commitAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        this._hasCheckParams = false;
        this._isOver = true;
        int n2 = (int)(this._velocityX * (float)this._duration / 2000.0f);
        int n3 = (int)(this._velocityY * (float)this._duration / 2000.0f);
        if (Math.abs(n2) != 0 && Math.abs(n3) != 0) {
            if (this._fromCenter == null) {
                this._fromCenter = new IPoint();
            }
            gLMapState.getGeoCenter(this._fromCenter);
            this._isOver = false;
            this._moveParam.setFromValue(this._screenCenterX, this._screenCenterY);
            this._moveParam.setToValue(this._screenCenterX - n2, this._screenCenterY - n3);
            this._needMove = this._moveParam.needToCaculate();
        }
        if (this._needMove) {
            // empty if block
        }
        this._hasCheckParams = true;
        this._startTime = SystemClock.uptimeMillis();
    }

    public void doAnimation(Object object) {
        GLMapState gLMapState = (GLMapState)object;
        if (gLMapState == null) {
            return;
        }
        if (!this._hasCheckParams) {
            this.commitAnimation(object);
        }
        if (this._isOver) {
            return;
        }
        long l2 = SystemClock.uptimeMillis();
        this._offsetTime = l2 - this._startTime;
        float f2 = (float)this._offsetTime / (float)this._duration;
        if (f2 > 1.0f) {
            f2 = 1.0f;
            this._isOver = true;
        }
        if (f2 >= 0.0f && f2 <= 1.0f && this._needMove) {
            this._moveParam.setNormalizedTime(f2);
            int n2 = (int)this._moveParam.getCurXValue();
            int n3 = (int)this._moveParam.getCurYValue();
            FPoint fPoint = new FPoint();
            gLMapState.win2Map(this._screenCenterX + n2 - this._lastMoveX, this._screenCenterY + n3 - this._lastMoveY, fPoint);
            gLMapState.setMapGlCenter(fPoint.x, fPoint.y);
            this._lastMoveX = n2;
            this._lastMoveY = n3;
        }
    }
}

