/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.gloverlay;

import android.util.SparseArray;
import com.autonavi.ae.gmap.gloverlay.BaseMapOverlay;
import com.autonavi.ae.gmap.gloverlay.GLOverlay;
import com.autonavi.ae.gmap.gloverlay.GLOverlayTexture;
import com.autonavi.amap.mapcore.interfaces.IAMap;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GLOverlayBundle<E extends BaseMapOverlay<?, ?>> {
    private final List<E> mOverlayList = new ArrayList();
    IAMap mGLMapView = null;
    private long mNativeInstance = 0L;
    private SparseArray<GLOverlayTexture> mTextureCaches = new SparseArray();
    private int mEngineID;

    public static void IntClr2PVRClr(float[] fArray, int n2) {
        fArray[2] = (float)(n2 & 0xFF) / 255.0f;
        fArray[1] = (float)(n2 >> 8 & 0xFF) / 255.0f;
        fArray[0] = (float)(n2 >> 16 & 0xFF) / 255.0f;
        fArray[3] = (float)(n2 >> 24 & 0xFF) / 255.0f;
    }

    public GLOverlayBundle(int n2, IAMap iAMap) {
        this.mEngineID = n2;
        this.mGLMapView = iAMap;
        this.mNativeInstance = iAMap.getGlOverlayMgrPtr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOverlayCount() {
        List<E> list = this.mOverlayList;
        synchronized (list) {
            return this.mOverlayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cotainsOverlay(E e2) {
        if (e2 == null) {
            return false;
        }
        List<E> list = this.mOverlayList;
        synchronized (list) {
            return this.mOverlayList.contains(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E getOverlay(int n2) {
        List<E> list = this.mOverlayList;
        synchronized (list) {
            if (n2 < 0 || n2 > this.mOverlayList.size() - 1) {
                return null;
            }
            return (E)((BaseMapOverlay)this.mOverlayList.get(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOverlay(E e2) {
        if (e2 == null) {
            return;
        }
        GLOverlayBundle.nativeAddGLOverlay(this.mNativeInstance, ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).getNativeInstatnce(), ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).getCode());
        List<E> list = this.mOverlayList;
        synchronized (list) {
            this.mOverlayList.add(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOverlay(E e2) {
        if (e2 == null) {
            return;
        }
        GLOverlayBundle.nativeRemoveGLOverlay(this.mNativeInstance, ((GLOverlay)((BaseMapOverlay)e2).getGLOverlay()).getNativeInstatnce());
        List<E> list = this.mOverlayList;
        synchronized (list) {
            this.mOverlayList.remove(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean bl2) {
        GLOverlayBundle.nativeClearAllGLOverlay(this.mNativeInstance, bl2);
        List<E> list = this.mOverlayList;
        synchronized (list) {
            this.mOverlayList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFocus() {
        if (this.mOverlayList != null) {
            List<E> list = this.mOverlayList;
            synchronized (list) {
                for (int i2 = 0; i2 < this.mOverlayList.size(); ++i2) {
                    BaseMapOverlay baseMapOverlay = (BaseMapOverlay)this.mOverlayList.get(i2);
                    if (baseMapOverlay == null) continue;
                    baseMapOverlay.clearFocus();
                }
            }
        }
    }

    public boolean hasOverlayTextureItem(int n2, int n3) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GLOverlayTexture getOverlayTextureItem(int n2, int n3) {
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            return (GLOverlayTexture)this.mTextureCaches.get(n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOverlayTextureItem(int n2, int n3, int n4, int n5) {
        GLOverlayTexture gLOverlayTexture = new GLOverlayTexture(n2, n3, n4, n5);
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            this.mTextureCaches.put(n2, (Object)gLOverlayTexture);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOverlayTextureItem(int n2, int n3, float f2, float f3, int n4, int n5) {
        GLOverlayTexture gLOverlayTexture = new GLOverlayTexture(n2, n3, f2, f3, n4, n5);
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            this.mTextureCaches.put(n2, (Object)gLOverlayTexture);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOverlayTexture() {
        SparseArray<GLOverlayTexture> sparseArray = this.mTextureCaches;
        synchronized (sparseArray) {
            this.mTextureCaches.clear();
        }
    }

    private static native void nativeAddGLOverlay(long var0, long var2, long var4);

    private static native void nativeRemoveGLOverlay(long var0, long var2);

    private static native void nativeClearAllGLOverlay(long var0, boolean var2);

    private static native boolean nativeOnSingleTapPointOverlay(long var0, int var2, int var3, long[] var4);

    private static native boolean nativeOnSingleTapLineOverlay(long var0, int var2, int var3, long[] var4);

    public static class GLAmapFocusHits {
        public long mOverlayHashCode = 0L;
        public long mHitedIndex = 0L;
        public long mHitedTimes = 1000L;
    }
}

