/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import android.text.TextUtils;
import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.maploader.BaseMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.utils.GLConvertUtil;
import com.autonavi.ae.gmap.utils.GLMapUtil;
import java.io.UnsupportedEncodingException;

public class GuideMapLoader
extends BaseMapLoader {
    protected String mScenicAoiID = "";

    public GuideMapLoader(int n2, GLMapEngine gLMapEngine, int n3) {
        super(n2);
        this.mGLMapEngine = gLMapEngine;
        this.mDataSource = n3;
        this.mCreateTime = System.currentTimeMillis();
    }

    public GuideMapLoader(int n2, GLMapEngine gLMapEngine, int n3, String string) {
        super(n2);
        this.mGLMapEngine = gLMapEngine;
        this.mDataSource = n3;
        this.mCreateTime = System.currentTimeMillis();
        this.mScenicAoiID = string;
    }

    protected String getMapAddress() {
        String string = null;
        string = this.mDataSource == 101 ? "http://m5.amap.com/" : this.mGLMapEngine.getMapSvrAddress();
        return string;
    }

    protected String getMapServerPath() {
        String string = null;
        switch (this.mDataSource) {
            case 11: {
                string = "/ws/mps/spot?";
                break;
            }
            case 101: {
                string = "/ws/valueadded/scenic/scenic_widget/?";
                break;
            }
        }
        return string;
    }

    protected String getGridParams() {
        String string = null;
        string = this.mDataSource == 101 ? this.getScenicWidgetRequestParams() : this.getGridParmaV4();
        string = string + "&channel=amapapi";
        return string;
    }

    protected boolean processReceivedDataHeader() {
        try {
            if (this.mReceivedDataSize > 7) {
                int n2 = 0;
                int n3 = GLConvertUtil.getInt(this.mReceivedDataBuffer, n2);
                if (n3 != 0) {
                    this.doCancel();
                    return false;
                }
                n2 += 4;
                this.mReceivedDataSize -= (n2 += 4);
                if (this.mReceivedDataSize > 0) {
                    GLConvertUtil.moveArray(this.mReceivedDataBuffer, n2, this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
                }
                this.mNextImgDataLength = 0;
                this.isReceivedHeader = true;
                super.processReceivedData();
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    protected void processReceivedDataByType() {
        try {
            super.processReceivedData();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedVersion() {
        try {
            if (this.mDataSource == 9) {
                super.processReceivedVersionData(this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
            } else if (this.mDataSource == 101) {
                this.processScenicWidgetData(this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void processReceivedTileData(byte[] byArray, int n2, int n3) {
        try {
            if (0 == n2) {
                super.processReceivedTileData(byArray, n2, n3);
            } else if (this.mDataSource == 11) {
                this.processReceivedTileDataBmp(byArray, n2, n3);
            } else {
                super.processReceivedTileData(byArray, n2, n3);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isRequestValid() {
        if (this.mDataSource == 101) {
            return true;
        }
        return this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
    }

    protected boolean isNeedReturn() {
        return this.mDataSource == 101 || this.mDataSource == 9;
    }

    protected void processReceivedTileDataBmp(byte[] byArray, int n2, int n3) throws UnsupportedEncodingException {
        int n4 = n2;
        n2 += 4;
        byte by2 = byArray[n2++];
        String string = "";
        if (by2 > 0 && n2 + by2 - 1 < n3) {
            string = new String(byArray, n2, (int)by2, "utf-8");
        }
        n2 += by2;
        if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
            return;
        }
        if (this.mGLMapEngine.putMapData(this.mEngineID, byArray, n4, n3 - n4, this.mDataSource, 0)) {
            // empty if block
        }
        int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
        boolean bl2 = true;
        if (n5 == string.length()) {
            boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
        }
        if (bl2) {
            super.doCancel();
        }
    }

    private String getGridParmaV4() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ";";
        for (int i2 = 0; i2 < this.mMapTiles.size(); ++i2) {
            String string2 = ((MapSourceGridData)this.mMapTiles.get(i2)).getGridName();
            if (TextUtils.isEmpty((CharSequence)string2) || super.isContainIllegal(string2) || !GLMapUtil.isAssic(string2)) continue;
            stringBuffer.append(string2 + string);
        }
        String string3 = stringBuffer.toString();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        while (string3.endsWith(string) || string3.endsWith(" ")) {
            string3 = stringBuffer.substring(0, string3.length() - 1);
        }
        if (string3.length() <= 0) {
            return null;
        }
        if (this.mDataSource == 11) {
            return "mesh=" + string3;
        }
        return null;
    }

    private void processScenicWidgetData(byte[] byArray, int n2, int n3) {
        if (null != byArray && 0 < n3 && n3 <= byArray.length) {
            this.mGLMapEngine.putScenicData(this.mEngineID, byArray, n3, this.mScenicAoiID);
        }
    }

    private String getScenicWidgetRequestParams() {
        return "";
    }
}

