/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.ae.gmap.maploader;

import android.text.TextUtils;
import com.autonavi.ae.gmap.GLMapEngine;
import com.autonavi.ae.gmap.maploader.BaseMapLoader;
import com.autonavi.ae.gmap.maploader.MapSourceGridData;
import com.autonavi.ae.gmap.utils.GLConvertUtil;
import com.autonavi.ae.gmap.utils.GLMapUtil;

public class HeatMapLoader
extends BaseMapLoader {
    private String mMapHeatPoiId = null;

    public void setMapHeatPoiId(String string) {
        this.mMapHeatPoiId = string;
    }

    public HeatMapLoader(int n2, GLMapEngine gLMapEngine, int n3) {
        super(n2);
        this.mGLMapEngine = gLMapEngine;
        this.mDataSource = n3;
        this.mCreateTime = System.currentTimeMillis();
    }

    protected String getMapAddress() {
        return this.mGLMapEngine.getMapSvrAddress();
    }

    protected String getMapServerPath() {
        return "/ws/mps/hot/?";
    }

    protected String getGridParams() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = ";";
        for (int i2 = 0; i2 < this.mMapTiles.size(); ++i2) {
            String string2 = ((MapSourceGridData)this.mMapTiles.get(i2)).getGridName();
            if (TextUtils.isEmpty((CharSequence)string2) || super.isContainIllegal(string2) || !GLMapUtil.isAssic(string2)) continue;
            stringBuffer.append(string2 + string);
        }
        String string3 = stringBuffer.toString();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            return null;
        }
        while (string3.endsWith(string) || string3.endsWith(" ")) {
            string3 = stringBuffer.substring(0, string3.length() - 1);
        }
        if (string3.length() <= 0) {
            return null;
        }
        string3 = string3 + "&channel=amapapi";
        return "cp=1&mesh=" + string3 + "&poiid=" + this.mMapHeatPoiId;
    }

    protected boolean processReceivedDataHeader() {
        if (this.mReceivedDataSize > 7) {
            int n2 = 0;
            int n3 = GLConvertUtil.getInt(this.mReceivedDataBuffer, n2);
            if (n3 != 0) {
                this.doCancel();
                return false;
            }
            n2 += 4;
            this.mReceivedDataSize -= (n2 += 4);
            if (this.mReceivedDataSize > 0) {
                GLConvertUtil.moveArray(this.mReceivedDataBuffer, n2, this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
            }
            this.mNextImgDataLength = 0;
            this.isReceivedHeader = true;
            super.processReceivedData();
            return true;
        }
        return false;
    }

    protected void processReceivedDataByType() {
        super.processReceivedData();
    }

    protected void processReceivedVersion() {
        if (this.mDataSource == 9) {
            this.processReceivedVersionData(this.mReceivedDataBuffer, 0, this.mReceivedDataSize);
        }
    }

    protected void processReceivedTileData(byte[] byArray, int n2, int n3) {
        if (0 == n2) {
            super.processReceivedTileData(byArray, n2, n3);
        } else {
            this.processReceivedTileDataBmp(byArray, n2, n3);
        }
    }

    public boolean isRequestValid() {
        return this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
    }

    protected boolean isNeedReturn() {
        return this.mDataSource == 9;
    }

    protected void processReceivedTileDataBmp(byte[] byArray, int n2, int n3) {
        try {
            int n4 = n2;
            n2 += 4;
            byte by2 = byArray[n2++];
            String string = "";
            if (by2 > 0 && n2 + by2 - 1 < n3) {
                string = new String(byArray, n2, (int)by2, "utf-8");
            }
            n2 += by2;
            if (!this.mGLMapEngine.isMapEngineValid() || n3 <= n4) {
                return;
            }
            this.mGLMapEngine.putMapHeatData(this.mEngineID, byArray, n4, n3 - n4, 0, this.mMapHeatPoiId);
            int n5 = this.mGLMapEngine.GetCurrentGrideNameLen(this.mEngineID);
            boolean bl2 = true;
            if (n5 == string.length()) {
                boolean bl3 = bl2 = !this.mGLMapEngine.isGridsInScreen(this.mEngineID, this.mMapTiles, this.mDataSource);
            }
            if (bl2) {
                super.doCancel();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

